package com.ebmwebsourcing.wsstar.basenotification.datatypes.impl.impl;

import java.util.Date;
import java.util.logging.Logger;

import com.ebmwebsourcing.wsstar.basefaults.datatypes.impl.impl.BaseFaultTypeImpl;
import com.ebmwebsourcing.wsstar.basefaults.datatypes.impl.utils.WsrfbfUtils;
import com.ebmwebsourcing.wsstar.basenotification.datatypes.api.abstraction.NoCurrentMessageOnTopicFaultType;
import com.ebmwebsourcing.wsstar.basenotification.datatypes.impl.WsnbJAXBContext;

import easybox.org.oasis_open.docs.wsn.b_2.EJaxbNoCurrentMessageOnTopicFaultType;

public class NoCurrentMessageOnTopicFaultTypeImpl extends BaseFaultTypeImpl
		implements NoCurrentMessageOnTopicFaultType {
	/**
	 * Default constructor
	 * 
	 * Note : According to the xml schema the "timestamp" field is mandatory
	 * 
	 * @param timestamp the timestamp of the {@link NoCurrentMessageOnTopicFaultType) object that must
	 * 		  be {@link Date} representation of an Date xml type.
	 */
	protected NoCurrentMessageOnTopicFaultTypeImpl(Date timestamp){
		super(Logger.getLogger(NoCurrentMessageOnTopicFaultTypeImpl.class.getSimpleName()));
		
		EJaxbNoCurrentMessageOnTopicFaultType jaxbTypeObj = 
			new EJaxbNoCurrentMessageOnTopicFaultType();
		
		jaxbTypeObj.setTimestamp(WsrfbfUtils.toXMLGregorianCalendar(timestamp, this.getLogger()));
		
		this.setJaxbTypeObj(jaxbTypeObj);
	}
	
	protected NoCurrentMessageOnTopicFaultTypeImpl(EJaxbNoCurrentMessageOnTopicFaultType jaxbTypeObj){
		super(jaxbTypeObj,Logger.getLogger(NoCurrentMessageOnTopicFaultTypeImpl.class.getSimpleName()));
	}
	
	/**
	 * A way to create a  {@link EJaxbNoCurrentMessageOnTopicFaultType}
	 *  "Jaxb model type" object from a {@link NoCurrentMessageOnTopicFaultType} "api type" one  
	 *    
	 * @param apiTypeObj
	 */
	public static EJaxbNoCurrentMessageOnTopicFaultType toJaxbModel(NoCurrentMessageOnTopicFaultType apiTypeObj){

		EJaxbNoCurrentMessageOnTopicFaultType jaxbTypeObj = null;

		if (apiTypeObj instanceof NoCurrentMessageOnTopicFaultTypeImpl) {
			jaxbTypeObj = (EJaxbNoCurrentMessageOnTopicFaultType)
			((NoCurrentMessageOnTopicFaultTypeImpl)apiTypeObj).getJaxbTypeObj();
		} else {
			jaxbTypeObj = (EJaxbNoCurrentMessageOnTopicFaultType) 
			BaseFaultTypeImpl.toJaxbModel(apiTypeObj,
					WsnbJAXBContext.WSNB_JAXB_FACTORY.createEJaxbNoCurrentMessageOnTopicFaultType());
		}
		return jaxbTypeObj;
	}
}
