package com.ebmwebsourcing.wsstar.basenotification.datatypes.impl.impl;

import java.util.Date;
import java.util.logging.Logger;

import com.ebmwebsourcing.wsstar.basefaults.datatypes.impl.impl.BaseFaultTypeImpl;
import com.ebmwebsourcing.wsstar.basefaults.datatypes.impl.utils.WsrfbfUtils;
import com.ebmwebsourcing.wsstar.basenotification.datatypes.api.abstraction.UnableToDestroySubscriptionFaultType;
import com.ebmwebsourcing.wsstar.basenotification.datatypes.impl.WsnbJAXBContext;

import easybox.org.oasis_open.docs.wsn.b_2.EJaxbUnableToDestroySubscriptionFaultType;

public class UnableToDestroySubscriptionFaultTypeImpl extends BaseFaultTypeImpl
		implements UnableToDestroySubscriptionFaultType {
	/**
	 * Default constructor
	 * 
	 * Note : According to the xml schema the "timestamp" field is mandatory
	 * 
	 * @param timestamp the timestamp of the {@link UnableToDestroySubscriptionFaultType) object that must
	 * 		  be {@link Date} representation of an Date xml type.
	 */
	protected UnableToDestroySubscriptionFaultTypeImpl(Date timestamp){
		super(Logger.getLogger(UnableToDestroySubscriptionFaultTypeImpl.class.getSimpleName()));

		EJaxbUnableToDestroySubscriptionFaultType jaxbTypeObj = 
			new EJaxbUnableToDestroySubscriptionFaultType();
		
		jaxbTypeObj.setTimestamp(WsrfbfUtils.toXMLGregorianCalendar(timestamp, this.getLogger()));
		
		this.setJaxbTypeObj(jaxbTypeObj);
	}

	protected UnableToDestroySubscriptionFaultTypeImpl(EJaxbUnableToDestroySubscriptionFaultType jaxbTypeObj){
		super(jaxbTypeObj,Logger.getLogger(UnableToDestroySubscriptionFaultTypeImpl.class.getSimpleName()));
	}

	/**
	 * A way to create a  {@link EJaxbUnableToDestroySubscriptionFaultType}
	 *  "Jaxb model type" object from a {@link UnableToDestroySubscriptionFaultType} "api type" one  
	 *    
	 * @param apiTypeObj
	 */
	public static EJaxbUnableToDestroySubscriptionFaultType toJaxbModel(UnableToDestroySubscriptionFaultType apiTypeObj){

		EJaxbUnableToDestroySubscriptionFaultType jaxbTypeObj = null;

		if (apiTypeObj instanceof UnableToDestroySubscriptionFaultTypeImpl) {
			jaxbTypeObj = (EJaxbUnableToDestroySubscriptionFaultType)
			((UnableToDestroySubscriptionFaultTypeImpl)apiTypeObj).getJaxbTypeObj();
		} else {
			jaxbTypeObj = (EJaxbUnableToDestroySubscriptionFaultType) 
			BaseFaultTypeImpl.toJaxbModel(apiTypeObj,
					WsnbJAXBContext.WSNB_JAXB_FACTORY.createEJaxbUnableToDestroySubscriptionFaultType());
		}
		return jaxbTypeObj;
	}
}