package com.ebmwebsourcing.wsstar.basenotification.datatypes.impl.impl;

import java.util.Date;
import java.util.List;
import java.util.logging.Logger;

import javax.xml.namespace.QName;

import com.ebmwebsourcing.wsstar.basefaults.datatypes.impl.impl.BaseFaultTypeImpl;
import com.ebmwebsourcing.wsstar.basefaults.datatypes.impl.utils.WsrfbfUtils;
import com.ebmwebsourcing.wsstar.basenotification.datatypes.api.abstraction.InvalidFilterFaultType;
import com.ebmwebsourcing.wsstar.basenotification.datatypes.impl.WsnbJAXBContext;

import easybox.org.oasis_open.docs.wsn.b_2.EJaxbInvalidFilterFaultType;

public class InvalidFilterFaultTypeImpl extends BaseFaultTypeImpl implements
		InvalidFilterFaultType {
	/**
	 * Default constructor
	 * 
	 * Note : According to the xml schema the "timestamp" field is mandatory
	 * 
	 * @param timestamp the timestamp of the {@link InvalidFilterFaultType) object that must
	 * 		  be {@link Date} representation of an Date xml type.
	 * @param unknownFilters TODO
	 */
	protected InvalidFilterFaultTypeImpl(Date timestamp, List<QName> unknownFilters){
		super(Logger.getLogger(InvalidFilterFaultTypeImpl.class.getSimpleName()));
		
		EJaxbInvalidFilterFaultType jaxbTypeObj = 
			new EJaxbInvalidFilterFaultType();
		
		jaxbTypeObj.setTimestamp(WsrfbfUtils.toXMLGregorianCalendar(timestamp, this.getLogger()));
		
		((EJaxbInvalidFilterFaultType)jaxbTypeObj).getUnknownFilter().addAll(unknownFilters);
		
		this.setJaxbTypeObj(jaxbTypeObj);
	}
	
	protected InvalidFilterFaultTypeImpl(EJaxbInvalidFilterFaultType jaxbTypeObj){
		super(jaxbTypeObj,Logger.getLogger(InvalidFilterFaultTypeImpl.class.getSimpleName()));
	}
	
	@Override
	public final List<QName> getUnknwonFilters() {
		return ((EJaxbInvalidFilterFaultType)this.getJaxbTypeObj()).getUnknownFilter();
	}
	
	@Override
	public final void addUnknwonFilter(QName value) {
		((EJaxbInvalidFilterFaultType)this.getJaxbTypeObj()).getUnknownFilter().add(value);
	}
	
	
	/**
	 * A way to create a  {@link EJaxbInvalidFilterFaultType}
	 *  "Jaxb model type" object from a {@link InvalidFilterFaultType} "api type" one  
	 *    
	 * @param apiTypeObj
	 */
	public static EJaxbInvalidFilterFaultType toJaxbModel(InvalidFilterFaultType apiTypeObj){

		EJaxbInvalidFilterFaultType jaxbTypeObj = null;
		
		if (apiTypeObj instanceof InvalidFilterFaultTypeImpl) {
			jaxbTypeObj = (EJaxbInvalidFilterFaultType)
				((InvalidFilterFaultTypeImpl)apiTypeObj).getJaxbTypeObj();
		} else {
			jaxbTypeObj = (EJaxbInvalidFilterFaultType) 
				BaseFaultTypeImpl.toJaxbModel(apiTypeObj,
						WsnbJAXBContext.WSNB_JAXB_FACTORY.createEJaxbInvalidFilterFaultType());
			
			// ~~~~ Set UnknownFilter QNames (at least one) ~~~~~
			jaxbTypeObj.getUnknownFilter().addAll(apiTypeObj.getUnknwonFilters());
		}
		return jaxbTypeObj;
	}
	
}
