package com.ebmwebsourcing.wsstar.basenotification.datatypes.impl.impl;

import java.util.Date;
import java.util.logging.Logger;

import com.ebmwebsourcing.wsstar.basefaults.datatypes.impl.impl.BaseFaultTypeImpl;
import com.ebmwebsourcing.wsstar.basefaults.datatypes.impl.utils.WsrfbfUtils;
import com.ebmwebsourcing.wsstar.basenotification.datatypes.api.abstraction.TopicNotSupportedFaultType;
import com.ebmwebsourcing.wsstar.basenotification.datatypes.impl.WsnbJAXBContext;

import easybox.org.oasis_open.docs.wsn.b_2.EJaxbTopicNotSupportedFaultType;

public class TopicNotSupportedFaultTypeImpl extends BaseFaultTypeImpl implements
		TopicNotSupportedFaultType {
	/**
	 * Default constructor
	 * 
	 * Note : According to the xml schema the "timestamp" field is mandatory
	 * 
	 * @param timestamp the timestamp of the {@link TopicNotSupportedFaultType) object that must
	 * 		  be {@link Date} representation of an Date xml type.
	 */
	protected TopicNotSupportedFaultTypeImpl(Date timestamp){
		super(Logger.getLogger(TopicNotSupportedFaultTypeImpl.class.getSimpleName()));
		
		EJaxbTopicNotSupportedFaultType jaxbTypeObj = 
			new EJaxbTopicNotSupportedFaultType();
		
		jaxbTypeObj.setTimestamp(WsrfbfUtils.toXMLGregorianCalendar(timestamp, this.getLogger()));
		
		this.setJaxbTypeObj(jaxbTypeObj);
	}
	
	protected TopicNotSupportedFaultTypeImpl(EJaxbTopicNotSupportedFaultType jaxbTypeObj){
		super(jaxbTypeObj,Logger.getLogger(TopicNotSupportedFaultTypeImpl.class.getSimpleName()));
	}
	
	/**
	 * A way to create a  {@link EJaxbTopicNotSupportedFaultType}
	 *  "Jaxb model type" object from a {@link TopicNotSupportedFaultType} "api type" one  
	 *    
	 * @param apiTypeObj
	 */
	public static EJaxbTopicNotSupportedFaultType toJaxbModel(TopicNotSupportedFaultType apiTypeObj){

		EJaxbTopicNotSupportedFaultType jaxbTypeObj = null;

		if (apiTypeObj instanceof TopicNotSupportedFaultTypeImpl) {
			jaxbTypeObj = (EJaxbTopicNotSupportedFaultType)
			((TopicNotSupportedFaultTypeImpl)apiTypeObj).getJaxbTypeObj();
		} else {
			jaxbTypeObj = (EJaxbTopicNotSupportedFaultType) 
			BaseFaultTypeImpl.toJaxbModel(apiTypeObj,
					WsnbJAXBContext.WSNB_JAXB_FACTORY.createEJaxbTopicNotSupportedFaultType());
		}
		return jaxbTypeObj;
	}
}
