package com.ebmwebsourcing.wsstar.basenotification.datatypes.impl.impl;

import java.util.List;

import org.w3c.dom.Element;

import com.ebmwebsourcing.wsstar.basenotification.datatypes.api.abstraction.Unsubscribe;
import com.ebmwebsourcing.wsstar.basenotification.datatypes.impl.WsnbJAXBContext;

import easybox.org.oasis_open.docs.wsn.b_2.EJaxbUnsubscribe;

public class UnsubscribeImpl implements Unsubscribe {
	
	private EJaxbUnsubscribe jaxbTypeObj;
	
	/**
	 * Default constructor
	 */
	protected UnsubscribeImpl() {		
		this.jaxbTypeObj = WsnbJAXBContext.WSNB_JAXB_FACTORY.createEJaxbUnsubscribe();		
	}

	protected UnsubscribeImpl(EJaxbUnsubscribe jaxbTypeObj){
		this.jaxbTypeObj = jaxbTypeObj;
	}
	
	protected final EJaxbUnsubscribe getJaxbTypeObj() {
		return jaxbTypeObj;
	}
	
	/**
	 * A way to create a  {@link com.ebmwebsourcing.wsstar.notification.base.Unsubscribe}
	 *  "Jaxb model type" object from a {@link Unsubscribe} "api type" one  
	 *    
	 * @param apiTypeObj
	 */
	public static EJaxbUnsubscribe toJaxbModel(Unsubscribe apiTypeObj) {

		EJaxbUnsubscribe jaxbTypeObj = null;
		
		if (apiTypeObj instanceof UnsubscribeImpl){
			jaxbTypeObj = ((UnsubscribeImpl)apiTypeObj).getJaxbTypeObj();
		} else { 
			jaxbTypeObj = WsnbJAXBContext.WSNB_JAXB_FACTORY.createEJaxbUnsubscribe();
		}
		return jaxbTypeObj;
	}

	@Override
	public void addAny(Element elmt) {
		this.jaxbTypeObj.getAny().add(elmt);
	}

	@Override
	public List<Object> getAny() {
		return this.jaxbTypeObj.getAny();
	}
}
