/*
 * Decompiled with CFR 0.152.
 */
package com.ebmwebsourcing.wsstar.wsnb.services.impl.util;

import com.ebmwebsourcing.wsaddressing10.api.type.ReferenceParametersType;
import com.ebmwebsourcing.wsstar.basefaults.datatypes.api.implementor.WsrfbfModelFactory;
import com.ebmwebsourcing.wsstar.basefaults.datatypes.api.refinedabstraction.RefinedWsrfbfFactory;
import com.ebmwebsourcing.wsstar.basenotification.datatypes.api.WsnbConstants;
import com.ebmwebsourcing.wsstar.basenotification.datatypes.api.abstraction.WsnbReader;
import com.ebmwebsourcing.wsstar.basenotification.datatypes.api.abstraction.WsnbWriter;
import com.ebmwebsourcing.wsstar.basenotification.datatypes.api.implementor.WsnbModelFactory;
import com.ebmwebsourcing.wsstar.basenotification.datatypes.api.refinedabstraction.RefinedWsnbFactory;
import com.ebmwebsourcing.wsstar.basenotification.datatypes.api.utils.WsnbException;
import com.ebmwebsourcing.wsstar.basenotification.datatypes.impl.utils.WsstarCommonUtils;
import com.ebmwebsourcing.wsstar.resource.datatypes.api.implementor.WsrfrModelFactory;
import com.ebmwebsourcing.wsstar.resource.datatypes.api.refinedabstraction.RefinedWsrfrFactory;
import com.ebmwebsourcing.wsstar.resourcelifetime.datatypes.api.WsrfrlConstants;
import com.ebmwebsourcing.wsstar.resourcelifetime.datatypes.api.abstraction.WsrfrlReader;
import com.ebmwebsourcing.wsstar.resourcelifetime.datatypes.api.abstraction.WsrfrlWriter;
import com.ebmwebsourcing.wsstar.resourcelifetime.datatypes.api.implementor.WsrfrlModelFactory;
import com.ebmwebsourcing.wsstar.resourcelifetime.datatypes.api.refinedabstraction.RefinedWsrfrlFactory;
import com.ebmwebsourcing.wsstar.resourcelifetime.datatypes.api.utils.WsrfrlException;
import com.ebmwebsourcing.wsstar.resourceproperties.datatypes.api.abstraction.WsrfrpReader;
import com.ebmwebsourcing.wsstar.resourceproperties.datatypes.api.abstraction.WsrfrpWriter;
import com.ebmwebsourcing.wsstar.resourceproperties.datatypes.api.implementor.WsrfrpModelFactory;
import com.ebmwebsourcing.wsstar.resourceproperties.datatypes.api.refinedabstraction.RefinedWsrfrpFactory;
import com.ebmwebsourcing.wsstar.resourceproperties.datatypes.api.utils.WsrfrpException;
import com.ebmwebsourcing.wsstar.topics.datatypes.api.abstraction.WstopReader;
import com.ebmwebsourcing.wsstar.topics.datatypes.api.abstraction.WstopWriter;
import com.ebmwebsourcing.wsstar.topics.datatypes.api.implementor.WstopModelFactory;
import com.ebmwebsourcing.wsstar.topics.datatypes.api.refinedabstraction.RefinedWstopFactory;
import com.ebmwebsourcing.wsstar.topics.datatypes.api.utils.WstopException;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import javax.xml.namespace.QName;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.xml.sax.SAXException;

public abstract class Wsnb4ServUtils {
    private static boolean isInit = false;
    private static WsrfrlReader wsrfrlReader = null;
    private static WsrfrlWriter wsrfrlWriter = null;
    private static WstopReader wstopReader = null;
    private static WstopWriter wstopWriter = null;
    private static WsnbReader wsnbReader = null;
    private static WsnbWriter wsnbWriter = null;
    private static WsrfrpReader wsrfrpReader = null;
    private static WsrfrpWriter wsrfrpWriter = null;

    public static WsnbReader getWsnbReader() throws WsnbException {
        if (wsnbReader == null) {
            wsnbReader = RefinedWsnbFactory.getInstance().getWsnbReader();
        }
        return wsnbReader;
    }

    public static WstopReader getWstopReader() throws WstopException {
        if (wstopReader == null) {
            wstopReader = RefinedWstopFactory.getInstance().getWstopReader();
        }
        return wstopReader;
    }

    public static WsrfrlReader getWsrfrlReader() throws WsrfrlException {
        if (wsrfrlReader == null) {
            wsrfrlReader = RefinedWsrfrlFactory.getInstance().getWsrfrlReader();
        }
        return wsrfrlReader;
    }

    public static WsrfrpReader getWsrfrpReader() throws WsrfrpException {
        if (wsrfrpReader == null) {
            wsrfrpReader = RefinedWsrfrpFactory.getInstance().getWsrfrpReader();
        }
        return wsrfrpReader;
    }

    public static WsnbWriter getWsnbWriter() throws WsnbException {
        if (wsnbWriter == null) {
            wsnbWriter = RefinedWsnbFactory.getInstance().getWsnbWriter();
        }
        return wsnbWriter;
    }

    public static WstopWriter getWstopWriter() throws WstopException {
        if (wstopWriter == null) {
            wstopWriter = RefinedWstopFactory.getInstance().getWstopWriter();
        }
        return wstopWriter;
    }

    public static WsrfrlWriter getWsrfrlWriter() throws WsrfrlException {
        if (wsrfrlWriter == null) {
            wsrfrlWriter = RefinedWsrfrlFactory.getInstance().getWsrfrlWriter();
        }
        return wsrfrlWriter;
    }

    public static WsrfrpWriter getWsrfrpWriter() throws WsrfrpException {
        if (wsrfrpWriter == null) {
            wsrfrpWriter = RefinedWsrfrpFactory.getInstance().getWsrfrpWriter();
        }
        return wsrfrpWriter;
    }

    public static void initModelFactories(WsrfbfModelFactory wsrfbfModFact, WsrfrModelFactory wsrfrModFact, WsrfrlModelFactory wsrfrlModFact, WsrfrpModelFactory wsrfrpModFact, WstopModelFactory wstopModFact, WsnbModelFactory wsnbModFact) {
        if (!isInit) {
            RefinedWsrfbfFactory.getInstance((WsrfbfModelFactory)wsrfbfModFact);
            RefinedWsrfrFactory.getInstance((WsrfrModelFactory)wsrfrModFact);
            RefinedWsrfrlFactory.getInstance((WsrfrlModelFactory)wsrfrlModFact);
            RefinedWsrfrpFactory.getInstance((WsrfrpModelFactory)wsrfrpModFact);
            RefinedWstopFactory.getInstance((WstopModelFactory)wstopModFact);
            RefinedWsnbFactory.getInstance((WsnbModelFactory)wsnbModFact);
            isInit = true;
        }
    }

    public static Document convertFromFiletoDocument(File file) throws WsnbException {
        Document result = null;
        try {
            DocumentBuilderFactory dbfac = DocumentBuilderFactory.newInstance();
            dbfac.setNamespaceAware(true);
            DocumentBuilder docBuilder = dbfac.newDocumentBuilder();
            result = docBuilder.parse(file);
        }
        catch (SAXException e) {
            throw new WsnbException((Throwable)e);
        }
        catch (IOException e) {
            throw new WsnbException((Throwable)e);
        }
        catch (ParserConfigurationException e) {
            throw new WsnbException((Throwable)e);
        }
        return result;
    }

    public static Element createSubscriptionIdAsReferenceParamElt(String uuid) {
        Element subscriptionUuidElt = null;
        DocumentBuilder docBuilder = WsstarCommonUtils.getNamespaceDocumentBuilder();
        Document document = docBuilder.newDocument();
        subscriptionUuidElt = document.createElementNS(WsnbConstants.SUBSCRIPTION_ID_QNAME_TAG.getNamespaceURI(), WsnbConstants.SUBSCRIPTION_ID_QNAME_TAG.getLocalPart());
        subscriptionUuidElt.setPrefix(WsnbConstants.SUBSCRIPTION_ID_QNAME_TAG.getPrefix());
        subscriptionUuidElt.setTextContent(uuid);
        return subscriptionUuidElt;
    }

    public static String getSubscriptionIdFromReferenceParams(ReferenceParametersType refParams) {
        String subscriptionUuid = null;
        ArrayList<Object> objs = new ArrayList<Object>();
        objs.addAll(Arrays.asList(refParams.getAny()));
        ArrayList<Element> paramsAsElt = new ArrayList<Element>();
        for (Object e : objs) {
            paramsAsElt.add((Element)e);
        }
        for (Element element : paramsAsElt) {
            if (!element.getLocalName().equals(WsnbConstants.SUBSCRIPTION_ID_QNAME_TAG.getLocalPart()) || !element.getNamespaceURI().equals(WsnbConstants.SUBSCRIPTION_ID_QNAME_TAG.getNamespaceURI())) continue;
            subscriptionUuid = element.getTextContent();
            break;
        }
        return subscriptionUuid;
    }

    public static Element createPropertyAsElement(QName propertyQName, String propertyValue) {
        Element propertyAsElt = null;
        DocumentBuilder docBuilder = WsstarCommonUtils.getNamespaceDocumentBuilder();
        Document doc = docBuilder.newDocument();
        propertyAsElt = doc.createElementNS(propertyQName.getNamespaceURI(), propertyQName.getLocalPart());
        propertyAsElt.setPrefix(propertyQName.getPrefix());
        propertyAsElt.setTextContent(propertyValue);
        return propertyAsElt;
    }

    public static Element createSimpleReasonElement(String reasonAsString) {
        Element reasonElt = null;
        DocumentBuilder docBuilder = WsstarCommonUtils.getNamespaceDocumentBuilder();
        Document doc = docBuilder.newDocument();
        reasonElt = doc.createElementNS(WsrfrlConstants.TERMINATION_REASON_QNAME.getNamespaceURI(), WsrfrlConstants.TERMINATION_REASON_QNAME.getLocalPart());
        reasonElt.setTextContent(reasonAsString);
        return reasonElt;
    }

    public static String prettyPrint(Document xmlDocument) {
        return WsstarCommonUtils.prettyPrint((Document)xmlDocument, (String)WsstarCommonUtils.getEncoding((Document)xmlDocument));
    }
}

