/*
 * Decompiled with CFR 0.152.
 */
package com.ebmwebsourcing.wsstar.wsnb.services.impl.topic;

import com.ebmwebsourcing.wsstar.basenotification.datatypes.api.utils.WsnbException;
import com.ebmwebsourcing.wsstar.wsnb.services.impl.util.Wsnb4ServUtils;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.xml.namespace.NamespaceContext;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathExpression;
import javax.xml.xpath.XPathExpressionException;
import javax.xml.xpath.XPathFactory;
import org.w3c.dom.Document;
import org.w3c.dom.NodeList;

class XPathDOMAnalyzer {
    private static Logger log = Logger.getLogger(XPathDOMAnalyzer.class.getName());

    XPathDOMAnalyzer() {
    }

    final synchronized NodeList evaluate(String xpathExpression, Document document, Map<String, String> contextMap) throws WsnbException {
        ArrayList<String> xpathExpressions = new ArrayList<String>();
        xpathExpressions.add(xpathExpression);
        NamespaceContextMap context = new NamespaceContextMap(contextMap);
        NodeList nodes = null;
        try {
            if (document != null) {
                for (String xpathExprItem : xpathExpressions) {
                    XPath engine = XPathFactory.newInstance().newXPath();
                    engine.setNamespaceContext(context);
                    XPathExpression expr = engine.compile(xpathExprItem);
                    Object result = expr.evaluate(document, XPathConstants.NODESET);
                    if (!(result instanceof NodeList)) continue;
                    nodes = (NodeList)result;
                    break;
                }
                if (nodes == null && log.isLoggable(Level.FINE)) {
                    log.fine("No xpath expressions " + xpathExpressions + " match with: \n " + Wsnb4ServUtils.prettyPrint(document.getOwnerDocument()));
                }
            }
        }
        catch (XPathExpressionException e) {
            throw new WsnbException((Throwable)e);
        }
        return nodes;
    }

    private class NamespaceContextMap
    implements NamespaceContext {
        private final Map<String, String> prefixMap;
        private final Map<String, Set<String>> nsMap;

        NamespaceContextMap(Map<String, String> prefixMappings) {
            this.prefixMap = this.createPrefixMap(prefixMappings);
            this.nsMap = this.createNamespaceMap(this.prefixMap);
        }

        private Map<String, String> createPrefixMap(Map<String, String> prefixMappings) {
            HashMap<String, String> prefixMap = new HashMap<String, String>(prefixMappings);
            this.addConstant(prefixMap, "xml", "http://www.w3.org/XML/1998/namespace");
            this.addConstant(prefixMap, "xmlns", "http://www.w3.org/2000/xmlns/");
            return Collections.unmodifiableMap(prefixMap);
        }

        private void addConstant(Map<String, String> prefixMap, String prefix, String nsURI) {
            String previous = prefixMap.put(prefix, nsURI);
            if (previous != null && !previous.equals(nsURI)) {
                throw new IllegalArgumentException(String.valueOf(prefix) + " -> " + previous + "; see NamespaceContext contract");
            }
        }

        private Map<String, Set<String>> createNamespaceMap(Map<String, String> prefixMap) {
            HashMap<String, Set<String>> nsMap = new HashMap<String, Set<String>>();
            for (Map.Entry<String, String> entry : prefixMap.entrySet()) {
                String nsURI = entry.getValue();
                HashSet<String> prefixes = (HashSet<String>)nsMap.get(nsURI);
                if (prefixes == null) {
                    prefixes = new HashSet<String>();
                    nsMap.put(nsURI, prefixes);
                }
                prefixes.add(entry.getKey());
            }
            for (Map.Entry<String, String> entry : nsMap.entrySet()) {
                Set readOnly = Collections.unmodifiableSet((Set)((Object)entry.getValue()));
                entry.setValue((String)((Object)readOnly));
            }
            return nsMap;
        }

        @Override
        public String getNamespaceURI(String prefix) {
            this.checkNotNull(prefix);
            String nsURI = this.prefixMap.get(prefix);
            return nsURI == null ? "" : nsURI;
        }

        @Override
        public String getPrefix(String namespaceURI) {
            this.checkNotNull(namespaceURI);
            Set<String> set = this.nsMap.get(namespaceURI);
            return set == null ? null : set.iterator().next();
        }

        @Override
        public Iterator<String> getPrefixes(String namespaceURI) {
            this.checkNotNull(namespaceURI);
            Set<String> set = this.nsMap.get(namespaceURI);
            return set.iterator();
        }

        private void checkNotNull(String value) {
            if (value == null) {
                throw new IllegalArgumentException("null");
            }
        }
    }
}

