/*
 * Decompiled with CFR 0.152.
 */
package com.ebmwebsourcing.wsstar.resourcelifetime.datatypes.api.test;

import com.ebmwebsourcing.wsaddressing10.api.type.EndpointReferenceType;
import com.ebmwebsourcing.wsstar.basefaults.datatypes.api.abstraction.BaseFaultType;
import com.ebmwebsourcing.wsstar.basefaults.datatypes.api.test.AbsWsrfbfTypesUnitTests;
import com.ebmwebsourcing.wsstar.basefaults.datatypes.api.test.util.WsaUnitTestsUtils;
import com.ebmwebsourcing.wsstar.resourcelifetime.datatypes.api.abstraction.CurrentTime;
import com.ebmwebsourcing.wsstar.resourcelifetime.datatypes.api.abstraction.Destroy;
import com.ebmwebsourcing.wsstar.resourcelifetime.datatypes.api.abstraction.DestroyResponse;
import com.ebmwebsourcing.wsstar.resourcelifetime.datatypes.api.abstraction.ResourceNotDestroyedFaultType;
import com.ebmwebsourcing.wsstar.resourcelifetime.datatypes.api.abstraction.ScheduledResourceTerminationRP;
import com.ebmwebsourcing.wsstar.resourcelifetime.datatypes.api.abstraction.SetTerminationTime;
import com.ebmwebsourcing.wsstar.resourcelifetime.datatypes.api.abstraction.SetTerminationTimeResponse;
import com.ebmwebsourcing.wsstar.resourcelifetime.datatypes.api.abstraction.TerminationNotification;
import com.ebmwebsourcing.wsstar.resourcelifetime.datatypes.api.abstraction.TerminationTime;
import com.ebmwebsourcing.wsstar.resourcelifetime.datatypes.api.abstraction.TerminationTimeChangeRejectedFaultType;
import com.ebmwebsourcing.wsstar.resourcelifetime.datatypes.api.abstraction.UnableToSetTerminationTimeFaultType;
import com.ebmwebsourcing.wsstar.resourcelifetime.datatypes.api.abstraction.WsrfrlFactory;
import com.ebmwebsourcing.wsstar.resourcelifetime.datatypes.api.abstraction.WsrfrlReader;
import com.ebmwebsourcing.wsstar.resourcelifetime.datatypes.api.abstraction.WsrfrlWriter;
import com.ebmwebsourcing.wsstar.resourcelifetime.datatypes.api.implementor.WsrfrlModelFactory;
import com.ebmwebsourcing.wsstar.resourcelifetime.datatypes.api.refinedabstraction.RefinedWsrfrlFactory;
import com.ebmwebsourcing.wsstar.resourcelifetime.datatypes.api.test.WsrfrlUnitTestsUtils;
import com.ebmwebsourcing.wsstar.resourcelifetime.datatypes.api.utils.WsrfrlException;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.Locale;
import javax.xml.datatype.DatatypeConfigurationException;
import javax.xml.datatype.DatatypeFactory;
import javax.xml.datatype.Duration;
import junit.framework.Assert;
import junit.framework.TestCase;
import org.junit.Test;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.xml.sax.SAXException;

public abstract class AbsWsrfrlFaultsTypesAndPayloadsUnitTests
extends TestCase {
    protected boolean isDebug = false;
    private WsrfrlFactory factory;
    protected WsrfrlModelFactory modelFactoryImpl;
    private WsrfrlReader reader;
    private WsrfrlWriter writer;

    protected void setUp() throws Exception {
        super.setUp();
        this.initRefinedWsrfrlFactory();
        this.initRequiredDependencyModelFactories();
    }

    protected abstract void setWsrfrlModelFactory();

    protected abstract void initRequiredDependencyModelFactories();

    public void initRefinedWsrfrlFactory() {
        if (this.modelFactoryImpl == null) {
            this.setWsrfrlModelFactory();
        }
        AbsWsrfrlFaultsTypesAndPayloadsUnitTests.assertNotNull((String)(WsaUnitTestsUtils.getFailedMessagePrefix((String)"OASIS \"WS-ResourceLifetime\"") + "the \"WsrfrlModelFactory\" implementation Object has not been set.\n" + "Please provide an instance of \"WsrfrlModelFactory\" implementation class"), (Object)this.modelFactoryImpl);
        if (this.factory == null) {
            this.factory = RefinedWsrfrlFactory.getInstance((WsrfrlModelFactory)this.modelFactoryImpl);
        }
        if (this.reader == null) {
            this.reader = this.factory.getWsrfrlReader();
        }
        if (this.writer == null) {
            this.writer = this.factory.getWsrfrlWriter();
        }
    }

    protected static boolean checkResourceNotDestroyedFaultType(ResourceNotDestroyedFaultType expectedFault, ResourceNotDestroyedFaultType toCheckFault, boolean isDebug) {
        return AbsWsrfbfTypesUnitTests.checkBaseFaultType((BaseFaultType)expectedFault, (BaseFaultType)toCheckFault, (String)"OASIS \"WS-ResourceLifetime\"", (boolean)isDebug);
    }

    protected static boolean checkTerminationTimeChangeRejectedFaultType(TerminationTimeChangeRejectedFaultType expectedFault, TerminationTimeChangeRejectedFaultType toCheckFault, boolean isDebug) {
        return AbsWsrfbfTypesUnitTests.checkBaseFaultType((BaseFaultType)expectedFault, (BaseFaultType)toCheckFault, (String)"OASIS \"WS-ResourceLifetime\"", (boolean)isDebug);
    }

    protected static boolean checkUnableToSetTerminationTimeFaultType(UnableToSetTerminationTimeFaultType expectedFault, UnableToSetTerminationTimeFaultType toCheckFault, boolean isDebug) {
        return AbsWsrfbfTypesUnitTests.checkBaseFaultType((BaseFaultType)expectedFault, (BaseFaultType)toCheckFault, (String)"OASIS \"WS-ResourceLifetime\"", (boolean)isDebug);
    }

    protected static boolean checkSetTerminationTime(SetTerminationTime expectedPayload, SetTerminationTime toCheckPayload, boolean isDebug) {
        Date expectedTerminationTime = expectedPayload.getRequestedTerminationTime();
        Date toCheckTerminationTime = toCheckPayload.getRequestedTerminationTime();
        Duration expectedDuration = expectedPayload.getRequestedLifetimeDuration();
        Duration toCheckDuration = toCheckPayload.getRequestedLifetimeDuration();
        if (isDebug) {
            System.out.println("[DEBUG] --> toCheckPayload requested termination time : " + (toCheckTerminationTime != null ? toCheckTerminationTime.toString() : null) + "\n[DEBUG] --> toCheckPayload requested lifetime duration : " + (toCheckDuration != null ? toCheckDuration.toString() : null) + "\n\n[DEBUG] --> expectedPayload requested termination time : " + (expectedTerminationTime != null ? expectedTerminationTime.toString() : null) + "\n[DEBUG] --> expectedPayload requested lifetime duration : " + (expectedDuration != null ? expectedDuration.toString() : null) + "\n");
        }
        Assert.assertTrue((String)(WsaUnitTestsUtils.getFailedMessagePrefix((String)"OASIS \"WS-ResourceLifetime\"") + "payload have different requested termination time values\n" + "\t(-> toCheckPayload requested termination time: " + (toCheckTerminationTime != null ? toCheckTerminationTime.toString() : null) + "\n\t-> expectedPayload  requested termination time: " + (expectedTerminationTime != null ? expectedTerminationTime.toString() : null)), (toCheckTerminationTime == expectedTerminationTime || toCheckTerminationTime != null && toCheckTerminationTime.equals(expectedTerminationTime) ? 1 : 0) != 0);
        Assert.assertTrue((String)(WsaUnitTestsUtils.getFailedMessagePrefix((String)"OASIS \"WS-ResourceLifetime\"") + "payload have different requested termination time values\n" + "\t(-> toCheckPayload lifetime duration : " + (toCheckDuration != null ? toCheckDuration.toString() : null) + "\n\t-> expectedPayload lifetime duration : " + (expectedDuration != null ? expectedDuration.toString() : null)), (toCheckDuration == expectedDuration || toCheckDuration != null && toCheckDuration.equals(expectedDuration) ? 1 : 0) != 0);
        return true;
    }

    protected static boolean checkSetTerminationTimeResponse(SetTerminationTimeResponse expectedPayload, SetTerminationTimeResponse toCheckPayload, boolean isDebug) {
        Date expectedCurrentTime = expectedPayload.getCurrentTime();
        Date toCheckCurrentTime = toCheckPayload.getCurrentTime();
        Date expectedNewTerminationTime = expectedPayload.getNewTerminationTime();
        Date toCheckNewTerminationTime = toCheckPayload.getNewTerminationTime();
        if (isDebug) {
            System.out.println("[DEBUG] --> toCheckPayload current time : " + (toCheckCurrentTime != null ? toCheckCurrentTime.toString() : null) + "\n[DEBUG] --> toCheckPayload new termination time : " + (toCheckNewTerminationTime != null ? toCheckNewTerminationTime.toString() : null) + "\n\n[DEBUG] --> expectedPayload current time : " + (expectedCurrentTime != null ? expectedCurrentTime.toString() : null) + "\n[DEBUG] --> expectedPayload new termination time : " + (expectedNewTerminationTime != null ? expectedNewTerminationTime.toString() : null) + "\n");
        }
        Assert.assertTrue((String)(WsaUnitTestsUtils.getFailedMessagePrefix((String)"OASIS \"WS-ResourceLifetime\"") + "payload have different content values\n" + "\t(-> toCheckPayload current time : " + (toCheckCurrentTime != null ? toCheckCurrentTime.toString() : null) + "\n\t-> toCheckPayload new termination time : " + (toCheckNewTerminationTime != null ? toCheckNewTerminationTime.toString() : null) + "\n\n\t-> expectedPayload current time : " + (expectedCurrentTime != null ? expectedCurrentTime.toString() : null) + "\n\t-> expectedPayload new termination time : " + (expectedNewTerminationTime != null ? expectedNewTerminationTime.toString() : null)), (toCheckCurrentTime == expectedCurrentTime || toCheckCurrentTime.equals(expectedCurrentTime) && toCheckNewTerminationTime == expectedNewTerminationTime || toCheckNewTerminationTime.equals(expectedNewTerminationTime) ? 1 : 0) != 0);
        return true;
    }

    protected static boolean checkDestroy(Destroy expectedPayload, Destroy toCheckPayload, boolean isDebug) {
        if (isDebug) {
            System.out.println("[DEBUG] --> toCheckPayload payload : " + toCheckPayload + "\n[DEBUG] --> expectedPayload payload : " + expectedPayload + "\n");
        }
        Assert.assertTrue((String)(WsaUnitTestsUtils.getFailedMessagePrefix((String)"OASIS \"WS-ResourceLifetime\"") + "payload are different \n" + "\t(-> toCheckPayload : " + toCheckPayload + "\n\t-> expectedPayload : " + expectedPayload), (toCheckPayload == expectedPayload || toCheckPayload != null && expectedPayload != null ? 1 : 0) != 0);
        return true;
    }

    protected static boolean checkDestroyResponse(DestroyResponse expectedPayload, DestroyResponse toCheckPayload, boolean isDebug) {
        if (isDebug) {
            System.out.println("[DEBUG] --> toCheckPayload payload : " + toCheckPayload + "\n[DEBUG] --> expectedPayload payload : " + expectedPayload + "\n");
        }
        Assert.assertTrue((String)(WsaUnitTestsUtils.getFailedMessagePrefix((String)"OASIS \"WS-ResourceLifetime\"") + "payload are \n" + "\t(-> toCheckPayload : " + toCheckPayload + "\n\t-> expectedPayload : " + expectedPayload), (toCheckPayload == expectedPayload || toCheckPayload != null && expectedPayload != null ? 1 : 0) != 0);
        return true;
    }

    protected static boolean checkTerminationNotification(TerminationNotification expectedNotification, TerminationNotification toCheckNotification, boolean isDebug) {
        String expectedReasonAsString;
        Date expectedTerminationTime = expectedNotification.getTerminationTime();
        Date toCheckTerminationTime = expectedNotification.getTerminationTime();
        if (isDebug) {
            System.out.println("[DEBUG] --> toCheckNotification termination time : " + (toCheckTerminationTime != null ? toCheckTerminationTime.toString() : "null") + "\n[DEBUG] --> expectedNotification termination time : " + (expectedTerminationTime != null ? expectedTerminationTime.toString() : "null") + "\n");
        }
        Assert.assertTrue((String)(WsaUnitTestsUtils.getFailedMessagePrefix((String)"OASIS \"WS-ResourceLifetime\"") + "TerminationNotification termination times are \n" + "\t(-> toCheckNotification termination time : " + (toCheckTerminationTime != null ? toCheckTerminationTime.toString() : "null") + "\n\t-> expectedNotification termination time : " + (expectedTerminationTime != null ? expectedTerminationTime.toString() : "null") + ")"), (expectedTerminationTime == toCheckTerminationTime || toCheckTerminationTime != null && toCheckTerminationTime.equals(expectedTerminationTime) ? 1 : 0) != 0);
        Object toCheckTermReason = toCheckNotification.getTerminationReason();
        Object expectedTermReason = expectedNotification.getTerminationReason();
        String toCheckReasonAsString = toCheckTermReason != null && toCheckTermReason instanceof Element ? WsaUnitTestsUtils.formatToComparison((Element)((Element)toCheckTermReason)) : null;
        String string = expectedReasonAsString = expectedTermReason != null && expectedTermReason instanceof Element ? WsaUnitTestsUtils.formatToComparison((Element)((Element)expectedTermReason)) : null;
        if (isDebug) {
            System.out.println("[DEBUG] --> toCheckTerminationReason : " + toCheckTermReason + "\n\t(nodesAsString = " + toCheckReasonAsString + ")" + "\n[DEBUG] --> expectedTerminationReason : " + expectedTermReason + "\n\t(nodesAsString = " + expectedReasonAsString + ")\n");
        }
        Assert.assertTrue((String)(WsaUnitTestsUtils.getFailedMessagePrefix((String)"OASIS \"WS-ResourceLifetime\"") + "TerminationNotification reason values are different \n" + "\t(-> toCheckNotification reason formatted to comparison is : " + (toCheckTermReason != null ? toCheckTermReason : null) + "\n\t(nodesAsString = " + toCheckReasonAsString + ")" + "\n\t-> expectedNotification reason formatted to comparison is : " + (expectedTermReason != null ? expectedTermReason : null) + ")" + "\n\t(nodesAsString = " + expectedReasonAsString + ")\n"), (toCheckReasonAsString == expectedReasonAsString || expectedReasonAsString != null && toCheckReasonAsString != null && toCheckReasonAsString.equals(expectedReasonAsString) ? 1 : 0) != 0);
        return true;
    }

    protected static boolean checkCurrentTime(CurrentTime expectedCurrentTime, CurrentTime toCheckCurrentTime, boolean isDebug) {
        Date expectedValue = expectedCurrentTime.getValue();
        Date toCheckValue = toCheckCurrentTime.getValue();
        if (isDebug) {
            System.out.println("[DEBUG] --> toCheckCurrentTime value : " + (toCheckValue != null ? toCheckValue.toString() : "null") + "\n[DEBUG] --> expectedCurrentTime value : " + (expectedValue != null ? expectedValue.toString() : "null") + "\n");
        }
        Assert.assertTrue((String)(WsaUnitTestsUtils.getFailedMessagePrefix((String)"OASIS \"WS-ResourceLifetime\"") + "CurrentTime value are \n" + "\t(-> toCheckCurrentTime value : " + (toCheckValue != null ? toCheckValue.toString() : "null") + "\n\t-> expectedCurrentTime value : " + (expectedValue != null ? expectedValue.toString() : "null")), (toCheckValue == expectedValue || toCheckValue != null && toCheckValue.equals(expectedValue) ? 1 : 0) != 0);
        return true;
    }

    protected static boolean checkTerminationTime(TerminationTime expectedTerminationTime, TerminationTime toCheckTerminationTime, boolean isDebug) {
        Date expectedValue = expectedTerminationTime.getValue();
        Date toCheckValue = toCheckTerminationTime.getValue();
        if (isDebug) {
            System.out.println("[DEBUG] --> toCheckTerminationTime value : " + (toCheckValue != null ? toCheckValue.toString() : "null") + "\n[DEBUG] --> expectedTerminationTime value : " + (expectedValue != null ? expectedValue.toString() : "null") + "\n");
        }
        Assert.assertTrue((String)(WsaUnitTestsUtils.getFailedMessagePrefix((String)"OASIS \"WS-ResourceLifetime\"") + "TerminationTime value are \n" + "\t(-> toCheckTerminationTime value : " + (toCheckValue != null ? toCheckValue.toString() : "null") + "\n\t-> expectedTerminationTime value : " + (expectedValue != null ? expectedValue.toString() : "null")), (toCheckValue == expectedValue || toCheckValue != null && toCheckValue.equals(expectedValue) ? 1 : 0) != 0);
        return true;
    }

    protected static boolean checkScheduledResourceTerminationRP(ScheduledResourceTerminationRP expectedSchResTemRP, ScheduledResourceTerminationRP toCheckSchResTemRP, boolean isDebug) {
        CurrentTime expectedCurrentTime = expectedSchResTemRP.getCurrentTime();
        CurrentTime toCheckCurrentTime = toCheckSchResTemRP.getCurrentTime();
        AbsWsrfrlFaultsTypesAndPayloadsUnitTests.checkCurrentTime(expectedCurrentTime, toCheckCurrentTime, isDebug);
        TerminationTime expectedTerminationTime = expectedSchResTemRP.getTerminationTime();
        TerminationTime toCheckTerminationTime = toCheckSchResTemRP.getTerminationTime();
        AbsWsrfrlFaultsTypesAndPayloadsUnitTests.checkTerminationTime(expectedTerminationTime, toCheckTerminationTime, isDebug);
        return true;
    }

    @Test
    public final void testCreateWriteAsDOMReadResourceNotDestroyedFaultType() throws WsrfrlException {
        System.out.println("\n\t ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~\n\t ~~~~~~~ unit test \"Create, Write-to-DOM and read-from-DOM ResourceNotDestroyedFaultType\" ~~~~~~~ \n");
        try {
            ResourceNotDestroyedFaultType defaultResourceNotDestroyedFault = this.factory.createResourceNotDestroyedFaultType(new Date());
            AbsWsrfbfTypesUnitTests.setBaseFaultContentType((BaseFaultType)defaultResourceNotDestroyedFault, (EndpointReferenceType)WsrfrlUnitTestsUtils.createDefaultBaseFaultOriginator(), (String)"Resource not destroyed because locked", (Locale)Locale.ENGLISH, (String)"468", (URI)new URI("http://www.ebmwebsourcing.com/dialect/wsrf/errors"), null);
            Document resourceNotDestroyedFaultAsDOM = this.writer.writeResourceNotDestroyedFaultTypeAsDOM(defaultResourceNotDestroyedFault);
            try {
                WsaUnitTestsUtils.validateResult((Document)resourceNotDestroyedFaultAsDOM, (String[])WsrfrlUnitTestsUtils.WSRFRL_XML_SCHEMAS_PATHS, (String)"OASIS \"WS-ResourceLifetime\"", ResourceNotDestroyedFaultType.class, (boolean)this.isDebug);
                System.out.println("\t Unit Test Step 1 (\"create\" and \"write to DOM\") : Passed !\n");
            }
            catch (SAXException e) {
                Assert.fail((String)(WsaUnitTestsUtils.getFailedMessagePrefix((String)"OASIS \"WS-ResourceLifetime\"") + e.getMessage()));
            }
            ResourceNotDestroyedFaultType readResourceNotDestroyedFault = this.reader.readResourceNotDestroyedFaultType(resourceNotDestroyedFaultAsDOM);
            AbsWsrfrlFaultsTypesAndPayloadsUnitTests.checkResourceNotDestroyedFaultType(defaultResourceNotDestroyedFault, readResourceNotDestroyedFault, this.isDebug);
            System.out.println("\t Unit Test Step 2 (\"read from DOM\") : Passed !");
            System.out.println("\n\t OK, unit test \"Create, Write-to-DOM and read-from-DOM ResourceNotDestroyedFaultType\" passed !\n\n\t ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~\n");
        }
        catch (URISyntaxException e1) {
            e1.printStackTrace();
        }
    }

    @Test
    public final void testCreateWriteAsDOMReadTerminationTimeChangeRejectedFaultType() throws WsrfrlException {
        System.out.println("\n\t ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~\n\t ~~~~~~~ unit test \"Create, Write-to-DOM and read-from-DOM TerminationTimeChangeRejectedFaultType\" ~~~~~~~ \n");
        try {
            TerminationTimeChangeRejectedFaultType defaultTerminationTimeChangeRejectedFault = this.factory.createTerminationTimeChangeRejectedFaultType(new Date());
            AbsWsrfbfTypesUnitTests.setBaseFaultContentType((BaseFaultType)defaultTerminationTimeChangeRejectedFault, (EndpointReferenceType)WsrfrlUnitTestsUtils.createDefaultBaseFaultOriginator(), (String)"New TerminationTime value must be not in the past !!", (Locale)Locale.ENGLISH, (String)"744", (URI)new URI("http://www.ebmwebsourcing.com/dialect/wsrf/errors"), null);
            Document terminationTimeChangeRejectedFaultAsDOM = this.writer.writeTerminationTimeChangeRejectedFaultTypeAsDOM(defaultTerminationTimeChangeRejectedFault);
            try {
                WsaUnitTestsUtils.validateResult((Document)terminationTimeChangeRejectedFaultAsDOM, (String[])WsrfrlUnitTestsUtils.WSRFRL_XML_SCHEMAS_PATHS, (String)"OASIS \"WS-ResourceLifetime\"", TerminationTimeChangeRejectedFaultType.class, (boolean)this.isDebug);
                System.out.println("\t Unit Test Step 1 (\"create\" and \"write to DOM\") : Passed !\n");
            }
            catch (SAXException e) {
                Assert.fail((String)(WsaUnitTestsUtils.getFailedMessagePrefix((String)"OASIS \"WS-ResourceLifetime\"") + e.getMessage()));
            }
            TerminationTimeChangeRejectedFaultType readTerminationTimeChangeRejectedFault = this.reader.readTerminationTimeChangeRejectedFaultType(terminationTimeChangeRejectedFaultAsDOM);
            AbsWsrfrlFaultsTypesAndPayloadsUnitTests.checkTerminationTimeChangeRejectedFaultType(defaultTerminationTimeChangeRejectedFault, readTerminationTimeChangeRejectedFault, this.isDebug);
            System.out.println("\t Unit Test Step 2 (\"read from DOM\") : Passed !");
            System.out.println("\n\t OK, unit test \"Create, Write-to-DOM and read-from-DOM TerminationTimeChangeRejectedFaultType\" passed !\n\n\t ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~\n");
        }
        catch (URISyntaxException e1) {
            e1.printStackTrace();
        }
    }

    @Test
    public final void testCreateWriteAsDOMReadUnableToSetTerminationTimeFaultType() throws WsrfrlException {
        System.out.println("\n\t ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~\n\t ~~~~~~~ unit test \"Create, Write-to-DOM and read-from-DOM UnableToSetTerminationTimeFaultType\" ~~~~~~~ \n");
        try {
            UnableToSetTerminationTimeFaultType defaultUnableToSetTerminationTimeFault = this.factory.createUnableToSetTerminationTimeFaultType(new Date());
            AbsWsrfbfTypesUnitTests.setBaseFaultContentType((BaseFaultType)defaultUnableToSetTerminationTimeFault, (EndpointReferenceType)WsrfrlUnitTestsUtils.createDefaultBaseFaultOriginator(), (String)"TerminationTime value must not be after the current time !!", (Locale)Locale.ENGLISH, (String)"745", (URI)new URI("http://www.ebmwebsourcing.com/dialect/wsrf/errors"), null);
            Document unableToSetTerminationTimeFaultAsDOM = this.writer.writeUnableToSetTerminationTimeFaultTypeAsDOM(defaultUnableToSetTerminationTimeFault);
            try {
                WsaUnitTestsUtils.validateResult((Document)unableToSetTerminationTimeFaultAsDOM, (String[])WsrfrlUnitTestsUtils.WSRFRL_XML_SCHEMAS_PATHS, (String)"OASIS \"WS-ResourceLifetime\"", UnableToSetTerminationTimeFaultType.class, (boolean)this.isDebug);
                System.out.println("\t Unit Test Step 1 (\"create\" and \"write to DOM\") : Passed !\n");
            }
            catch (SAXException e) {
                Assert.fail((String)(WsaUnitTestsUtils.getFailedMessagePrefix((String)"OASIS \"WS-ResourceLifetime\"") + e.getMessage()));
            }
            UnableToSetTerminationTimeFaultType readUnableToSetTerminationTimeFault = this.reader.readUnableToSetTerminationTimeFaultType(unableToSetTerminationTimeFaultAsDOM);
            AbsWsrfrlFaultsTypesAndPayloadsUnitTests.checkUnableToSetTerminationTimeFaultType(defaultUnableToSetTerminationTimeFault, readUnableToSetTerminationTimeFault, this.isDebug);
            System.out.println("\t Unit Test Step 2 (\"read from DOM\") : Passed !");
            System.out.println("\n\t OK, unit test \"Create, Write-to-DOM and read-from-DOM UnableToSetTerminationTimeFaultType\" passed !\n\n\t ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~\n");
        }
        catch (URISyntaxException e1) {
            e1.printStackTrace();
        }
    }

    @Test
    public final void testCreateWriteAsDOMReadSetTerminationTimeWithReqTermTime() throws WsrfrlException {
        System.out.println("\n\t ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~\n\t ~~~~~~~ unit test \"Create, Write-to-DOM and read-from-DOM SetTerminationTime with RequestedTerminationTime\" ~~~~~~~ \n");
        SetTerminationTime payload = this.factory.createSetTerminationTime(new Date());
        Document payloadAsDOM = this.writer.writeSetTerminationTimeAsDOM(payload);
        try {
            WsaUnitTestsUtils.validateResult((Document)payloadAsDOM, (String[])WsrfrlUnitTestsUtils.WSRFRL_XML_SCHEMAS_PATHS, (String)"OASIS \"WS-ResourceLifetime\"", SetTerminationTime.class, (boolean)this.isDebug);
            System.out.println("\t Unit Test Step 1 (\"create\" and \"write to DOM\") : Passed !\n");
        }
        catch (SAXException e) {
            Assert.fail((String)(WsaUnitTestsUtils.getFailedMessagePrefix((String)"OASIS \"WS-ResourceLifetime\"") + e.getMessage()));
        }
        SetTerminationTime readSetTerminationTime = this.reader.readSetTerminationTime(payloadAsDOM);
        AbsWsrfrlFaultsTypesAndPayloadsUnitTests.checkSetTerminationTime(payload, readSetTerminationTime, this.isDebug);
        System.out.println("\t Unit Test Step 2 (\"read from DOM\") : Passed !");
        System.out.println("\n\t OK, unit test \"Create, Write-to-DOM and read-from-DOM SetTerminationTime with RequestedTerminationTime\" passed !\n\n\t ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~\n");
    }

    @Test
    public final void testCreateWriteAsDOMReadSetTerminationTimeWithReqLifetimeDuration() throws WsrfrlException {
        System.out.println("\n\t ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~\n\t ~~~~~~~ unit test \"Create, Write-to-DOM and read-from-DOM SetTerminationTime with RequestedLifetimeDuration\" ~~~~~~~ \n");
        try {
            SetTerminationTime payload = this.factory.createSetTerminationTime(DatatypeFactory.newInstance().newDuration(1800000L));
            Document payloadAsDOM = this.writer.writeSetTerminationTimeAsDOM(payload);
            try {
                WsaUnitTestsUtils.validateResult((Document)payloadAsDOM, (String[])WsrfrlUnitTestsUtils.WSRFRL_XML_SCHEMAS_PATHS, (String)"OASIS \"WS-ResourceLifetime\"", SetTerminationTime.class, (boolean)this.isDebug);
                System.out.println("\t Unit Test Step 1 (\"create\" and \"write to DOM\") : Passed !\n");
            }
            catch (SAXException e) {
                Assert.fail((String)(WsaUnitTestsUtils.getFailedMessagePrefix((String)"OASIS \"WS-ResourceLifetime\"") + e.getMessage()));
            }
            SetTerminationTime readSetTerminationTime = this.reader.readSetTerminationTime(payloadAsDOM);
            AbsWsrfrlFaultsTypesAndPayloadsUnitTests.checkSetTerminationTime(payload, readSetTerminationTime, this.isDebug);
            System.out.println("\t Unit Test Step 2 (\"read from DOM\") : Passed !");
            System.out.println("\n\t OK, unit test \"Create, Write-to-DOM and read-from-DOM SetTerminationTime with RequestedLifetimeDuration\" passed !\n\n\t ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~\n");
        }
        catch (DatatypeConfigurationException e1) {
            e1.printStackTrace();
        }
    }

    @Test
    public final void testCreateWriteAsDOMReadSetTerminationTimeResponse() throws WsrfrlException {
        System.out.println("\n\t ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~\n\t ~~~~~~~ unit test \"Create, Write-to-DOM and read-from-DOM SetTerminationTimeResponse\" ~~~~~~~ \n");
        GregorianCalendar gCal = new GregorianCalendar();
        Date currTime = gCal.getTime();
        gCal.add(10, 1);
        Date termTime = gCal.getTime();
        SetTerminationTimeResponse payload = this.factory.createSetTerminationTimeResponse(currTime, termTime);
        Document payloadAsDOM = this.writer.writeSetTerminationTimeResponseAsDOM(payload);
        try {
            WsaUnitTestsUtils.validateResult((Document)payloadAsDOM, (String[])WsrfrlUnitTestsUtils.WSRFRL_XML_SCHEMAS_PATHS, (String)"OASIS \"WS-ResourceLifetime\"", SetTerminationTimeResponse.class, (boolean)this.isDebug);
            System.out.println("\t Unit Test Step 1 (\"create\" and \"write to DOM\") : Passed !\n");
        }
        catch (SAXException e) {
            Assert.fail((String)(WsaUnitTestsUtils.getFailedMessagePrefix((String)"OASIS \"WS-ResourceLifetime\"") + e.getMessage()));
        }
        SetTerminationTimeResponse readSetTerminationTimeResponse = this.reader.readSetTerminationTimeResponse(payloadAsDOM);
        AbsWsrfrlFaultsTypesAndPayloadsUnitTests.checkSetTerminationTimeResponse(payload, readSetTerminationTimeResponse, this.isDebug);
        System.out.println("\t Unit Test Step 2 (\"read from DOM\") : Passed !");
        System.out.println("\n\t OK, unit test \"Create, Write-to-DOM and read-from-DOM SetTerminationTimeResponse\" passed !\n\n\t ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~\n");
    }

    @Test
    public final void testCreateWriteAsDOMReadDestroy() throws WsrfrlException {
        System.out.println("\n\t ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~\n\t ~~~~~~~ unit test \"Create, Write-to-DOM and read-from-DOM Destroy\" ~~~~~~~ \n");
        Destroy payload = this.factory.createDestroy();
        Document payloadAsDOM = this.writer.writeDestroyAsDOM(payload);
        try {
            WsaUnitTestsUtils.validateResult((Document)payloadAsDOM, (String[])WsrfrlUnitTestsUtils.WSRFRL_XML_SCHEMAS_PATHS, (String)"OASIS \"WS-ResourceLifetime\"", Destroy.class, (boolean)this.isDebug);
            System.out.println("\t Unit Test Step 1 (\"create\" and \"write to DOM\") : Passed !\n");
        }
        catch (SAXException e) {
            Assert.fail((String)(WsaUnitTestsUtils.getFailedMessagePrefix((String)"OASIS \"WS-ResourceLifetime\"") + e.getMessage()));
        }
        Destroy readDestroy = this.reader.readDestroy(payloadAsDOM);
        AbsWsrfrlFaultsTypesAndPayloadsUnitTests.checkDestroy(payload, readDestroy, this.isDebug);
        System.out.println("\t Unit Test Step 2 (\"read from DOM\") : Passed !");
        System.out.println("\n\t OK, unit test \"Create, Write-to-DOM and read-from-DOM Destroy\" passed !\n\n\t ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~\n");
    }

    @Test
    public final void testCreateWriteAsDOMReadDestroyResponse() throws WsrfrlException {
        System.out.println("\n\t ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~\n\t ~~~~~~~ unit test \"Create, Write-to-DOM and read-from-DOM DestroyResponse\" ~~~~~~~ \n");
        DestroyResponse payload = this.factory.createDestroyResponse();
        Document payloadAsDOM = this.writer.writeDestroyResponseAsDOM(payload);
        try {
            WsaUnitTestsUtils.validateResult((Document)payloadAsDOM, (String[])WsrfrlUnitTestsUtils.WSRFRL_XML_SCHEMAS_PATHS, (String)"OASIS \"WS-ResourceLifetime\"", DestroyResponse.class, (boolean)this.isDebug);
            System.out.println("\t Unit Test Step 1 (\"create\" and \"write to DOM\") : Passed !\n");
        }
        catch (SAXException e) {
            Assert.fail((String)(WsaUnitTestsUtils.getFailedMessagePrefix((String)"OASIS \"WS-ResourceLifetime\"") + e.getMessage()));
        }
        DestroyResponse readDestroyResponse = this.reader.readDestroyResponse(payloadAsDOM);
        AbsWsrfrlFaultsTypesAndPayloadsUnitTests.checkDestroyResponse(payload, readDestroyResponse, this.isDebug);
        System.out.println("\t Unit Test Step 2 (\"read from DOM\") : Passed !");
        System.out.println("\n\t OK, unit test \"Create, Write-to-DOM and read-from-DOM DestroyResponse\" passed !\n\n\t ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~\n");
    }

    @Test
    public final void testCreateWriteAsDOMReadTerminationNotification() throws WsrfrlException {
        System.out.println("\n\t ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~\n\t ~~~~~~~ unit test \"Create, Write-to-DOM and read-from-DOM TerminationNotification\" ~~~~~~~ \n");
        TerminationNotification notification = this.factory.createTerminationNotification(new Date());
        notification.setTerminationReason((Object)WsrfrlUnitTestsUtils.createTerminationReasonElt("Resource Lifetime elapsed !"));
        Document notificationAsDOM = this.writer.writeTerminationNotificationAsDOM(notification);
        try {
            WsaUnitTestsUtils.validateResult((Document)notificationAsDOM, (String[])WsrfrlUnitTestsUtils.WSRFRL_XML_SCHEMAS_PATHS, (String)"OASIS \"WS-ResourceLifetime\"", TerminationNotification.class, (boolean)this.isDebug);
            System.out.println("\t Unit Test Step 1 (\"create\" and \"write to DOM\") : Passed !\n");
        }
        catch (SAXException e) {
            Assert.fail((String)(WsaUnitTestsUtils.getFailedMessagePrefix((String)"OASIS \"WS-ResourceLifetime\"") + e.getMessage()));
        }
        TerminationNotification readTerminationNotification = this.reader.readTerminationNotification(notificationAsDOM);
        AbsWsrfrlFaultsTypesAndPayloadsUnitTests.checkTerminationNotification(notification, readTerminationNotification, this.isDebug);
        System.out.println("\t Unit Test Step 2 (\"read from DOM\") : Passed !");
        System.out.println("\n\t OK, unit test \"Create, Write-to-DOM and read-from-DOM TerminationNotification\" passed !\n\n\t ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~\n");
    }

    @Test
    public final void testCreateWriteAsDOMReadCurrentTime() throws WsrfrlException {
        System.out.println("\n\t ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~\n\t ~~~~~~~ unit test \"Create, Write-to-DOM and read-from-DOM CurrentTime\" ~~~~~~~ \n");
        CurrentTime currentTime = this.factory.createCurrentTime(new Date());
        Document currentTimeAsDOM = this.writer.writeCurrentTimeAsDOM(currentTime);
        try {
            WsaUnitTestsUtils.validateResult((Document)currentTimeAsDOM, (String[])WsrfrlUnitTestsUtils.WSRFRL_XML_SCHEMAS_PATHS, (String)"OASIS \"WS-ResourceLifetime\"", CurrentTime.class, (boolean)this.isDebug);
            System.out.println("\t Unit Test Step 1 (\"create\" and \"write to DOM\") : Passed !\n");
        }
        catch (SAXException e) {
            Assert.fail((String)(WsaUnitTestsUtils.getFailedMessagePrefix((String)"OASIS \"WS-ResourceLifetime\"") + e.getMessage()));
        }
        CurrentTime readCurrentTime = this.reader.readCurrentTime(currentTimeAsDOM);
        AbsWsrfrlFaultsTypesAndPayloadsUnitTests.checkCurrentTime(currentTime, readCurrentTime, this.isDebug);
        System.out.println("\t Unit Test Step 2 (\"read from DOM\") : Passed !");
        System.out.println("\n\t OK, unit test \"Create, Write-to-DOM and read-from-DOM CurrentTime\" passed !\n\n\t ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~\n");
    }

    @Test
    public final void testCreateWriteAsDOMReadTerminationTime() throws WsrfrlException {
        System.out.println("\n\t ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~\n\t ~~~~~~~ unit test \"Create, Write-to-DOM and read-from-DOM TerminationTime\" ~~~~~~~ \n");
        TerminationTime terminationTime = this.factory.createTerminationTime(new Date());
        Document terminationTimeAsDOM = this.writer.writeTerminationTimeAsDOM(terminationTime);
        try {
            WsaUnitTestsUtils.validateResult((Document)terminationTimeAsDOM, (String[])WsrfrlUnitTestsUtils.WSRFRL_XML_SCHEMAS_PATHS, (String)"OASIS \"WS-ResourceLifetime\"", TerminationTime.class, (boolean)this.isDebug);
            System.out.println("\t Unit Test Step 1 (\"create\" and \"write to DOM\") : Passed !\n");
        }
        catch (SAXException e) {
            Assert.fail((String)(WsaUnitTestsUtils.getFailedMessagePrefix((String)"OASIS \"WS-ResourceLifetime\"") + e.getMessage()));
        }
        TerminationTime readTerminationTime = this.reader.readTerminationTime(terminationTimeAsDOM);
        AbsWsrfrlFaultsTypesAndPayloadsUnitTests.checkTerminationTime(terminationTime, readTerminationTime, this.isDebug);
        System.out.println("\t Unit Test Step 2 (\"read from DOM\") : Passed !");
        System.out.println("\n\t OK, unit test \"Create, Write-to-DOM and read-from-DOM TerminationTime\" passed !\n\n\t ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~\n");
    }

    @Test
    public final void testCreateWriteAsDOMReadScheduledResourceTerminationRP() throws WsrfrlException {
        System.out.println("\n\t ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~\n\t ~~~~~~~ unit test \"Create, Write-to-DOM and read-from-DOM ScheduledResourceTerminationRP\" ~~~~~~~ \n");
        GregorianCalendar gCal = new GregorianCalendar();
        Date currTimeVal = gCal.getTime();
        gCal.add(10, 1);
        Date termTimeVal = gCal.getTime();
        CurrentTime currTime = this.factory.createCurrentTime(currTimeVal);
        TerminationTime termTime = this.factory.createTerminationTime(termTimeVal);
        ScheduledResourceTerminationRP schedResTermRP = this.factory.createScheduledResourceTerminationRP(currTime, termTime);
        Document schedResTermRPAsDOM = this.writer.writeScheduledResourceTerminationRPAsDOM(schedResTermRP);
        try {
            WsaUnitTestsUtils.validateResult((Document)schedResTermRPAsDOM, (String[])WsrfrlUnitTestsUtils.WSRFRL_XML_SCHEMAS_PATHS, (String)"OASIS \"WS-ResourceLifetime\"", ScheduledResourceTerminationRP.class, (boolean)this.isDebug);
            System.out.println("\t Unit Test Step 1 (\"create\" and \"write to DOM\") : Passed !\n");
        }
        catch (SAXException e) {
            Assert.fail((String)(WsaUnitTestsUtils.getFailedMessagePrefix((String)"OASIS \"WS-ResourceLifetime\"") + e.getMessage()));
        }
        ScheduledResourceTerminationRP readSchedResTermRP = this.reader.readScheduledResourceTerminationRP(schedResTermRPAsDOM);
        AbsWsrfrlFaultsTypesAndPayloadsUnitTests.checkScheduledResourceTerminationRP(schedResTermRP, readSchedResTermRP, this.isDebug);
        System.out.println("\t Unit Test Step 2 (\"read from DOM\") : Passed !");
        System.out.println("\n\t OK, unit test \"Create, Write-to-DOM and read-from-DOM ScheduledResourceTerminationRP\" passed !\n\n\t ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~\n");
    }
}

