package com.ebmwebsourcing.wsstar.resourcelifetime.datatypes.impl.impl;

import java.util.Date;
import java.util.logging.Logger;

import com.ebmwebsourcing.wsstar.basefaults.datatypes.impl.impl.BaseFaultTypeImpl;
import com.ebmwebsourcing.wsstar.basefaults.datatypes.impl.utils.WsrfbfUtils;
import com.ebmwebsourcing.wsstar.resourcelifetime.datatypes.api.abstraction.ResourceNotDestroyedFaultType;
import com.ebmwebsourcing.wsstar.resourcelifetime.datatypes.impl.WsrfrlJAXBContext;

import easybox.org.oasis_open.docs.wsrf.rl_2.EJaxbResourceNotDestroyedFaultType;

public class ResourceNotDestroyedFaultTypeImpl extends BaseFaultTypeImpl
		implements ResourceNotDestroyedFaultType {

	/**
	 * Default constructor
	 * 
	 * Note : According to the xml schema the "timestamp" field is mandatory
	 * 
	 * @param timestamp the timestamp of the {@link ResourceNotDestroyedFaultType) object that must
	 * 		  be {@link Date} representation of an Date xml type.
	 */
	protected ResourceNotDestroyedFaultTypeImpl(Date timestamp){
		super(Logger.getLogger(ResourceNotDestroyedFaultTypeImpl.class.getSimpleName()));
		
		EJaxbResourceNotDestroyedFaultType jaxbTypeObj =
			new EJaxbResourceNotDestroyedFaultType() ;
		
		jaxbTypeObj.setTimestamp(WsrfbfUtils.toXMLGregorianCalendar(timestamp, this.getLogger()));
		
		this.setJaxbTypeObj(jaxbTypeObj);
	}
	
	protected ResourceNotDestroyedFaultTypeImpl(EJaxbResourceNotDestroyedFaultType jaxbTypeObj) {
		super(jaxbTypeObj,Logger.getLogger(ResourceNotDestroyedFaultTypeImpl.class.getSimpleName()));
	}
	
	/**
	 * A way to create a  {@link com.ebmwebsourcing.wsstar.jaxb.resource.resourcelifetime.ResourceNotDestroyedFaultType}
	 *  "Jaxb model type" object from a {@link ResourceNotDestroyedFaultType} "api type" one  
	 *    
	 * @param apiTypeObj
	 */
	public static EJaxbResourceNotDestroyedFaultType toJaxbModel(ResourceNotDestroyedFaultType apiTypeObj){

		EJaxbResourceNotDestroyedFaultType jaxbTypeObj = null;
		if (apiTypeObj instanceof ResourceNotDestroyedFaultTypeImpl) {
			jaxbTypeObj = (EJaxbResourceNotDestroyedFaultType)
				((ResourceNotDestroyedFaultTypeImpl)apiTypeObj).getJaxbTypeObj();
		} else {
			jaxbTypeObj = (EJaxbResourceNotDestroyedFaultType) 
				BaseFaultTypeImpl.toJaxbModel(apiTypeObj,
						WsrfrlJAXBContext.WSRFRL_JAXB_FACTORY.createEJaxbResourceNotDestroyedFaultType());
		}

		return jaxbTypeObj;
	}
}
