package com.ebmwebsourcing.wsstar.resourceproperties.datatypes.impl.impl;

import java.util.Date;
import java.util.logging.Logger;

import com.ebmwebsourcing.wsstar.basefaults.datatypes.impl.impl.BaseFaultTypeImpl;
import com.ebmwebsourcing.wsstar.basefaults.datatypes.impl.utils.WsrfbfUtils;
import com.ebmwebsourcing.wsstar.resourceproperties.datatypes.api.abstraction.ResourcePropertyChangeFailureType;
import com.ebmwebsourcing.wsstar.resourceproperties.datatypes.api.abstraction.UnableToModifyResourcePropertyFaultType;
import com.ebmwebsourcing.wsstar.resourceproperties.datatypes.impl.WsrfrpJAXBContext;

import easybox.org.oasis_open.docs.wsrf.rp_2.EJaxbResourcePropertyChangeFailureType;
import easybox.org.oasis_open.docs.wsrf.rp_2.EJaxbUnableToModifyResourcePropertyFaultType;

public class UnableToModifyResourcePropertyFaultTypeImpl extends
		BaseFaultTypeImpl implements UnableToModifyResourcePropertyFaultType {

	/**
	 * Default constructor
	 * 
	 * Note : According to the xml schema the "timestamp" field is mandatory
	 * 
	 * @param timestamp the timestamp of the {@link UnableToModifyResourcePropertyFaultType) object that must
	 * 		  be {@link Date} representation of an Date xml type.
	 * @param failure change failure details as {@link ResourcePropertyChangeFailureType} object 
	 */
	protected UnableToModifyResourcePropertyFaultTypeImpl(Date timestamp, ResourcePropertyChangeFailureType failure){
		super(Logger.getLogger(UnableToModifyResourcePropertyFaultTypeImpl.class.getSimpleName()));
		
		EJaxbUnableToModifyResourcePropertyFaultType jaxbTypeObj =
			new EJaxbUnableToModifyResourcePropertyFaultType();
		
		jaxbTypeObj.setTimestamp(WsrfbfUtils.toXMLGregorianCalendar(timestamp, this.getLogger()));
		jaxbTypeObj.setResourcePropertyChangeFailure(ResourcePropertyChangeFailureTypeImpl.toJaxbModel(failure));

		this.setJaxbTypeObj(jaxbTypeObj);
	}
	
	protected UnableToModifyResourcePropertyFaultTypeImpl(EJaxbUnableToModifyResourcePropertyFaultType jaxbTypeObj){
		super(jaxbTypeObj,Logger.getLogger(UnableToModifyResourcePropertyFaultTypeImpl.class.getSimpleName()));
	}
		
	@Override
	public ResourcePropertyChangeFailureType getResourcePropertyChangeFailure() {
		EJaxbUnableToModifyResourcePropertyFaultType refinedTypeFault = 
			((EJaxbUnableToModifyResourcePropertyFaultType)
					this.getJaxbTypeObj());
		
		EJaxbResourcePropertyChangeFailureType rpChangeFailureFromMofdel =
			refinedTypeFault.getResourcePropertyChangeFailure();		
		
		return new ResourcePropertyChangeFailureTypeImpl(rpChangeFailureFromMofdel);
	}

	@Override
	public void setResourcePropertyChangeFailure(
			ResourcePropertyChangeFailureType failure) {
		((EJaxbUnableToModifyResourcePropertyFaultType)
				this.getJaxbTypeObj()).setResourcePropertyChangeFailure(ResourcePropertyChangeFailureTypeImpl.toJaxbModel(failure));
	}

	/**
	 * A way to create a  {@link com.ebmwebsourcing.wsstar.jaxb.resource.resourceproperties.UnableToModifyResourcePropertyFaultTypeImpl}
	 *  "Jaxb model type" object from a {@link UnableToModifyResourcePropertyFaultType} api type" one  
	 *    
	 * @param apiTypeObj
	 */
	public static EJaxbUnableToModifyResourcePropertyFaultType toJaxbModel(UnableToModifyResourcePropertyFaultType apiTypeObj){

		EJaxbUnableToModifyResourcePropertyFaultType jaxbTypeObj = null;

		if (apiTypeObj instanceof UnableToModifyResourcePropertyFaultTypeImpl) {
			jaxbTypeObj = (EJaxbUnableToModifyResourcePropertyFaultType)
			((UnableToModifyResourcePropertyFaultTypeImpl)apiTypeObj).getJaxbTypeObj();
		} else {
			jaxbTypeObj = (EJaxbUnableToModifyResourcePropertyFaultType) 
			BaseFaultTypeImpl.toJaxbModel(apiTypeObj,
					WsrfrpJAXBContext.WSRFRP_JAXB_FACTORY.createEJaxbUnableToModifyResourcePropertyFaultType());
			
			// ~~~~ Set ResourcePropertyChangeFailure value ~~~~			
			jaxbTypeObj.setResourcePropertyChangeFailure(ResourcePropertyChangeFailureTypeImpl.toJaxbModel(
					apiTypeObj.getResourcePropertyChangeFailure()));			
		}
		return jaxbTypeObj;
	}
}
