package com.ebmwebsourcing.wsstar.resourceproperties.datatypes.impl.impl;

import com.ebmwebsourcing.wsstar.resourceproperties.datatypes.api.abstraction.UpdateResourceProperties;
import com.ebmwebsourcing.wsstar.resourceproperties.datatypes.api.abstraction.UpdateType;
import com.ebmwebsourcing.wsstar.resourceproperties.datatypes.impl.WsrfrpJAXBContext;

import easybox.org.oasis_open.docs.wsrf.rp_2.EJaxbUpdateResourceProperties;

public class UpdateResourcePropertiesImpl implements UpdateResourceProperties {

	private EJaxbUpdateResourceProperties jaxbTypeObj;
	
	/**
	 * Default constructor
	 */
	protected UpdateResourcePropertiesImpl(UpdateType content) {		
		this.jaxbTypeObj = WsrfrpJAXBContext.WSRFRP_JAXB_FACTORY.createEJaxbUpdateResourceProperties();
		this.setUpdate(content);
	}

	protected UpdateResourcePropertiesImpl(EJaxbUpdateResourceProperties jaxbTypeObj){
		this.jaxbTypeObj = jaxbTypeObj;
	}
	
	protected final EJaxbUpdateResourceProperties getJaxbTypeObj() {
		return jaxbTypeObj;
	}
	
	@Override
	public UpdateType getUpdate() {
		return new UpdateTypeImpl(this.jaxbTypeObj.getUpdate());
	}

	@Override
	public void setUpdate(UpdateType value) {
		this.jaxbTypeObj.setUpdate(UpdateTypeImpl.toJaxbModel(value));
	}
	
	/**
	 * A way to create a  {@link com.ebmwebsourcing.wsstar.jaxb.resource.resourceproperties.UpdateResourceProperties}
	 *  "Jaxb model type" object from a {@link UpdateResourceProperties} "api type" one  
	 *    
	 * @param apiTypeObj
	 */
	public static EJaxbUpdateResourceProperties toJaxbModel(UpdateResourceProperties apiTypeObj) {

		EJaxbUpdateResourceProperties jaxbTypeObj = null;
		
		if (apiTypeObj instanceof UpdateResourcePropertiesImpl){
			jaxbTypeObj = ((UpdateResourcePropertiesImpl)apiTypeObj).getJaxbTypeObj();
		} else { 
			jaxbTypeObj = WsrfrpJAXBContext.WSRFRP_JAXB_FACTORY.createEJaxbUpdateResourceProperties();
		
			jaxbTypeObj.setUpdate(UpdateTypeImpl.toJaxbModel(apiTypeObj.getUpdate()));	
		}
						
		return jaxbTypeObj;
	}
}
