package com.ebmwebsourcing.wsstar.resourceproperties.datatypes.impl.impl;

import javax.xml.bind.JAXBElement;
import javax.xml.bind.Marshaller;
import javax.xml.namespace.QName;

import org.w3c.dom.Document;

import com.ebmwebsourcing.easycommons.research.util.dom.DOMUtil;
import com.ebmwebsourcing.wsstar.basefaults.datatypes.impl.utils.WsrfbfUtils;
import com.ebmwebsourcing.wsstar.resourceproperties.datatypes.api.WsrfrpConstants;
import com.ebmwebsourcing.wsstar.resourceproperties.datatypes.api.abstraction.GetResourcePropertyResponse;
import com.ebmwebsourcing.wsstar.resourceproperties.datatypes.api.abstraction.InvalidModificationFaultType;
import com.ebmwebsourcing.wsstar.resourceproperties.datatypes.api.abstraction.InvalidResourcePropertyQNameFaultType;
import com.ebmwebsourcing.wsstar.resourceproperties.datatypes.api.abstraction.ResourcePropertyValueChangeNotificationType;
import com.ebmwebsourcing.wsstar.resourceproperties.datatypes.api.abstraction.UnableToModifyResourcePropertyFaultType;
import com.ebmwebsourcing.wsstar.resourceproperties.datatypes.api.abstraction.UpdateResourceProperties;
import com.ebmwebsourcing.wsstar.resourceproperties.datatypes.api.abstraction.UpdateResourcePropertiesRequestFailedFaultType;
import com.ebmwebsourcing.wsstar.resourceproperties.datatypes.api.abstraction.UpdateResourcePropertiesResponse;
import com.ebmwebsourcing.wsstar.resourceproperties.datatypes.api.abstraction.UpdateType;
import com.ebmwebsourcing.wsstar.resourceproperties.datatypes.api.abstraction.WsrfrpWriter;
import com.ebmwebsourcing.wsstar.resourceproperties.datatypes.api.utils.WsrfrpException;
import com.ebmwebsourcing.wsstar.resourceproperties.datatypes.impl.WsrfrpJAXBContext;

import easybox.org.oasis_open.docs.wsrf.rp_2.EJaxbGetResourcePropertyResponse;
import easybox.org.oasis_open.docs.wsrf.rp_2.EJaxbInvalidModificationFaultType;
import easybox.org.oasis_open.docs.wsrf.rp_2.EJaxbInvalidResourcePropertyQNameFaultType;
import easybox.org.oasis_open.docs.wsrf.rp_2.EJaxbResourcePropertyValueChangeNotificationType;
import easybox.org.oasis_open.docs.wsrf.rp_2.EJaxbUnableToModifyResourcePropertyFaultType;
import easybox.org.oasis_open.docs.wsrf.rp_2.EJaxbUpdateResourceProperties;
import easybox.org.oasis_open.docs.wsrf.rp_2.EJaxbUpdateResourcePropertiesRequestFailedFaultType;
import easybox.org.oasis_open.docs.wsrf.rp_2.EJaxbUpdateResourcePropertiesResponse;
import easybox.org.oasis_open.docs.wsrf.rp_2.EJaxbUpdateType;

public class WsrfrpWriterImpl implements WsrfrpWriter {
	
	private WsrfrpJAXBContext resourcePropertiesJaxbContext = null;
	
	/**
     * Default constructor
     */
    protected  WsrfrpWriterImpl(){
    	this.resourcePropertiesJaxbContext = WsrfrpJAXBContext.getInstance();
	} 
        
    protected  WsrfrpWriterImpl(String[] nsAndPrefixForMarshalling){
    	this.resourcePropertiesJaxbContext = WsrfrpJAXBContext.getInstance(nsAndPrefixForMarshalling);
	}
    
	@Override
	public Document writeGetResourcePropertyAsDOM(QName propertyName)
			throws WsrfrpException {
		Document result = null;
		try {

			Marshaller marshaller = this.resourcePropertiesJaxbContext.createWSResourcePropertiesMarshaller();

			result = DOMUtil.getInstance().getDocumentBuilderFactory().newDocumentBuilder().newDocument();

			// TODO : Check if it is a Thread safe method
			final JAXBElement<QName> element = WsrfrpJAXBContext.WSRFRP_JAXB_FACTORY.createGetResourceProperty(propertyName);

			marshaller.marshal(element, result);            

		} catch (final Exception ex) {
			throw new WsrfrpException(WsrfbfUtils.getBindingExMessage(propertyName), ex);
		} 
		return result;
	}

	@Override
	public Document writeGetResourcePropertyResponseAsDOM(
			GetResourcePropertyResponse payload) throws WsrfrpException {
		Document result = null;
    	if (payload instanceof GetResourcePropertyResponseImpl){
    		try {

    			Marshaller marshaller = this.resourcePropertiesJaxbContext.createWSResourcePropertiesMarshaller();

    			result = DOMUtil.getInstance().getDocumentBuilderFactory().newDocumentBuilder().newDocument();

    			// TODO : Check if it is a Thread safe method
    			final JAXBElement<EJaxbGetResourcePropertyResponse> element = 
    				new JAXBElement<EJaxbGetResourcePropertyResponse>(WsrfrpConstants.GET_RESOURCE_PROPERTY_RESPONSE_QNAME,
    						EJaxbGetResourcePropertyResponse.class,
    						((GetResourcePropertyResponseImpl)payload).getJaxbTypeObj());

    			marshaller.marshal(element, result);            

    		} catch (final Exception ex) {
    			throw new WsrfrpException(WsrfbfUtils.getBindingExMessage(payload), ex);
    		} 
    	}
    	return result;
	}

	@Override
	public Document writeInvalidResourcePropertyQNameFaultTypeAsDOM(
			InvalidResourcePropertyQNameFaultType value) throws WsrfrpException {
		Document result = null;
    	if (value instanceof InvalidResourcePropertyQNameFaultTypeImpl){
    		try {

    			Marshaller marshaller = this.resourcePropertiesJaxbContext.createWSResourcePropertiesMarshaller();

    			result = DOMUtil.getInstance().getDocumentBuilderFactory().newDocumentBuilder().newDocument();

    			// TODO : Check if it is a Thread safe method
    			final JAXBElement<EJaxbInvalidResourcePropertyQNameFaultType> element = 
    				new JAXBElement<EJaxbInvalidResourcePropertyQNameFaultType>(WsrfrpConstants.INVALID_RESOURCE_PROPERTY_QNAME_FAULT_QNAME,
    						EJaxbInvalidResourcePropertyQNameFaultType.class,
    						InvalidResourcePropertyQNameFaultTypeImpl.toJaxbModel(value));

    			marshaller.marshal(element, result);            

    		} catch (final Exception ex) {
    			throw new WsrfrpException(WsrfbfUtils.getBindingExMessage(value), ex);
    		} 
    	}
    	return result;
	}
	
	@Override
	public Document writeUpdateTypeAsDOM(UpdateType instance)
			throws WsrfrpException {
		Document result = null;
    	if (instance instanceof UpdateTypeImpl){
    		try {

    			Marshaller marshaller = this.resourcePropertiesJaxbContext.createWSResourcePropertiesMarshaller();

    			result = DOMUtil.getInstance().getDocumentBuilderFactory().newDocumentBuilder().newDocument();

    			// TODO : Check if it is a Thread safe method
    			final JAXBElement<EJaxbUpdateType> element = 
    				new JAXBElement<EJaxbUpdateType>(WsrfrpConstants.UPDATE_QNAME,
    						EJaxbUpdateType.class,
    						((UpdateTypeImpl)instance).getJaxbTypeObj());

    			marshaller.marshal(element, result);            

    		} catch (final Exception ex) {
    			throw new WsrfrpException(WsrfbfUtils.getBindingExMessage(instance), ex);
    		} 
    	}
    	return result;
	}
	
	@Override
	public Document writeUpdateResourcePropertiesAsDOM(
			UpdateResourceProperties payload) throws WsrfrpException {
		Document result = null;
    	if (payload instanceof UpdateResourcePropertiesImpl){
    		try {

    			Marshaller marshaller = this.resourcePropertiesJaxbContext.createWSResourcePropertiesMarshaller();

    			result = DOMUtil.getInstance().getDocumentBuilderFactory().newDocumentBuilder().newDocument();

    			// TODO : Check if it is a Thread safe method
    			final JAXBElement<EJaxbUpdateResourceProperties> element = 
    				new JAXBElement<EJaxbUpdateResourceProperties>(WsrfrpConstants.UPDATE_RESOURCE_PROPERTIES_QNAME,
    						EJaxbUpdateResourceProperties.class,
    						((UpdateResourcePropertiesImpl)payload).getJaxbTypeObj());

    			marshaller.marshal(element, result);            

    		} catch (final Exception ex) {
    			throw new WsrfrpException(WsrfbfUtils.getBindingExMessage(payload), ex);
    		} 
    	}
    	return result;
	}
	
	@Override
	public Document writeUpdateResourcePropertiesResponseAsDOM(
			UpdateResourcePropertiesResponse payload) throws WsrfrpException {
		Document result = null;
    	if (payload instanceof UpdateResourcePropertiesResponseImpl){
    		try {

    			Marshaller marshaller = this.resourcePropertiesJaxbContext.createWSResourcePropertiesMarshaller();

    			result = DOMUtil.getInstance().getDocumentBuilderFactory().newDocumentBuilder().newDocument();

    			// TODO : Check if it is a Thread safe method
    			final JAXBElement<EJaxbUpdateResourcePropertiesResponse> element = 
    				new JAXBElement<EJaxbUpdateResourcePropertiesResponse>(WsrfrpConstants.UPDATE_RESOURCE_PROPERTIES_RESPONSE_QNAME,
    						EJaxbUpdateResourcePropertiesResponse.class,
    						((UpdateResourcePropertiesResponseImpl)payload).getJaxbTypeObj());

    			marshaller.marshal(element, result);            

    		} catch (final Exception ex) {
    			throw new WsrfrpException(WsrfbfUtils.getBindingExMessage(payload), ex);
    		} 
    	}
    	return result;
	}
	
	@Override
	public Document writeInvalidModificationFaultTypeAsDOM(
			InvalidModificationFaultType fault) throws WsrfrpException {
		Document result = null;
    	if (fault instanceof InvalidModificationFaultTypeImpl){
    		try {

    			Marshaller marshaller = this.resourcePropertiesJaxbContext.createWSResourcePropertiesMarshaller();

    			result = DOMUtil.getInstance().getDocumentBuilderFactory().newDocumentBuilder().newDocument();

    			// TODO : Check if it is a Thread safe method
    			final JAXBElement<EJaxbInvalidModificationFaultType> element = 
    				new JAXBElement<EJaxbInvalidModificationFaultType>(WsrfrpConstants.INVALID_MODIFICATION_QNAME_FAULT_QNAME,
    						EJaxbInvalidModificationFaultType.class,
    						InvalidModificationFaultTypeImpl.toJaxbModel(fault));
    			marshaller.marshal(element, result);            

    		} catch (final Exception ex) {
    			throw new WsrfrpException(WsrfbfUtils.getBindingExMessage(fault), ex);
    		} 
    	}
    	return result;
	}
	
	@Override
	public Document writeUnableToModifyResourcePropertyFaultTypeAsDOM(
			UnableToModifyResourcePropertyFaultType fault)
			throws WsrfrpException {
		Document result = null;
    	if (fault instanceof UnableToModifyResourcePropertyFaultTypeImpl){
    		try {

    			Marshaller marshaller = this.resourcePropertiesJaxbContext.createWSResourcePropertiesMarshaller();

    			result = DOMUtil.getInstance().getDocumentBuilderFactory().newDocumentBuilder().newDocument();

    			// TODO : Check if it is a Thread safe method
    			final JAXBElement<EJaxbUnableToModifyResourcePropertyFaultType> element = 
    				new JAXBElement<EJaxbUnableToModifyResourcePropertyFaultType>(WsrfrpConstants.UNABLE_TO_MODIFY_RESOURCE_PROPERTY_FAULT_QNAME,
    						EJaxbUnableToModifyResourcePropertyFaultType.class,
    						UnableToModifyResourcePropertyFaultTypeImpl.toJaxbModel(fault));
    			marshaller.marshal(element, result);            

    		} catch (final Exception ex) {
    			throw new WsrfrpException(WsrfbfUtils.getBindingExMessage(fault), ex);
    		} 
    	}
    	return result;
	}
	
	@Override
	public Document writeUpdateResourcePropertiesRequestFailedFaultTypeAsDOM(
			UpdateResourcePropertiesRequestFailedFaultType fault)
			throws WsrfrpException {
		Document result = null;
    	if (fault instanceof UpdateResourcePropertiesRequestFailedFaultTypeImpl){
    		try {

    			Marshaller marshaller = this.resourcePropertiesJaxbContext.createWSResourcePropertiesMarshaller();

    			result = DOMUtil.getInstance().getDocumentBuilderFactory().newDocumentBuilder().newDocument();

    			// TODO : Check if it is a Thread safe method
    			final JAXBElement<EJaxbUpdateResourcePropertiesRequestFailedFaultType> element = 
    				new JAXBElement<EJaxbUpdateResourcePropertiesRequestFailedFaultType>(WsrfrpConstants.UPDATE_RESOURCE_PROPERTIES_REQUEST_FAILED_FAULT_QNAME,
    						EJaxbUpdateResourcePropertiesRequestFailedFaultType.class,
    						UpdateResourcePropertiesRequestFailedFaultTypeImpl.toJaxbModel(fault));
    			marshaller.marshal(element, result);            

    		} catch (final Exception ex) {
    			throw new WsrfrpException(WsrfbfUtils.getBindingExMessage(fault), ex);
    		} 
    	}
    	return result;
	}
	
	@Override
	public Document writeResourcePropertyValueChangeNotificationTypeAsDOM(
			ResourcePropertyValueChangeNotificationType value)
			throws WsrfrpException {
		Document result = null;
		try {

			Marshaller marshaller = this.resourcePropertiesJaxbContext.createWSResourcePropertiesMarshaller();

			result = DOMUtil.getInstance().getDocumentBuilderFactory().newDocumentBuilder().newDocument();

			// TODO : Check if it is a Thread safe method
			final JAXBElement<EJaxbResourcePropertyValueChangeNotificationType> element =
				WsrfrpJAXBContext.WSRFRP_JAXB_FACTORY.createResourcePropertyValueChangeNotification(
						((ResourcePropertyValueChangeNotificationTypeImpl)value).getJaxbTypeObj());

			marshaller.marshal(element, result);            

		} catch (final Exception ex) {
			throw new WsrfrpException(WsrfbfUtils.getBindingExMessage(value), ex);
		} 
		return result;
	}
}
