package com.ebmwebsourcing.wsstar.resourceproperties.datatypes.impl.impl;

import java.util.ArrayList;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;

import org.w3c.dom.Element;

import com.ebmwebsourcing.wsstar.resourceproperties.datatypes.api.abstraction.ResourcePropertyChangeFailureType;
import com.ebmwebsourcing.wsstar.resourceproperties.datatypes.impl.WsrfrpJAXBContext;

import easybox.org.oasis_open.docs.wsrf.rp_2.EJaxbResourcePropertyChangeFailureType;

public class ResourcePropertyChangeFailureTypeImpl implements ResourcePropertyChangeFailureType {

	private EJaxbResourcePropertyChangeFailureType jaxbTypeObj;
	private static Logger logger = Logger.getLogger(ResourcePropertyChangeFailureTypeImpl.class.getSimpleName());
	
	/**
	 * Default constructor
	 */
	protected ResourcePropertyChangeFailureTypeImpl(boolean value) {
		this.jaxbTypeObj = WsrfrpJAXBContext.WSRFRP_JAXB_FACTORY.createEJaxbResourcePropertyChangeFailureType();
		this.jaxbTypeObj.setRestored(value);
	}
	
	protected ResourcePropertyChangeFailureTypeImpl(EJaxbResourcePropertyChangeFailureType jaxbTypeObj) {
		this.jaxbTypeObj = jaxbTypeObj;
	}
	
	protected EJaxbResourcePropertyChangeFailureType getJaxbTypeObj() {
		return jaxbTypeObj;
	}
	
	@Override
	public CurrentValue getCurrentValue() {
		CurrentValue result = null;
		
		EJaxbResourcePropertyChangeFailureType.CurrentValue valueFromModel = 
			this.jaxbTypeObj.getCurrentValue();
		
		if (valueFromModel != null){
			result = new CurrentValueImpl(valueFromModel);
		}				
		return result;
	}

	@Override
	public void setCurrentValue(CurrentValue value) {
		this.jaxbTypeObj.setCurrentValue(CurrentValueImpl.toJaxbModel(value));
	}

	@Override
	public RequestedValue getRequestedValue() {
		
		RequestedValue result = null; 
		
		EJaxbResourcePropertyChangeFailureType.RequestedValue valueFromModel = 
			this.jaxbTypeObj.getRequestedValue();
		
		if (valueFromModel != null){
			result = new RequestedValueImpl(valueFromModel);
		}		
		return result;
	}

	@Override
	public void setRequestedValue(RequestedValue values) {
		this.jaxbTypeObj.setRequestedValue(RequestedValueImpl.toJaxbModel(values));
	}

	@Override
	public boolean isRestored() {
		return this.jaxbTypeObj.isRestored();
	}

	@Override
	public void setRestored(boolean bool) {
		this.jaxbTypeObj.setRestored(bool);
	}
	
	/**
	 * A way to create a  {@link com.ebmwebsourcing.wsstar.jaxb.resource.resourceproperties.ResourcePropertyChangeFailureType}
	 *  "Jaxb model type" object from a {@link ResourcePropertyChangeFailureType} "api type" one  
	 *    
	 * @param apiTypeObj
	 */
	public static EJaxbResourcePropertyChangeFailureType toJaxbModel(
			ResourcePropertyChangeFailureType apiTypeObj){
		
		EJaxbResourcePropertyChangeFailureType jaxbTypeObj = null;
		
		if (apiTypeObj instanceof ResourcePropertyChangeFailureTypeImpl) {
			jaxbTypeObj = ((ResourcePropertyChangeFailureTypeImpl)apiTypeObj).getJaxbTypeObj();
		}
		else {
			jaxbTypeObj = WsrfrpJAXBContext.WSRFRP_JAXB_FACTORY.createEJaxbResourcePropertyChangeFailureType();			

			// ~~~ Set "isRestored" value ~~~
			jaxbTypeObj.setRestored(apiTypeObj.isRestored());
			
			// ~~~ Set "CurrentValue" value ~~~
			CurrentValue curVal = apiTypeObj.getCurrentValue();			
			if (curVal != null){
				jaxbTypeObj.setCurrentValue(CurrentValueImpl.toJaxbModel(curVal));
			}
			
			// ~~~ Set "RequestedValue ~~~
			RequestedValue reqVal = apiTypeObj.getRequestedValue();
			if (reqVal != null){
				jaxbTypeObj.setRequestedValue(RequestedValueImpl.toJaxbModel(reqVal));
			}
			
		}
		return jaxbTypeObj;
	}
	
	public static class CurrentValueImpl implements ResourcePropertyChangeFailureType.CurrentValue {
		
		private EJaxbResourcePropertyChangeFailureType.CurrentValue jaxbTypeObj;

		/**
		 * Default constructor
		 * 
		 */
		protected CurrentValueImpl(List<Element> values){
			this.jaxbTypeObj = WsrfrpJAXBContext.WSRFRP_JAXB_FACTORY.createEJaxbResourcePropertyChangeFailureTypeCurrentValue();
			this.jaxbTypeObj.getAny().addAll(values);
		}
		
		protected CurrentValueImpl(EJaxbResourcePropertyChangeFailureType.CurrentValue jaxbTypeObj){
			this.jaxbTypeObj = jaxbTypeObj;
		}
		
		protected final EJaxbResourcePropertyChangeFailureType.CurrentValue getJaxbTypeObj() {
			return jaxbTypeObj;
		}
		
		@Override
		public List<Element> getAny() {
			List<Element> values = new  ArrayList<Element>();
			
			List<Object> valueFromModel = this.jaxbTypeObj.getAny();
			for (Object valFromModelItem : valueFromModel) {
				if(valFromModelItem instanceof Element){
					values.add((Element) valFromModelItem);
				}else {
					logger.log(Level.WARNING, "An item of the list is not typed as \"org.w3c.Dom Element\" object" +
							" It will be ignored");
				}
			}		
			return values;
		}

		@Override
		public void setAny(List<Element> values) {
			List<Object> anyFromModel = this.jaxbTypeObj.getAny();
			if (anyFromModel.size()>0) {
				anyFromModel.clear();
			}
			this.jaxbTypeObj.getAny().addAll(values);			
		}
		
		/**
		 * A way to create a  {@link com.ebmwebsourcing.wsstar.jaxb.resource.resourceproperties.ResourcePropertyChangeFailureType.CurrentValue}
		 *  "Jaxb model type" object from a {@link ResourcePropertyChangeFailureType.CurrentValue} "api type" one  
		 *    
		 * @param apiTypeObj
		 */
		public static EJaxbResourcePropertyChangeFailureType.CurrentValue toJaxbModel(
				ResourcePropertyChangeFailureType.CurrentValue apiTypeObj){
			
			EJaxbResourcePropertyChangeFailureType.CurrentValue jaxbTypeObj = null;
			
			if (apiTypeObj instanceof ResourcePropertyChangeFailureTypeImpl.CurrentValueImpl) {
				jaxbTypeObj = ((ResourcePropertyChangeFailureTypeImpl.CurrentValueImpl)apiTypeObj).getJaxbTypeObj();
			}
			else {
				jaxbTypeObj = WsrfrpJAXBContext.WSRFRP_JAXB_FACTORY.createEJaxbResourcePropertyChangeFailureTypeCurrentValue();			

				List<Element> content = apiTypeObj.getAny();				
				jaxbTypeObj.getAny().addAll(content);
				
			}
			return jaxbTypeObj;
		}
	}
	
	
	public static class RequestedValueImpl implements ResourcePropertyChangeFailureType.RequestedValue {
		
		private EJaxbResourcePropertyChangeFailureType.RequestedValue jaxbTypeObj;

		/**
		 * Default constructor
		 * 
		 */
		protected RequestedValueImpl(List<Element> values){
			this.jaxbTypeObj = WsrfrpJAXBContext.WSRFRP_JAXB_FACTORY.createEJaxbResourcePropertyChangeFailureTypeRequestedValue();
			this.jaxbTypeObj.getAny().addAll(values);
		}
		
		protected RequestedValueImpl(EJaxbResourcePropertyChangeFailureType.RequestedValue jaxbTypeObj){
			this.jaxbTypeObj = jaxbTypeObj;
		}
		
		protected final EJaxbResourcePropertyChangeFailureType.RequestedValue getJaxbTypeObj() {
			return jaxbTypeObj;
		}
		
		@Override
		public List<Element> getAny() {
			List<Element> values = new ArrayList<Element>();
			
			List<Object> valueFromModel = this.jaxbTypeObj.getAny();
			for (Object valFromModelItem : valueFromModel) {
				if(valFromModelItem instanceof Element){
					values.add((Element) valFromModelItem);
				}else {
					logger.log(Level.WARNING, "An item of the list is not typed as \"org.w3c.Dom Element\" object" +
							" It will be ignored");
				}
			}		
			return values;
		}
		
		@Override
		public void setAny(List<Element> values) {
			List<Object> anyFromModel = this.jaxbTypeObj.getAny();
			if (anyFromModel.size()>0) {
				anyFromModel.clear();
			}
			this.jaxbTypeObj.getAny().addAll(values);
		}
		
		/**
		 * A way to create a  {@link com.ebmwebsourcing.wsstar.jaxb.resource.resourceproperties.ResourcePropertyChangeFailureType.RequestedValue}
		 *  "Jaxb model type" object from a {@link ResourcePropertyChangeFailureType.RequestedValue} "api type" one  
		 *    
		 * @param apiTypeObj
		 */
		public static EJaxbResourcePropertyChangeFailureType.RequestedValue toJaxbModel(
				ResourcePropertyChangeFailureType.RequestedValue apiTypeObj){
			
			EJaxbResourcePropertyChangeFailureType.RequestedValue jaxbTypeObj = null;
			
			if (apiTypeObj instanceof ResourcePropertyChangeFailureTypeImpl.RequestedValueImpl) {
				jaxbTypeObj = ((ResourcePropertyChangeFailureTypeImpl.RequestedValueImpl)apiTypeObj).getJaxbTypeObj();
			}
			else {
				jaxbTypeObj = WsrfrpJAXBContext.WSRFRP_JAXB_FACTORY.createEJaxbResourcePropertyChangeFailureTypeRequestedValue();			

				List<Element> content = apiTypeObj.getAny();				
				jaxbTypeObj.getAny().addAll(content);
				
			}
			return jaxbTypeObj;
		}
	}

}
