package com.ebmwebsourcing.wsstar.resourceproperties.datatypes.impl.impl;

import java.util.Date;
import java.util.logging.Logger;

import com.ebmwebsourcing.wsstar.basefaults.datatypes.impl.impl.BaseFaultTypeImpl;
import com.ebmwebsourcing.wsstar.basefaults.datatypes.impl.utils.WsrfbfUtils;
import com.ebmwebsourcing.wsstar.resourceproperties.datatypes.api.abstraction.ResourcePropertyChangeFailureType;
import com.ebmwebsourcing.wsstar.resourceproperties.datatypes.api.abstraction.UpdateResourcePropertiesRequestFailedFaultType;
import com.ebmwebsourcing.wsstar.resourceproperties.datatypes.impl.WsrfrpJAXBContext;

import easybox.org.oasis_open.docs.wsrf.rp_2.EJaxbResourcePropertyChangeFailureType;
import easybox.org.oasis_open.docs.wsrf.rp_2.EJaxbUpdateResourcePropertiesRequestFailedFaultType;

public class UpdateResourcePropertiesRequestFailedFaultTypeImpl extends
		BaseFaultTypeImpl implements
		UpdateResourcePropertiesRequestFailedFaultType {

	/**
	 * Default constructor
	 * 
	 * Note : According to the xml schema the "timestamp" field is mandatory
	 * 
	 * @param timestamp the timestamp of the {@link UpdateResourcePropertiesRequestFailedFaultType) object that must
	 * 		  be {@link Date} representation of an Date xml type.
	 * @param failure change failure details as {@link ResourcePropertyChangeFailureType} object 
	 */
	protected UpdateResourcePropertiesRequestFailedFaultTypeImpl(Date timestamp, ResourcePropertyChangeFailureType failure){
		super(Logger.getLogger(UpdateResourcePropertiesRequestFailedFaultTypeImpl.class.getSimpleName()));
		
		EJaxbUpdateResourcePropertiesRequestFailedFaultType jaxbTypeObj =
			new EJaxbUpdateResourcePropertiesRequestFailedFaultType();
		
		jaxbTypeObj.setTimestamp(WsrfbfUtils.toXMLGregorianCalendar(timestamp, this.getLogger()));
		jaxbTypeObj.setResourcePropertyChangeFailure(ResourcePropertyChangeFailureTypeImpl.toJaxbModel(failure));

		this.setJaxbTypeObj(jaxbTypeObj);
	}
	
	protected UpdateResourcePropertiesRequestFailedFaultTypeImpl(EJaxbUpdateResourcePropertiesRequestFailedFaultType jaxbTypeObj){
		super(jaxbTypeObj,Logger.getLogger(UpdateResourcePropertiesRequestFailedFaultTypeImpl.class.getSimpleName()));
	}
	
	@Override
	public ResourcePropertyChangeFailureType getResourcePropertyChangeFailure() {
		EJaxbUpdateResourcePropertiesRequestFailedFaultType refinedTypeFault = 
			((EJaxbUpdateResourcePropertiesRequestFailedFaultType)
					this.getJaxbTypeObj());
		
		EJaxbResourcePropertyChangeFailureType rpChangeFailureFromMofdel =
			refinedTypeFault.getResourcePropertyChangeFailure();		
		
		return new ResourcePropertyChangeFailureTypeImpl(rpChangeFailureFromMofdel);
	}

	@Override
	public void setResourcePropertyChangeFailure(
			ResourcePropertyChangeFailureType failure) {
		((EJaxbUpdateResourcePropertiesRequestFailedFaultType)
				this.getJaxbTypeObj()).setResourcePropertyChangeFailure(ResourcePropertyChangeFailureTypeImpl.toJaxbModel(failure));
	}
	
	/**
	 * A way to create a  {@link com.ebmwebsourcing.wsstar.jaxb.resource.resourceproperties.UpdateResourcePropertiesRequestFailedFaultType}
	 *  "Jaxb model type" object from a {@link UpdateResourcePropertiesRequestFailedFaultType} "api type" one  
	 *    
	 * @param apiTypeObj
	 */
	public static EJaxbUpdateResourcePropertiesRequestFailedFaultType toJaxbModel(UpdateResourcePropertiesRequestFailedFaultType apiTypeObj){

		EJaxbUpdateResourcePropertiesRequestFailedFaultType jaxbTypeObj = null;

		if (apiTypeObj instanceof UpdateResourcePropertiesRequestFailedFaultTypeImpl) {
			jaxbTypeObj = (EJaxbUpdateResourcePropertiesRequestFailedFaultType)
			((UpdateResourcePropertiesRequestFailedFaultTypeImpl)apiTypeObj).getJaxbTypeObj();
		} else {
			jaxbTypeObj = (EJaxbUpdateResourcePropertiesRequestFailedFaultType) 
			BaseFaultTypeImpl.toJaxbModel(apiTypeObj,
					WsrfrpJAXBContext.WSRFRP_JAXB_FACTORY.createEJaxbUpdateResourcePropertiesRequestFailedFaultType());
			
			// ~~~~ Set ResourcePropertyChangeFailure value ~~~~			
			jaxbTypeObj.setResourcePropertyChangeFailure(ResourcePropertyChangeFailureTypeImpl.toJaxbModel(
					apiTypeObj.getResourcePropertyChangeFailure()));			
		}
		return jaxbTypeObj;
	}

}
