/**
 * EasierSBS project - Java file
 * Copyright (C) 2011 EBM WebSourcing - Petals Link
 * 
 * EasySWS is free project: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 * 
 * EasySWS is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU Lesser General Public 
 * License along with this program.
 * If not, see <http://www.gnu.org/licenses/lgpl-3.0.txt>.	
 * 
 */ 
package com.petalslink.easiersbs.reasoner.api;

import com.petalslink.easiersbs.reasoner.api.engine.Reasoner;
import com.petalslink.easiersbs.reasoner.api.ontology.OntologyManager;

/**
 * @author Nicolas Boissel-Dallier - Petals Link
 */
public interface ReasonerFactory {
	
	/**
	 * @return the ontology manager
	 * @throws ReasonerException
	 */
	OntologyManager getOntologyManager() throws ReasonerException;
	
	/**
	 * Create a new reasoner
	 * 
	 * @param OntologyManager which contain source ontologies
	 * @return the new reasoner
	 * @throws ReasonerException
	 */
	Reasoner newReasoner(OntologyManager manager) throws ReasonerException;
	
}
