/**
 * EasierSBS project - Java file
 * Copyright (C) 2011 EBM WebSourcing - Petals Link
 * 
 * EasySWS is free project: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 * 
 * EasySWS is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU Lesser General Public 
 * License along with this program.
 * If not, see <http://www.gnu.org/licenses/lgpl-3.0.txt>.	
 * 
 */ 
package com.petalslink.easiersbs.reasoner.impl;

import com.petalslink.easiersbs.reasoner.api.ReasonerException;
import com.petalslink.easiersbs.reasoner.api.ReasonerFactory;
import com.petalslink.easiersbs.reasoner.api.engine.Reasoner;
import com.petalslink.easiersbs.reasoner.api.ontology.OntologyManager;
import com.petalslink.easiersbs.reasoner.impl.engine.ReasonerImpl;
import com.petalslink.easiersbs.reasoner.impl.ontology.OntologyManagerImpl;

/**
 * @author Nicolas Boissel-Dallier - Petals Link
 */
public class ReasonerFactoryImpl implements ReasonerFactory {

	
	private static ReasonerFactoryImpl instance = new ReasonerFactoryImpl();
	
	private static OntologyManager manager = new OntologyManagerImpl();
	
	private ReasonerFactoryImpl(){
		
	}
	
	public static ReasonerFactory getInstance(){
		return instance;
	}

	public OntologyManager getOntologyManager() throws ReasonerException {
		return manager;
	}

	public Reasoner newReasoner(OntologyManager manager) throws ReasonerException {
		return new ReasonerImpl(manager);
	}


}
