/*
 * Decompiled with CFR 0.152.
 */
package com.petalslink.easiersbs.reasoner.impl.ontology;

import com.petalslink.easiersbs.reasoner.api.ReasonerException;
import com.petalslink.easiersbs.reasoner.api.ontology.OntologyManager;
import java.io.File;
import java.net.URI;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.logging.Logger;
import org.semanticweb.owlapi.apibinding.OWLManager;
import org.semanticweb.owlapi.io.RDFXMLOntologyFormat;
import org.semanticweb.owlapi.model.IRI;
import org.semanticweb.owlapi.model.OWLDatatype;
import org.semanticweb.owlapi.model.OWLOntology;
import org.semanticweb.owlapi.model.OWLOntologyAlreadyExistsException;
import org.semanticweb.owlapi.model.OWLOntologyCreationException;
import org.semanticweb.owlapi.model.OWLOntologyDocumentAlreadyExistsException;
import org.semanticweb.owlapi.model.OWLOntologyFormat;
import org.semanticweb.owlapi.model.OWLOntologyManager;
import org.semanticweb.owlapi.model.OWLOntologySetProvider;
import org.semanticweb.owlapi.model.OWLOntologyStorageException;
import org.semanticweb.owlapi.util.OWLOntologyMerger;

public class OntologyManagerImpl
implements OntologyManager {
    Logger logger = Logger.getLogger(this.getClass().toString());
    private OWLOntologyManager owlManager = OWLManager.createOWLOntologyManager();
    private Map<URI, Boolean> ontologyUris = new HashMap<URI, Boolean>();
    private static final IRI EASIERSBS_ONTO_URI = IRI.create((String)"http://www.petalslink.com/ontologies/easiersbs.owl");
    private boolean hasNewOnto = false;

    public void clearOntology() {
        Set ontos = this.owlManager.getOntologies();
        for (OWLOntology onto : ontos) {
            IRI ontoIRI = this.owlManager.getOntologyDocumentIRI(onto);
            this.owlManager.removeOntology(onto);
            this.logger.finest("Ontology " + ontoIRI + " deleted.");
        }
        this.ontologyUris.clear();
        this.logger.finest("All ontologies deleted!");
    }

    public void importOntology(URI uri, boolean technical) throws ReasonerException {
        try {
            this.owlManager.setSilentMissingImportsHandling(true);
            OWLOntology onto = this.owlManager.loadOntology(IRI.create((URI)uri));
            this.ontologyUris.put(uri, technical);
            for (OWLDatatype datatype : onto.getDatatypesInSignature()) {
                this.owlManager.removeAxioms(onto, datatype.getReferencingAxioms(onto));
            }
            this.hasNewOnto = true;
            this.logger.fine("Ontology " + uri.toString() + " succefully added.");
        }
        catch (OWLOntologyAlreadyExistsException e) {
            this.logger.warning("Ontology already imported (URI: " + uri + ")");
        }
        catch (OWLOntologyDocumentAlreadyExistsException e) {
            this.logger.warning("Ontology already imported (URI: " + uri + ")");
        }
        catch (OWLOntologyCreationException e) {
            throw new ReasonerException("Problem during ontology import", (Throwable)e);
        }
    }

    public void importOntology(URI uri) throws ReasonerException {
        this.importOntology(uri, false);
    }

    public void importOntology(File file, boolean technical) throws ReasonerException {
        this.importOntology(file.toURI(), technical);
    }

    public void importOntology(File file) throws ReasonerException {
        this.importOntology(file, false);
    }

    public void exportOntology(URI target) throws ReasonerException {
        try {
            OWLOntology onto = this.getMergedOntology();
            this.owlManager.saveOntology(onto, (OWLOntologyFormat)new RDFXMLOntologyFormat(), IRI.create((URI)target));
        }
        catch (OWLOntologyStorageException e) {
            throw new ReasonerException("Problem during global ontology export in " + target.toString(), (Throwable)e);
        }
    }

    public OWLOntology getMergedOntology() throws ReasonerException {
        OWLOntologyMerger merger = new OWLOntologyMerger((OWLOntologySetProvider)this.owlManager);
        OWLOntology mergedOnto = this.owlManager.getOntology(EASIERSBS_ONTO_URI);
        if (this.hasNewOnto || mergedOnto == null) {
            if (mergedOnto != null) {
                this.owlManager.removeOntology(mergedOnto);
            }
            try {
                mergedOnto = merger.createMergedOntology(this.owlManager, EASIERSBS_ONTO_URI);
            }
            catch (OWLOntologyCreationException e) {
                throw new ReasonerException("Problem during ontology merge", (Throwable)e);
            }
            this.hasNewOnto = false;
        }
        return mergedOnto;
    }

    public OWLOntologyManager getOntologyManager() {
        return this.owlManager;
    }

    public Map<URI, Integer> getOntologiesInfo() {
        HashMap<URI, Integer> res = new HashMap<URI, Integer>();
        for (OWLOntology onto : this.owlManager.getOntologies()) {
            res.put(onto.getOntologyID().getOntologyIRI().toURI(), onto.getAxiomCount());
        }
        return res;
    }

    public Set<URI> getNamespaceUris() {
        return this.ontologyUris.keySet();
    }

    public boolean isTechnicalOntology(URI namespace) {
        if (this.ontologyUris.containsKey(namespace)) {
            return this.ontologyUris.get(namespace);
        }
        return false;
    }
}

