/*
 * Decompiled with CFR 0.152.
 */
package com.petalslink.easiersbs.reasoner.impl.engine;

import com.petalslink.easiersbs.reasoner.api.ReasonerException;
import com.petalslink.easiersbs.reasoner.api.engine.Reasoner;
import com.petalslink.easiersbs.reasoner.api.ontology.OntologyManager;
import com.petalslink.easiersbs.reasoner.impl.ontology.OntologyManagerImpl;
import java.net.URI;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import org.semanticweb.owlapi.model.IRI;
import org.semanticweb.owlapi.model.OWLClass;
import org.semanticweb.owlapi.model.OWLClassExpression;
import org.semanticweb.owlapi.model.OWLDataFactory;
import org.semanticweb.owlapi.model.OWLEntity;
import org.semanticweb.owlapi.model.OWLNamedIndividual;
import org.semanticweb.owlapi.model.OWLNamedObject;
import org.semanticweb.owlapi.model.OWLOntology;
import org.semanticweb.owlapi.model.OWLOntologyManager;
import org.semanticweb.owlapi.reasoner.ConsoleProgressMonitor;
import org.semanticweb.owlapi.reasoner.InferenceType;
import org.semanticweb.owlapi.reasoner.OWLReasoner;
import org.semanticweb.owlapi.reasoner.OWLReasonerConfiguration;
import org.semanticweb.owlapi.reasoner.OWLReasonerFactory;
import org.semanticweb.owlapi.reasoner.ReasonerProgressMonitor;
import org.semanticweb.owlapi.reasoner.SimpleConfiguration;
import org.semanticweb.owlapi.util.InferredOntologyGenerator;
import org.semanticweb.owlapi.util.InferredSubClassAxiomGenerator;
import uk.ac.manchester.cs.jfact.JFactFactory;

public class ReasonerImpl
implements Reasoner {
    private OWLReasonerFactory reasonerFactory = new JFactFactory();
    private OntologyManager easierOntoManager = null;
    private OWLOntologyManager owlapiManager = null;
    private OWLDataFactory owlapiDataFactory = null;
    private OWLOntology onto = null;
    private OWLReasoner reasoner = null;

    public ReasonerImpl(OntologyManager ontologyManager) throws ReasonerException {
        this.easierOntoManager = ontologyManager;
        this.owlapiManager = ((OntologyManagerImpl)ontologyManager).getOntologyManager();
        this.owlapiDataFactory = this.owlapiManager.getOWLDataFactory();
        this.onto = ((OntologyManagerImpl)ontologyManager).getMergedOntology();
        ConsoleProgressMonitor consoleProgressMonitor = new ConsoleProgressMonitor();
        SimpleConfiguration simpleConfiguration = new SimpleConfiguration((ReasonerProgressMonitor)consoleProgressMonitor);
        this.reasoner = this.reasonerFactory.createReasoner(this.onto, (OWLReasonerConfiguration)simpleConfiguration);
        this.reasoner.precomputeInferences(new InferenceType[]{InferenceType.CLASS_HIERARCHY});
        if (!this.reasoner.isConsistent()) {
            throw new ReasonerException("Inconsistent ontology" + this.onto.getOntologyID().toString());
        }
    }

    public Set<URI> getEquivalentClasses(URI uRI) {
        OWLClass oWLClass = this.owlapiDataFactory.getOWLClass(IRI.create((URI)uRI));
        Set set = this.reasoner.getEquivalentClasses((OWLClassExpression)oWLClass).getEntities();
        return this.getURIs(set);
    }

    public Set<URI> getSuperClasses(URI uRI) {
        OWLClass oWLClass = this.owlapiDataFactory.getOWLClass(IRI.create((URI)uRI));
        Set set = this.reasoner.getSuperClasses((OWLClassExpression)oWLClass, true).getFlattened();
        return this.getURIs(set);
    }

    public Set<URI> getSubClasses(URI uRI) {
        OWLClass oWLClass = this.owlapiDataFactory.getOWLClass(IRI.create((URI)uRI));
        Set set = this.reasoner.getSubClasses((OWLClassExpression)oWLClass, true).getFlattened();
        return this.getURIs(set);
    }

    public Set<URI> getIndividuals(URI uRI) {
        OWLClass oWLClass = this.owlapiDataFactory.getOWLClass(IRI.create((URI)uRI));
        Set set = this.reasoner.getInstances((OWLClassExpression)oWLClass, true).getFlattened();
        return this.getURIs(set);
    }

    public Set<URI> getSimilarIndividuals(URI uRI) {
        OWLNamedIndividual oWLNamedIndividual = this.owlapiDataFactory.getOWLNamedIndividual(IRI.create((URI)uRI));
        Set set = this.reasoner.getTypes(oWLNamedIndividual, true).getFlattened();
        HashSet<URI> hashSet = new HashSet<URI>();
        for (OWLClass oWLClass : set) {
            hashSet.addAll(this.getURIs(this.reasoner.getInstances((OWLClassExpression)oWLClass, true).getFlattened()));
        }
        return hashSet;
    }

    public Set<URI> getTypes(URI uRI) {
        OWLNamedIndividual oWLNamedIndividual = this.owlapiDataFactory.getOWLNamedIndividual(IRI.create((URI)uRI));
        Set set = this.reasoner.getTypes(oWLNamedIndividual, true).getFlattened();
        return this.getURIs(set);
    }

    public void infer() {
        ArrayList<InferredSubClassAxiomGenerator> arrayList = new ArrayList<InferredSubClassAxiomGenerator>();
        arrayList.add(new InferredSubClassAxiomGenerator());
        InferredOntologyGenerator inferredOntologyGenerator = new InferredOntologyGenerator(this.reasoner, arrayList);
        inferredOntologyGenerator.fillOntology(this.owlapiManager, this.onto);
    }

    public boolean isConsistent() {
        return this.reasoner.isConsistent();
    }

    public boolean isInstance(URI uRI) {
        OWLNamedIndividual oWLNamedIndividual = this.owlapiDataFactory.getOWLNamedIndividual(IRI.create((URI)uRI));
        return this.onto.isDeclared((OWLEntity)oWLNamedIndividual);
    }

    public boolean isConcept(URI uRI) {
        OWLClass oWLClass = this.owlapiDataFactory.getOWLClass(IRI.create((URI)uRI));
        return this.onto.isDeclared((OWLEntity)oWLClass);
    }

    public boolean isThingOrNothing(URI uRI) {
        OWLClass oWLClass = this.owlapiDataFactory.getOWLClass(IRI.create((URI)uRI));
        return oWLClass.isOWLThing() || oWLClass.isOWLNothing();
    }

    private Set<URI> getURIs(Set<? extends OWLNamedObject> set) {
        HashSet<URI> hashSet = new HashSet<URI>();
        Iterator<? extends OWLNamedObject> iterator = set.iterator();
        while (iterator.hasNext()) {
            hashSet.add(iterator.next().getIRI().toURI());
        }
        return hashSet;
    }

    public OWLOntology getReasonerOntology() {
        return this.onto;
    }

    public boolean isTechnicalConcept(URI uRI) {
        String string = uRI.toString().split("#")[0];
        URI uRI2 = URI.create(string);
        return this.easierOntoManager.isTechnicalOntology(uRI2);
    }
}

