/**
 * EasierSBS project - Java file
 * Copyright (C) 2011 EBM WebSourcing - Petals Link
 * 
 * EasySWS is free project: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 * 
 * EasySWS is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU Lesser General Public 
 * License along with this program.
 * If not, see <http://www.gnu.org/licenses/lgpl-3.0.txt>.	
 * 
 */ 
package com.petalslink.easiersbs.registry.service.api.model;

import java.net.URI;
import java.util.Set;

/**
 * @author Nicolas Boissel-Dallier - Petals Link
 */
public interface SemanticPart {
	
	/**
	 * Get the list of semantic concepts associated to this semantic part
	 * 
	 * @return Set of semantic concepts (as QName)	 
	 */
	public Set<URI> getSemanticConcepts();

	/**
	 * Add a new semantic concept to the semantic part
	 * 
	 * @param semanticConcept	QName representing the new concept
	 */
	public void addSemanticConcept(URI semanticConcept);
	
	/**
	 * Remove a semantic concept from the semantic part
	 * 
	 * @param semanticConcept	QName of the unwanted semantic concept
	 */
	public void removeSemanticConcept(URI semanticConcept);
	
}
