/**
 * EasierSBS project - Java file
 * Copyright (C) 2011 EBM WebSourcing - Petals Link
 * 
 * EasySWS is free project: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 * 
 * EasySWS is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU Lesser General Public 
 * License along with this program.
 * If not, see <http://www.gnu.org/licenses/lgpl-3.0.txt>.	
 * 
 */ 
package com.petalslink.easiersbs.registry.service.api;

import java.net.URL;
import java.util.Set;

import javax.xml.namespace.QName;

import org.petalslink.abslayer.service.api.Description;

import com.petalslink.easiersbs.registry.service.api.model.Operation;
import com.petalslink.easiersbs.registry.service.api.model.Partner;
import com.petalslink.easiersbs.registry.service.api.model.SemanticProfile;

/**
 * @author Nicolas Boissel-Dallier - Petals Link
 */
public interface SemanticRegistryManager {

	public void addSemanticService(QName operationQName, Description wsdlDesc, URL wsdlUrl);
	
	public void addSemanticService(QName operationQName, Description wsdlDesc, Partner partner, URL wsdlUrl);
	
	public void addSemanticService(QName operationQName, URL wsdlUrl) throws RegistryException ;
	
	public void addSemanticService(QName operationQName, URL wsdlUrl, Partner partner) throws RegistryException ;
	
	public void addSemanticServices(Description wsdlDesc, URL wsdlUrl);
	
	public void addSemanticServices(Description wsdlDesc, Partner partner, URL wsdlUrl);
	
	public void addSemanticServices(URL wsdlUrl) throws RegistryException ;
	
	public void addSemanticServices(URL wsdlUrl, Partner partner) throws RegistryException ;
	
	public void addMultipleSemanticServices(Set<URL> wsdlUrls, Partner partner);
	
	public SemanticProfile getSemanticProfile(Operation operation);
	
	public Set<SemanticProfile> getAllSemanticProfiles();
	
	public Set<SemanticProfile> findSemanticProfilesByPartner(Partner partner);
	
	public Description getTechnicalService(QName serviceQName) throws RegistryException;
	
	public URL getWsdlUrl(QName serviceQName);
	
	public Set<URL> getWsdlUrls();
	
	public Set<Description> getAllTechnicalServices();
	
	//TODO implement import from EasierGov after connection
	//public void importSemanticServicesFromEasierGov();
	
	public void removeSemanticServices(Description wsdlDesc);
	
	public void removeSemanticService(Operation operation);
	
	public void removeSemanticProfilesByPartner(Partner partner);
	
	public void clearRegistry();
	
	Description getDescription(URL wsdlUrl) throws RegistryException;

}
