/*
 * Decompiled with CFR 0.152.
 */
package com.petalslink.easiersbs.registry.service.impl.model;

import com.petalslink.easiersbs.registry.service.api.model.Partner;
import com.petalslink.easiersbs.registry.service.api.model.SemanticElement;
import com.petalslink.easiersbs.registry.service.api.model.SemanticPart;
import com.petalslink.easiersbs.registry.service.api.model.SemanticProfile;
import java.util.HashSet;
import java.util.Set;
import javax.xml.namespace.QName;

public class SemanticProfileImpl
implements SemanticProfile {
    private Set<SemanticElement> semanticInputs = new HashSet<SemanticElement>();
    private Set<SemanticElement> semanticOutputs = new HashSet<SemanticElement>();
    private SemanticPart semanticOperation = null;
    private SemanticPart semanticInterface = null;
    private QName operationQName = null;
    private Set<QName> serviceQNames = new HashSet<QName>();
    private Partner partner = null;

    public void addInputSemanticElement(SemanticElement semanticElement) {
        this.semanticInputs.add(semanticElement);
    }

    public void addOutputSemanticElement(SemanticElement semanticElement) {
        this.semanticOutputs.add(semanticElement);
    }

    public Set<SemanticElement> getInputSemanticElements() {
        return this.semanticInputs;
    }

    public Set<SemanticElement> getOutputSemanticElements() {
        return this.semanticOutputs;
    }

    public SemanticPart getSemanticInterface() {
        return this.semanticInterface;
    }

    public SemanticPart getSemanticOperation() {
        return this.semanticOperation;
    }

    public void removeInputSemanticElement(SemanticElement semanticElement) {
        this.semanticInputs.remove(semanticElement);
    }

    public void removeOutputSemanticElement(SemanticElement semanticElement) {
        this.semanticOutputs.remove(semanticElement);
    }

    public void setSemanticInterface(SemanticPart semanticPart) {
        this.semanticInterface = semanticPart;
    }

    public void setSemanticOperation(SemanticPart semanticPart) {
        this.semanticOperation = semanticPart;
    }

    public QName getOperationQName() {
        return this.operationQName;
    }

    public void setOperationQName(QName qName) {
        this.operationQName = qName;
    }

    public Set<QName> getServiceQNames() {
        return this.serviceQNames;
    }

    public void addServiceQName(QName qName) {
        this.serviceQNames.add(qName);
    }

    public void removeServiceQName(QName qName) {
        this.serviceQNames.remove(qName);
    }

    public void setInputSemanticElements(Set<SemanticElement> set) {
        this.semanticInputs = set;
    }

    public void setOutputSemanticElements(Set<SemanticElement> set) {
        this.semanticOutputs = set;
    }

    public Partner getPartner() {
        return this.partner;
    }

    public boolean hasPartner() {
        return this.partner != null;
    }

    public void setPartner(Partner partner) {
        this.partner = partner;
    }

    public boolean equals(Object object) {
        if (object instanceof SemanticProfile) {
            return this.operationQName.equals(((SemanticProfile)object).getOperationQName());
        }
        return false;
    }

    public int hashCode() {
        return this.operationQName.hashCode();
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("++++++++++++++++++++++");
        stringBuilder.append("\nSemantic profile of operation " + this.operationQName.toString());
        stringBuilder.append("\n----------------------");
        stringBuilder.append("\nThis operation is embedded in " + this.serviceQNames.toString());
        stringBuilder.append("\nIt embedded following semantic annotations:");
        stringBuilder.append("\n\tOperation: " + this.semanticOperation.toString());
        stringBuilder.append("\n\tInterface: " + this.semanticOperation.toString());
        stringBuilder.append("\n\tInput(s): ");
        for (SemanticElement semanticElement : this.semanticInputs) {
            stringBuilder.append("\n\t\t" + semanticElement.toString());
        }
        stringBuilder.append("\n\tOutput(s): ");
        for (SemanticElement semanticElement : this.semanticOutputs) {
            stringBuilder.append("\n\t\t" + semanticElement.toString());
        }
        stringBuilder.append("\n++++++++++++++++++++++");
        return stringBuilder.toString();
    }
}

