/*
 * Decompiled with CFR 0.152.
 */
package com.petalslink.easiersbs.registry.service.impl;

import com.ebmwebsourcing.easybox.api.XmlContext;
import com.ebmwebsourcing.easybox.api.XmlContextFactory;
import com.ebmwebsourcing.easybox.api.XmlObject;
import com.ebmwebsourcing.easybox.api.XmlObjectReadException;
import com.ebmwebsourcing.easybox.api.XmlObjectReader;
import com.ebmwebsourcing.easywsdl11.api.element.Definitions;
import com.petalslink.easiersbs.registry.service.api.RegistryException;
import com.petalslink.easiersbs.registry.service.api.SemanticRegistryManager;
import com.petalslink.easiersbs.registry.service.api.model.Partner;
import com.petalslink.easiersbs.registry.service.api.model.SemanticProfile;
import com.petalslink.easiersbs.registry.service.api.registry.SemanticProfileRegistry;
import com.petalslink.easiersbs.registry.service.api.registry.TechnicalServiceRegistry;
import com.petalslink.easiersbs.registry.service.impl.registry.SemanticProfileRegistryImpl;
import com.petalslink.easiersbs.registry.service.impl.registry.TechnicalServiceRegistryImpl;
import com.petalslink.easiersbs.registry.service.impl.util.ServiceUtil;
import java.net.URL;
import java.util.List;
import java.util.Set;
import javax.xml.namespace.QName;
import org.petalslink.abslayer.Factory;
import org.petalslink.abslayer.service.api.Description;
import org.petalslink.abslayer.service.api.Operation;
import org.petalslink.abslayer.service.api.Service;

public class SemanticRegistryManagerImpl
implements SemanticRegistryManager {
    SemanticProfileRegistry profiles = new SemanticProfileRegistryImpl();
    TechnicalServiceRegistry services = new TechnicalServiceRegistryImpl();
    XmlContextFactory xmlContextFactory = new XmlContextFactory();
    XmlContext xmlContext = this.xmlContextFactory.newContext();
    XmlObjectReader reader = this.xmlContext.createReader();

    public void addSemanticService(QName qName, Description description, Partner partner, URL uRL) {
        SemanticProfile semanticProfile = ServiceUtil.extractSemanticProfile(qName, description);
        semanticProfile.setPartner(partner);
        List<Service> list = ServiceUtil.findServicesByOperation(qName, description);
        for (Service service : list) {
            this.services.addTechnicalService(service.getQName(), description, uRL);
        }
        this.profiles.addSemanticProfile(semanticProfile);
    }

    public void addSemanticService(QName qName, Description description, URL uRL) {
        this.addSemanticService(qName, description, null, uRL);
    }

    public void addSemanticService(QName qName, URL uRL, Partner partner) throws RegistryException {
        Description description = this.getDescription(uRL);
        this.addSemanticService(qName, description, partner, uRL);
    }

    public void addSemanticService(QName qName, URL uRL) throws RegistryException {
        this.addSemanticService(qName, uRL, null);
    }

    public void addSemanticServices(Description description, Partner partner, URL uRL) {
        for (Operation operation : ServiceUtil.getOperations(description)) {
            this.addSemanticService(operation.inferQName(), description, partner, uRL);
        }
    }

    public void addSemanticServices(Description description, URL uRL) {
        this.addSemanticServices(description, null, uRL);
    }

    public void addSemanticServices(URL uRL, Partner partner) throws RegistryException {
        Description description = this.getDescription(uRL);
        this.addSemanticServices(description, partner, uRL);
    }

    public void addSemanticServices(URL uRL) throws RegistryException {
        this.addSemanticServices(uRL, null);
    }

    public void clearRegistry() {
        this.services.removeAllTechnicalServices();
        this.profiles.removeAllSemanticProfiles();
    }

    public SemanticProfile getSemanticProfile(QName qName) {
        return this.profiles.getSemanticProfile(qName);
    }

    public Set<SemanticProfile> getAllSemanticProfiles() {
        return this.profiles.getAllSemanticProfiles();
    }

    public Set<SemanticProfile> findSemanticProfilesByPartner(Partner partner) {
        return this.profiles.findSemanticProfilesByPartner(partner);
    }

    public Description getTechnicalService(QName qName) {
        return this.services.getTechnicalService(qName);
    }

    public URL getWsdlUrl(QName qName) {
        return this.services.getWsdlUrl(qName);
    }

    public Set<URL> getWsdlUrls() {
        return this.services.getWsdlUrls();
    }

    public Set<Description> getAllTechnicalServices() {
        return this.services.getAllTechnicalServices();
    }

    public void removeSemanticServices(Description description) {
        for (Service service : description.getServices()) {
            this.services.removeTechnicalService(service.getQName());
        }
        for (Operation operation : ServiceUtil.getOperations(description)) {
            this.profiles.removeSemanticProfile(operation.inferQName());
        }
    }

    public void removeSemanticService(QName qName) {
        SemanticProfile semanticProfile = this.profiles.getSemanticProfile(qName);
        this.profiles.removeSemanticProfile(qName);
        for (QName qName2 : semanticProfile.getServiceQNames()) {
            boolean bl = false;
            Description description = this.services.getTechnicalService(qName2);
            Set<Operation> set = ServiceUtil.findOperationsByService(qName2, description);
            for (Operation operation : set) {
                if (this.profiles.getSemanticProfile(operation.inferQName()) == null) continue;
                bl = true;
                break;
            }
            if (bl) continue;
            this.services.removeTechnicalService(qName2);
        }
    }

    public void removeSemanticProfilesByPartner(Partner partner) {
        this.profiles.removeSemanticProfilesByPartner(partner);
    }

    public Description getDescription(URL uRL) throws RegistryException {
        Definitions definitions = null;
        try {
            definitions = (Definitions)this.reader.readDocument(uRL, Definitions.class);
        }
        catch (XmlObjectReadException xmlObjectReadException) {
            throw new RegistryException("Impossible to parse WSDL file at " + uRL.toString(), (Exception)((Object)xmlObjectReadException));
        }
        return (Description)Factory.getInstance().wrap((XmlObject)definitions);
    }
}

