/**
 * EasierSBS project - Java file
 * Copyright (C) 2011 EBM WebSourcing - Petals Link
 * 
 * EasySWS is free project: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 * 
 * EasySWS is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU Lesser General Public 
 * License along with this program.
 * If not, see <http://www.gnu.org/licenses/lgpl-3.0.txt>.	
 * 
 */ 
package com.petalslink.easiersbs.registry.service.impl.model.generic;

import java.util.HashSet;
import java.util.Set;

import javax.xml.namespace.QName;

import com.petalslink.easiersbs.registry.service.api.model.generic.GenericElement;


/**
 * @author Nicolas Boissel-Dallier - Petals Link
 */
public abstract class GenericElementImpl<E extends GenericElement<E>> extends GenericPartImpl implements GenericElement<E> {

	protected Set<E> childElements = new HashSet<E>();
	
	protected boolean required = true;
	protected QName elementQName = null;
	
	public Set<E> getChildElements() {
		return childElements;
	}

	public void addChildElement(E child) {
		childElements.add(child);
	}
	
	public void setChildElements(Set<E> children) {
		this.childElements = children;
	}

	public void removeChildElement(E child) {
		childElements.remove(child);
	}
	
	public boolean hasChildElement() {
		return ( ! childElements.isEmpty());
	}
	
	public boolean isRequired() {
		return required;
	}

	public void setRequired(boolean required) {
		this.required = required;
	}

	public QName getElementQName() {
		return elementQName;
	}

	public void setElementQName(QName elementQName) {
		this.elementQName = elementQName;
	}
	
	@Override
	public boolean equals(Object other){
		if(elementQName != null){
			if(other instanceof GenericElement){
				return (elementQName.equals(((GenericElement<?>) other).getElementQName()));
			} else {
				return false;
			}
		}
		return super.equals(other);
	}

	@Override
	public int hashCode() {
		if(elementQName != null){
			return elementQName.hashCode();
		}
		return super.hashCode();
	}
	
	@Override
	public String toString(){
		StringBuilder str = new StringBuilder();
		str.append("Element " + elementQName + " (required:" + required + "): " + concepts.toString());
		if(childElements.size() != 0){
			str.append("Childs {");
			for(GenericElement<E> elem : childElements){
				str.append(elem.getName() + ", ");
			}
			str.append("}");
		}
		return str.toString();
	}
	
}