/*
 * Decompiled with CFR 0.152.
 */
package com.petalslink.easiersbs.registry.service.impl.model.generic;

import com.petalslink.easiersbs.registry.service.api.model.generic.GenericElement;
import com.petalslink.easiersbs.registry.service.impl.model.generic.GenericPartImpl;
import java.util.HashSet;
import java.util.Set;
import javax.xml.namespace.QName;

public abstract class GenericElementImpl<E extends GenericElement<E>>
extends GenericPartImpl
implements GenericElement<E> {
    protected Set<E> childElements = new HashSet();
    protected boolean required = true;
    protected QName elementQName = null;

    public Set<E> getChildElements() {
        return this.childElements;
    }

    public void addChildElement(E child) {
        this.childElements.add(child);
    }

    public void setChildElements(Set<E> children) {
        this.childElements = children;
    }

    public void removeChildElement(E child) {
        this.childElements.remove(child);
    }

    public boolean hasChildElement() {
        return !this.childElements.isEmpty();
    }

    public boolean isRequired() {
        return this.required;
    }

    public void setRequired(boolean required) {
        this.required = required;
    }

    public QName getElementQName() {
        return this.elementQName;
    }

    public void setElementQName(QName elementQName) {
        this.elementQName = elementQName;
    }

    @Override
    public boolean equals(Object other) {
        if (this.elementQName != null) {
            if (other instanceof GenericElement) {
                return this.elementQName.equals(((GenericElement)other).getElementQName());
            }
            return false;
        }
        return super.equals(other);
    }

    @Override
    public int hashCode() {
        if (this.elementQName != null) {
            return this.elementQName.hashCode();
        }
        return super.hashCode();
    }

    @Override
    public String toString() {
        StringBuilder str = new StringBuilder();
        str.append("Element " + this.elementQName + " (required:" + this.required + "): " + this.concepts.toString());
        if (this.childElements.size() != 0) {
            str.append("Childs {");
            for (GenericElement elem : this.childElements) {
                str.append(String.valueOf(elem.getName()) + ", ");
            }
            str.append("}");
        }
        return str.toString();
    }
}

