/*
 * Decompiled with CFR 0.152.
 */
package com.petalslink.easiersbs.registry.service.impl.registry;

import com.petalslink.easiersbs.registry.service.api.model.Partner;
import com.petalslink.easiersbs.registry.service.api.model.SemanticProfile;
import com.petalslink.easiersbs.registry.service.api.registry.SemanticProfileRegistry;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import javax.xml.namespace.QName;

public class SemanticProfileRegistryImpl
implements SemanticProfileRegistry {
    Map<QName, SemanticProfile> registry = new HashMap<QName, SemanticProfile>();
    Map<Partner, Set<SemanticProfile>> partnerProfiles = new HashMap<Partner, Set<SemanticProfile>>();

    public void addSemanticProfile(SemanticProfile profile) {
        this.registry.put(profile.getOperationQName(), profile);
        if (profile.hasPartner()) {
            Partner partner = profile.getPartner();
            if (this.partnerProfiles.containsKey(partner)) {
                this.partnerProfiles.get(partner).add(profile);
            } else {
                HashSet<SemanticProfile> profiles = new HashSet<SemanticProfile>();
                profiles.add(profile);
                this.partnerProfiles.put(partner, profiles);
            }
        }
    }

    public void removeSemanticProfile(QName operationQName) {
        SemanticProfile profile = this.registry.get(operationQName);
        if (profile != null) {
            this.registry.remove(operationQName);
            if (profile.hasPartner()) {
                Partner partner = profile.getPartner();
                Set<SemanticProfile> profiles = this.partnerProfiles.get(partner);
                profiles.remove(profile);
                if (profiles.isEmpty()) {
                    this.partnerProfiles.remove(partner);
                }
            }
        }
    }

    public SemanticProfile getSemanticProfile(QName operationQName) {
        return this.registry.get(operationQName);
    }

    public Set<SemanticProfile> getAllSemanticProfiles() {
        return new HashSet<SemanticProfile>(this.registry.values());
    }

    public Set<SemanticProfile> findSemanticProfilesByPartner(Partner partner) {
        return this.partnerProfiles.get(partner);
    }

    public void removeAllSemanticProfiles() {
        this.registry.clear();
        this.partnerProfiles.clear();
    }

    public void removeSemanticProfilesByPartner(Partner partner) {
        Set<SemanticProfile> tempProfiles = this.findSemanticProfilesByPartner(partner);
        for (SemanticProfile profile : tempProfiles) {
            this.registry.remove(profile.getOperationQName());
        }
        this.partnerProfiles.remove(partner);
    }
}

