package com.petalslink.easiersbs.matching.service.matcher.computation;

import java.util.concurrent.Callable;

import com.petalslink.easiersbs.matching.service.api.matcher.MatcherProperties;
import com.petalslink.easiersbs.matching.service.api.profile.infered.InferedSearchProfile;
import com.petalslink.easiersbs.matching.service.util.SimilarityUtil;
import com.petalslink.easiersbs.registry.service.api.model.SemanticProfile;

public class SemanticComputationImpl implements Callable<Double> {

	private MatcherProperties props;
	private InferedSearchProfile infProfile;
	private SemanticProfile service;

	
	public SemanticComputationImpl(MatcherProperties props, InferedSearchProfile infProfile, SemanticProfile targetService){
		this.props = props;
		this.infProfile = infProfile;
		this.service = targetService;
	}
	
	@Override
	public Double call() throws Exception {
		double interRate = SimilarityUtil.measureSemanticSimilarity(
				infProfile.getSemanticInterface().getInferedSemanticConcepts(), 
				service.getSemanticInterface().getSemanticConcepts());
		
		double opRate = SimilarityUtil.measureSemanticSimilarity(
				infProfile.getSemanticOperation().getInferedSemanticConcepts(),
				service.getSemanticOperation().getSemanticConcepts());
		
		double inRate = SimilarityUtil.measureElementSimilarity(
				infProfile.getInputSemanticElements(), 
				service.getInputSemanticElements(),
				props.getPluginMark(), props.getSubsumeMark());

		double outRate = SimilarityUtil.measureElementSimilarity(
				infProfile.getOutputSemanticElements(),
				service.getOutputSemanticElements(), 
				props.getSubsumeMark(), props.getPluginMark());
		
		
		// Qualify concept coverage
		
		double rate = ((interRate + opRate) / 2.0) * props.getOperationWeight()
					+ ((inRate + outRate) / 2.0) * props.getInputOutputWeigth();
		
		return rate;
	}

}
