/**
 * EasierSBS project - Java file
 * Copyright (C) 2011 EBM WebSourcing - Petals Link
 * 
 * EasySWS is free project: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 * 
 * EasySWS is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU Lesser General Public 
 * License along with this program.
 * If not, see <http://www.gnu.org/licenses/lgpl-3.0.txt>.	
 * 
 */ 
package com.petalslink.easiersbs.matching.service.profile;

import java.net.URI;
import java.util.Set;

import javax.xml.namespace.QName;

import com.petalslink.easiersbs.matching.service.api.matcher.MatcherProperties;
import com.petalslink.easiersbs.matching.service.api.profile.Element;
import com.petalslink.easiersbs.matching.service.api.profile.infered.InferedElement;
import com.petalslink.easiersbs.matching.service.profile.infered.InferedSemanticElementImpl;
import com.petalslink.easiersbs.reasoner.api.engine.Reasoner;
import com.petalslink.easiersbs.registry.service.api.model.SemanticElement;


/**
 * @author Nicolas Boissel-Dallier - Petals Link
 */
public class ElementImpl extends PartImpl implements Element {

	private boolean required = true;
	private QName elementQName;

	public ElementImpl(){
		
	}
	
	public ElementImpl(SemanticElement element){
		super(element.getSemanticConcepts());
		this.setElementQName(element.getElementQName());
		this.setName(element.getName());
		this.required = element.isRequired();
	}
	
	public ElementImpl(Set<URI> concepts, boolean required){
		super(concepts);
		this.required = required;
	}
	
	public InferedElement infer(Reasoner reasoner, MatcherProperties props) {
		return new InferedSemanticElementImpl(super.infer(reasoner, props).getInferedSemanticConcepts(), required);
	}
	
	public boolean isRequired() {
		return required;
	}

	public void setRequired(boolean required) {
		this.required = required;
	}

	public QName getElementQName() {
		return elementQName;
	}

	public void setElementQName(QName elementQName) {
		this.elementQName = elementQName;
	}
	
	@Override
	public String toString(){
		String result = "Element ";
		 result += " (required:" + required + "): ";
		 result += super.toString();
		return result;
	}
	
}