/*
 * Decompiled with CFR 0.152.
 */
package com.petalslink.easiersbs.matching.service.matcher.computation;

import com.petalslink.easiersbs.matching.service.api.matcher.MatcherProperties;
import com.petalslink.easiersbs.matching.service.api.profile.infered.InferedSearchProfile;
import com.petalslink.easiersbs.matching.service.util.SimilarityUtil;
import com.petalslink.easiersbs.registry.service.api.model.SemanticProfile;
import java.util.concurrent.Callable;

public class SemanticComputationImpl
implements Callable<Double> {
    private MatcherProperties props;
    private InferedSearchProfile infProfile;
    private SemanticProfile service;

    public SemanticComputationImpl(MatcherProperties matcherProperties, InferedSearchProfile inferedSearchProfile, SemanticProfile semanticProfile) {
        this.props = matcherProperties;
        this.infProfile = inferedSearchProfile;
        this.service = semanticProfile;
    }

    @Override
    public Double call() throws Exception {
        double d = SimilarityUtil.measureSemanticSimilarity(this.infProfile.getSemanticInterface().getInferedSemanticConcepts(), this.service.getSemanticInterface().getSemanticConcepts());
        double d2 = SimilarityUtil.measureSemanticSimilarity(this.infProfile.getSemanticOperation().getInferedSemanticConcepts(), this.service.getSemanticOperation().getSemanticConcepts());
        double d3 = SimilarityUtil.measureElementSimilarity(this.infProfile.getInputSemanticElements(), this.service.getInputSemanticElements(), this.props.getPluginMark(), this.props.getSubsumeMark());
        double d4 = SimilarityUtil.measureElementSimilarity(this.infProfile.getOutputSemanticElements(), this.service.getOutputSemanticElements(), this.props.getSubsumeMark(), this.props.getPluginMark());
        double d5 = (d + d2) / 2.0 * this.props.getOperationWeight() + (d3 + d4) / 2.0 * this.props.getInputOutputWeigth();
        return d5;
    }
}

