/*
 * Decompiled with CFR 0.152.
 */
package com.petalslink.easiersbs.matching.service.matcher;

import com.petalslink.easiersbs.matching.service.api.matcher.MatchingResult;
import com.petalslink.easiersbs.matching.service.api.profile.SearchProfile;
import com.petalslink.easiersbs.matching.service.api.profile.rated.RatedSemanticProfile;
import com.petalslink.easiersbs.registry.service.api.model.SemanticProfile;
import java.util.Iterator;
import java.util.SortedSet;
import java.util.TreeSet;

public class MatchingResultImpl
implements MatchingResult {
    private SortedSet<RatedSemanticProfile> profiles = new TreeSet<RatedSemanticProfile>();
    private SearchProfile query;

    public MatchingResultImpl(SearchProfile searchProfile) {
        this.query = searchProfile;
    }

    public SearchProfile getQuery() {
        return this.query;
    }

    public SortedSet<RatedSemanticProfile> getResultProfiles() {
        return this.profiles;
    }

    public void addResultProfile(RatedSemanticProfile ratedSemanticProfile) {
        this.profiles.add(ratedSemanticProfile);
    }

    public void removeResultProfile(RatedSemanticProfile ratedSemanticProfile) {
        this.profiles.remove(ratedSemanticProfile);
    }

    public boolean hasExactProfile() {
        if (this.profiles.first() != null) {
            return this.profiles.first().getProfileRate() == 1.0;
        }
        return false;
    }

    public boolean hasCorrectProfile(double d) {
        return this.profiles.first() != null && this.profiles.first().getProfileRate() > d;
    }

    public SortedSet<RatedSemanticProfile> getCorrectProfiles(double d) {
        TreeSet<RatedSemanticProfile> treeSet = new TreeSet<RatedSemanticProfile>();
        for (RatedSemanticProfile ratedSemanticProfile : this.profiles) {
            if (!(ratedSemanticProfile.getProfileRate() >= d)) continue;
            treeSet.add(ratedSemanticProfile);
        }
        return treeSet;
    }

    public RatedSemanticProfile getBestProfile() {
        return this.profiles.first();
    }

    public SortedSet<RatedSemanticProfile> getTopKProfiles(int n) {
        TreeSet<RatedSemanticProfile> treeSet = new TreeSet<RatedSemanticProfile>();
        Iterator iterator = this.profiles.iterator();
        while (iterator.hasNext() && treeSet.size() < n) {
            treeSet.add((RatedSemanticProfile)iterator.next());
        }
        return treeSet;
    }

    public RatedSemanticProfile findProfile(SemanticProfile semanticProfile) {
        for (RatedSemanticProfile ratedSemanticProfile : this.profiles) {
            if (!ratedSemanticProfile.getProfile().equals(semanticProfile)) continue;
            return ratedSemanticProfile;
        }
        return null;
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("MatchingResult for " + this.query.getOperationQName());
        for (RatedSemanticProfile ratedSemanticProfile : this.profiles) {
            stringBuilder.append("\n" + ratedSemanticProfile.toString());
        }
        return stringBuilder.toString();
    }
}

