/*
 * Decompiled with CFR 0.152.
 */
package com.petalslink.easiersbs.matching.service.matcher;

import com.petalslink.easiersbs.matching.service.SBSFactoryImpl;
import com.petalslink.easiersbs.matching.service.api.EasierSBSException;
import com.petalslink.easiersbs.matching.service.api.SBSFactory;
import com.petalslink.easiersbs.matching.service.api.matcher.HybridMatcher;
import com.petalslink.easiersbs.matching.service.api.matcher.MatcherProperties;
import com.petalslink.easiersbs.matching.service.api.matcher.MatchingResult;
import com.petalslink.easiersbs.matching.service.api.matcher.SemanticMatcher;
import com.petalslink.easiersbs.matching.service.api.matcher.SyntacticMatcher;
import com.petalslink.easiersbs.matching.service.api.profile.SearchProfile;
import com.petalslink.easiersbs.matching.service.api.profile.rated.RatedSemanticProfile;
import com.petalslink.easiersbs.matching.service.matcher.AbstractMatcherImpl;
import com.petalslink.easiersbs.matching.service.matcher.MatcherPropertiesImpl;
import com.petalslink.easiersbs.matching.service.matcher.MatchingResultImpl;
import com.petalslink.easiersbs.matching.service.profile.rated.RatedSemanticProfileImpl;
import com.petalslink.easiersbs.matching.service.util.ProfileUtil;
import com.petalslink.easiersbs.reasoner.api.ReasonerException;
import com.petalslink.easiersbs.reasoner.api.ReasonerFactory;
import com.petalslink.easiersbs.registry.service.api.SemanticRegistryManager;
import com.petalslink.easiersbs.registry.service.api.model.SemanticProfile;
import java.util.Set;

public class HybridMatcherImpl
extends AbstractMatcherImpl
implements HybridMatcher {
    private SBSFactory factory = SBSFactoryImpl.getInstance();
    private SemanticMatcher semanticMatcher;
    private SyntacticMatcher syntacticMatcher;
    private MatcherProperties props;

    public HybridMatcherImpl(ReasonerFactory reasonerFactory, SemanticRegistryManager semanticRegistryManager, MatcherProperties matcherProperties) throws ReasonerException, EasierSBSException {
        this.props = matcherProperties;
        this.registry = semanticRegistryManager;
        this.semanticMatcher = this.factory.newSemanticMatcher(reasonerFactory, semanticRegistryManager, matcherProperties);
        this.syntacticMatcher = this.factory.newSyntacticMatcher(semanticRegistryManager, matcherProperties);
    }

    public HybridMatcherImpl(ReasonerFactory reasonerFactory, SemanticRegistryManager semanticRegistryManager) throws ReasonerException, EasierSBSException {
        this(reasonerFactory, semanticRegistryManager, new MatcherPropertiesImpl());
    }

    @Override
    public void setMatcherProperties(MatcherProperties matcherProperties) {
        this.props = matcherProperties;
        this.semanticMatcher.setMatcherProperties(matcherProperties);
        this.syntacticMatcher.setMatcherProperties(matcherProperties);
    }

    public SyntacticMatcher getSyntacticMatcher() {
        return this.syntacticMatcher;
    }

    public SemanticMatcher getSemanticMatcher() {
        return this.semanticMatcher;
    }

    @Override
    public MatchingResult findServices(SearchProfile searchProfile, Set<SemanticProfile> set) {
        MatchingResultImpl matchingResultImpl;
        MatchingResult matchingResult = null;
        if (this.props.getSemanticWeight() == 0.0) {
            matchingResult = this.syntacticMatcher.findServices(searchProfile, set);
        } else if (this.props.getSyntacticWeigth() == 0.0) {
            matchingResult = this.semanticMatcher.findServices(searchProfile, set);
        } else {
            matchingResult = new MatchingResultImpl(searchProfile);
            matchingResultImpl = this.semanticMatcher.findServices(searchProfile, set);
            MatchingResult matchingResult2 = this.syntacticMatcher.findServices(searchProfile, ProfileUtil.getSemanticProfiles(matchingResultImpl.getResultProfiles()));
            for (RatedSemanticProfile ratedSemanticProfile : matchingResult2.getResultProfiles()) {
                RatedSemanticProfileImpl ratedSemanticProfileImpl = new RatedSemanticProfileImpl(ratedSemanticProfile.getProfile());
                RatedSemanticProfile ratedSemanticProfile2 = matchingResultImpl.findProfile(ratedSemanticProfile.getProfile());
                ratedSemanticProfileImpl.setProfileRate(this.getHybridRate(ratedSemanticProfile2.getProfileRate(), ratedSemanticProfile.getProfileRate()));
                ratedSemanticProfileImpl.setOperationRate(this.getHybridRate(ratedSemanticProfile2.getOperationRate(), ratedSemanticProfile.getOperationRate()));
                ratedSemanticProfileImpl.setInputCoverage(ratedSemanticProfile2.getInputCoverage());
                ratedSemanticProfileImpl.setInputRate(this.getHybridRate(ratedSemanticProfile2.getInputRate(), ratedSemanticProfile.getInputRate()));
                ratedSemanticProfileImpl.setOutputCoverage(ratedSemanticProfile2.getOutputCoverage());
                ratedSemanticProfileImpl.setOutputRate(this.getHybridRate(ratedSemanticProfile2.getOutputRate(), ratedSemanticProfile.getOutputRate()));
                matchingResult.addResultProfile((RatedSemanticProfile)ratedSemanticProfileImpl);
            }
        }
        matchingResultImpl = new MatchingResultImpl(searchProfile);
        for (Object object : matchingResult.getResultProfiles()) {
            if (!(object.getProfileRate() >= this.props.getHybridThreshold())) continue;
            matchingResultImpl.addResultProfile((RatedSemanticProfile)object);
        }
        return matchingResultImpl;
    }

    private double getHybridRate(double d, double d2) {
        return d * this.props.getSemanticWeight() + d2 * this.props.getSyntacticWeigth();
    }
}

