/*
 * Decompiled with CFR 0.152.
 */
package com.petalslink.easiersbs.matching.service.matcher.similarity;

import com.petalslink.easiersbs.matching.service.matcher.similarity.AbstractSimilarityMeasureImpl;
import com.petalslink.easiersbs.matching.service.matcher.similarity.DoubleVector;
import com.petalslink.easiersbs.matching.service.util.VectorUtil;
import java.util.List;
import java.util.Map;

public class CosineSimilarityImpl
extends AbstractSimilarityMeasureImpl {
    public CosineSimilarityImpl() {
    }

    public CosineSimilarityImpl(int n) {
        super.setLevenshteinLimit(n);
    }

    public double measureSimilarity(List<String> list, List<String> list2) {
        if (list.isEmpty() || list2.isEmpty()) {
            return 0.0;
        }
        Map<String, Integer> map = this.countWordFrequency(list);
        Map<String, Integer> map2 = this.countWordFrequency(list2);
        DoubleVector doubleVector = this.getProperVectors(map, map2);
        double d = (double)VectorUtil.dotProduct(doubleVector.getVector1(), doubleVector.getVector2()) / (VectorUtil.magnitude(doubleVector.getVector1()) * VectorUtil.magnitude(doubleVector.getVector2()));
        logger.finest("Cosine similarity fully measured: " + d);
        return d;
    }
}

