/*
 * Decompiled with CFR 0.152.
 */
package com.petalslink.easiersbs.matching.service.util;

import com.petalslink.easiersbs.matching.service.api.matcher.DegreeOfMatch;
import com.petalslink.easiersbs.matching.service.api.profile.inferred.InferredConcept;
import com.petalslink.easiersbs.matching.service.api.profile.inferred.InferredElement;
import com.petalslink.easiersbs.matching.service.api.profile.inferred.RatedURI;
import com.petalslink.easiersbs.matching.service.api.profile.rated.RatedSemanticElement;
import com.petalslink.easiersbs.matching.service.profile.inferred.RatedURIImpl;
import com.petalslink.easiersbs.matching.service.profile.rated.RatedSemanticElementImpl;
import com.petalslink.easiersbs.matching.service.util.VectorUtil;
import com.petalslink.easiersbs.registry.service.api.model.SemanticElement;
import com.petalslink.easiersbs.registry.service.api.model.generic.GenericElement;
import com.petalslink.easiersbs.registry.service.api.model.generic.GenericPart;
import com.petalslink.easiersbs.registry.service.impl.util.ServiceUtil;
import java.net.URI;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.xml.namespace.QName;

public class SimilarityUtil {
    public static List<String> extractElementRelatedWords(Set<? extends GenericPart> set) {
        ArrayList<String> arrayList = new ArrayList<String>();
        for (GenericPart genericPart : set) {
            if (genericPart.getName() != null) {
                arrayList.addAll(SimilarityUtil.splitInWords(genericPart.getName()));
            }
            if (genericPart.getSemanticConcepts().isEmpty()) continue;
            arrayList.addAll(SimilarityUtil.extractUriRelatedWords(genericPart.getSemanticConcepts()));
        }
        return arrayList;
    }

    public static List<String> extractUriRelatedWords(Set<URI> set) {
        ArrayList<String> arrayList = new ArrayList<String>();
        for (URI uRI : set) {
            String string = uRI.getFragment();
            if (string == null) continue;
            arrayList.addAll(SimilarityUtil.splitInWords(string));
        }
        return arrayList;
    }

    public static List<String> splitInWords(String string) {
        ArrayList<String> arrayList = new ArrayList<String>();
        for (String string2 : string.split("(?=[A-Z][a-z]+)|[-_0-9\\s]")) {
            if (string2.isEmpty()) continue;
            arrayList.add(string2.toLowerCase());
        }
        return arrayList;
    }

    public static double measureSemanticSimilarity(Set<InferredConcept> set, Set<URI> set2) {
        double d = 0.0;
        if (!set.isEmpty() && !set2.isEmpty()) {
            double d2 = 0.0;
            for (InferredConcept inferredConcept : set) {
                Set set3 = inferredConcept.getRatedSemanticConcepts();
                double d3 = 0.0;
                block1: for (URI uRI : set2) {
                    RatedURIImpl ratedURIImpl = new RatedURIImpl(uRI);
                    if (!set3.contains(ratedURIImpl)) continue;
                    for (RatedURI ratedURI : set3) {
                        if (!ratedURI.equals(ratedURIImpl)) continue;
                        d3 = Math.max(d3, ratedURI.getRate());
                        continue block1;
                    }
                }
                d2 += d3;
            }
            d = d2 / (double)set.size();
        }
        return d;
    }

    public static RatedSemanticElement measureElementSimilarity(InferredElement inferredElement, SemanticElement semanticElement, double d, double d2) {
        RatedSemanticElementImpl ratedSemanticElementImpl = new RatedSemanticElementImpl();
        if (inferredElement != null && semanticElement != null) {
            Object object2;
            HashMap<SemanticElement, Double> hashMap = new HashMap<SemanticElement, Double>();
            for (Object object2 : ServiceUtil.getFlattenElements((GenericElement)semanticElement)) {
                hashMap.put((SemanticElement)object2, 0.0);
            }
            HashMap hashMap2 = new HashMap();
            for (InferredElement inferredElement2 : ServiceUtil.getFlattenElements((GenericElement)inferredElement)) {
                hashMap2.put(inferredElement2, 0.0);
            }
            object2 = new HashSet();
            object2.add(inferredElement);
            double d3 = SimilarityUtil.measureElementSimilarity(inferredElement, semanticElement, hashMap, hashMap2, (Set<InferredElement>)object2);
            double d4 = 1.0;
            if (d3 == 0.0) {
                ratedSemanticElementImpl.setCoverage(DegreeOfMatch.FAIL);
            } else {
                if (!SimilarityUtil.isCoverageAcceptable(semanticElement, hashMap)) {
                    ratedSemanticElementImpl.setCoverage(DegreeOfMatch.PLUGIN);
                    d4 = d2;
                }
                if (!SimilarityUtil.isCoverageAcceptable(inferredElement, hashMap2)) {
                    if (ratedSemanticElementImpl.getCoverage() != DegreeOfMatch.PLUGIN) {
                        ratedSemanticElementImpl.setCoverage(DegreeOfMatch.SUBSUMES);
                    } else {
                        ratedSemanticElementImpl.setCoverage(DegreeOfMatch.PLUGIN_SUBSUMES);
                    }
                    d4 *= d;
                }
                if (d4 == 1.0) {
                    ratedSemanticElementImpl.setCoverage(DegreeOfMatch.EXACT);
                }
            }
            ratedSemanticElementImpl.setRate(d3 * d4);
        }
        return ratedSemanticElementImpl;
    }

    private static double measureElementSimilarity(InferredElement inferredElement, SemanticElement semanticElement, Map<SemanticElement, Double> map, Map<InferredElement, Double> map2, Set<InferredElement> set) {
        double d = 0.0;
        SemanticElement semanticElement2 = null;
        for (SemanticElement semanticElement3 : ServiceUtil.getFlattenElements((GenericElement)semanticElement)) {
            double d2 = SimilarityUtil.measureSemanticSimilarity(inferredElement.getInferedSemanticConcepts(), semanticElement3.getSemanticConcepts());
            if (!(d2 > d)) continue;
            semanticElement2 = semanticElement3;
            d = d2;
        }
        if (semanticElement2 != null) {
            map.put(semanticElement2, d);
            map2.put(inferredElement, d);
        }
        double d3 = 0.0;
        if (inferredElement.hasChildElement() && d != 1.0) {
            Double[] doubleArray = new Double[inferredElement.getChildElements().size()];
            int n = 0;
            for (InferredElement inferredElement2 : inferredElement.getChildElements()) {
                if (map2.get(inferredElement2) != 0.0 || set.contains(inferredElement2)) {
                    doubleArray[n++] = map2.get(inferredElement2);
                    continue;
                }
                set.add(inferredElement2);
                doubleArray[n++] = SimilarityUtil.measureElementSimilarity(inferredElement2, semanticElement, map, map2, set);
                set.remove(inferredElement2);
            }
            d3 = VectorUtil.average(doubleArray);
        }
        return Math.max(d, d3);
    }

    private static <E extends GenericElement<E>> boolean isCoverageAcceptable(E e, Map<E, Double> map) {
        return SimilarityUtil.isCoverageAcceptable(e, map, new HashSet());
    }

    private static <E extends GenericElement<E>> boolean isCoverageAcceptable(E e, Map<E, Double> map, Set<E> set) {
        if (map.get(e) != 0.0) {
            return true;
        }
        if (e.hasChildElement() && !set.contains(e)) {
            set.add(e);
            for (GenericElement genericElement : e.getChildElements()) {
                if (SimilarityUtil.isCoverageAcceptable(genericElement, map, set)) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    public static Map<QName, QName> findElementMatchings(InferredElement inferredElement, SemanticElement semanticElement) {
        return SimilarityUtil.findElementMatchings(inferredElement, semanticElement, new HashSet<QName>());
    }

    private static Map<QName, QName> findElementMatchings(InferredElement inferredElement, SemanticElement semanticElement, Set<QName> set) {
        HashMap<QName, QName> hashMap = new HashMap<QName, QName>();
        RatedSemanticElement ratedSemanticElement = SimilarityUtil.measureElementSimilarity(inferredElement, semanticElement, 0.5, 0.5);
        set.add(inferredElement.getElementQName());
        set.add(semanticElement.getElementQName());
        if (ratedSemanticElement.getCoverage().equals((Object)DegreeOfMatch.FAIL)) {
            return hashMap;
        }
        if (ratedSemanticElement.getCoverage().equals((Object)DegreeOfMatch.EXACT)) {
            hashMap.put(inferredElement.getElementQName(), semanticElement.getElementQName());
        } else {
            if (ratedSemanticElement.getCoverage().equals((Object)DegreeOfMatch.SUBSUMES) || ratedSemanticElement.getCoverage().equals((Object)DegreeOfMatch.PLUGIN_SUBSUMES)) {
                for (InferredElement inferredElement2 : inferredElement.getChildElements()) {
                    if (set.contains(inferredElement2.getElementQName())) continue;
                    hashMap.putAll(SimilarityUtil.findElementMatchings(inferredElement2, semanticElement, set));
                }
            }
            if (ratedSemanticElement.getCoverage().equals((Object)DegreeOfMatch.PLUGIN) || ratedSemanticElement.getCoverage().equals((Object)DegreeOfMatch.PLUGIN_SUBSUMES)) {
                for (InferredElement inferredElement2 : semanticElement.getChildElements()) {
                    if (set.contains(inferredElement2.getElementQName())) continue;
                    hashMap.putAll(SimilarityUtil.findElementMatchings(inferredElement, (SemanticElement)inferredElement2, set));
                }
            }
        }
        return hashMap;
    }
}

