/*
 * Decompiled with CFR 0.152.
 */
package org.jvnet.substance;

import java.awt.Component;
import java.awt.Cursor;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.UIManager;
import javax.swing.border.EmptyBorder;
import javax.swing.plaf.basic.BasicSplitPaneDivider;
import org.jvnet.substance.SubstanceFillBackgroundDelegate;
import org.jvnet.substance.SubstanceImageCreator;
import org.jvnet.substance.SubstanceSplitPaneUI;
import org.jvnet.substance.grip.DragBumpsGripPainter;
import org.jvnet.substance.grip.GripPainter;
import org.jvnet.substance.theme.SubstanceTheme;
import org.jvnet.substance.utils.ComponentState;
import org.jvnet.substance.utils.SubstanceCoreUtilities;
import org.jvnet.substance.utils.SubstanceSizeUtils;

public class SubstanceSplitPaneDivider
extends BasicSplitPaneDivider {
    private SubstanceFillBackgroundDelegate bgDelegate = new SubstanceFillBackgroundDelegate();
    private static final GripPainter defaultGripPainter = new DragBumpsGripPainter();

    public SubstanceSplitPaneDivider(SubstanceSplitPaneUI ui) {
        super(ui);
        this.splitPane.setBackground(UIManager.getColor("SplitPane.dividerFocusColor"));
    }

    public void paint(Graphics g) {
        GripPainter gripPainter;
        if (SubstanceCoreUtilities.hasFlatAppearance(this.splitPane, false)) {
            this.bgDelegate.updateIfOpaque(g, this.splitPane);
        }
        if ((gripPainter = SubstanceCoreUtilities.getGripPainter(this.splitPane, defaultGripPainter)) != null) {
            Graphics2D graphics = (Graphics2D)g.create();
            SubstanceTheme gripTheme = SubstanceCoreUtilities.getTheme((Component)this.splitPane, this.splitPane.isEnabled() ? ComponentState.DEFAULT : ComponentState.DISABLED_UNSELECTED, true, false);
            gripPainter.paintGrip(this.splitPane, graphics, gripTheme, new Rectangle(0, 0, this.getWidth(), this.getHeight()), this.splitPane.getOrientation() == 1, this.splitPane.getComponentOrientation());
            graphics.dispose();
        }
        super.paint(g);
    }

    protected JButton createLeftOneTouchButton() {
        Icon verticalSplit = SubstanceImageCreator.getArrowIcon(SubstanceSizeUtils.getComponentFontSize(this.splitPane), -2, -1, 0.0f, 1, SubstanceCoreUtilities.getActiveTheme(this.splitPane, true));
        Icon horizontalSplit = SubstanceImageCreator.getArrowIcon(SubstanceSizeUtils.getComponentFontSize(this.splitPane), -2, -1, 0.0f, 7, SubstanceCoreUtilities.getActiveTheme(this.splitPane, true));
        JButton b = new JButton(this.splitPane.getOrientation() == 0 ? verticalSplit : horizontalSplit){

            public boolean isFocusable() {
                return false;
            }
        };
        b.putClientProperty("substancelaf.buttonpaintnever", Boolean.TRUE);
        b.setBorder(new EmptyBorder(0, 0, 0, 0));
        b.setRequestFocusEnabled(false);
        b.setCursor(Cursor.getPredefinedCursor(12));
        b.setFocusPainted(false);
        b.setBorderPainted(false);
        return b;
    }

    protected JButton createRightOneTouchButton() {
        Icon verticalSplit = SubstanceImageCreator.getArrowIcon(SubstanceSizeUtils.getComponentFontSize(this.splitPane), -2, -1, 0.0f, 5, SubstanceCoreUtilities.getActiveTheme(this.splitPane, true));
        Icon horizontalSplit = SubstanceImageCreator.getArrowIcon(SubstanceSizeUtils.getComponentFontSize(this.splitPane), -2, -1, 0.0f, 3, SubstanceCoreUtilities.getActiveTheme(this.splitPane, true));
        JButton b = new JButton(this.splitPane.getOrientation() == 0 ? verticalSplit : horizontalSplit){

            public boolean isFocusable() {
                return false;
            }
        };
        b.putClientProperty("substancelaf.buttonpaintnever", Boolean.TRUE);
        b.setBorder(new EmptyBorder(0, 0, 0, 0));
        b.setCursor(Cursor.getPredefinedCursor(12));
        b.setFocusPainted(false);
        b.setBorderPainted(false);
        b.setRequestFocusEnabled(false);
        return b;
    }

    public void updateOneTouchButtons(int orientation) {
        int fontSize = SubstanceSizeUtils.getComponentFontSize(this.splitPane);
        if (orientation == 0) {
            if (this.leftButton != null) {
                this.leftButton.setIcon(SubstanceImageCreator.getArrowIcon(fontSize, -2, -1, 0.0f, 1, SubstanceCoreUtilities.getActiveTheme(this.splitPane, true)));
            }
            if (this.rightButton != null) {
                this.rightButton.setIcon(SubstanceImageCreator.getArrowIcon(fontSize, -2, -1, 0.0f, 5, SubstanceCoreUtilities.getActiveTheme(this.splitPane, true)));
            }
        } else {
            if (this.leftButton != null) {
                this.leftButton.setIcon(SubstanceImageCreator.getArrowIcon(fontSize, -2, -1, 0.0f, 7, SubstanceCoreUtilities.getActiveTheme(this.splitPane, true)));
            }
            if (this.rightButton != null) {
                this.rightButton.setIcon(SubstanceImageCreator.getArrowIcon(fontSize, -2, -1, 0.0f, 3, SubstanceCoreUtilities.getActiveTheme(this.splitPane, true)));
            }
        }
    }
}

