/*
 * Decompiled with CFR 0.152.
 */
package org.petalslink.easiestdemo.client.model.impl.ws;

import com.ebmwebsourcing.easycommons.soap.handler.SOAPException;
import com.ebmwebsourcing.easycommons.xml.XMLPrettyPrinter;
import com.ebmwebsourcing.easyesb.exchange10.api.type.PatternType;
import com.ebmwebsourcing.easywsdl11.api.element.BindingOperation;
import com.ebmwebsourcing.soapbinding11.api.SoapBindingHelper;
import org.petalslink.easiestdemo.client.Constants;
import org.petalslink.easiestdemo.client.model.api.ws.MockBinding;
import org.petalslink.easiestdemo.client.model.api.ws.MockOperation;
import org.w3c.dom.Document;

public class MockOperationImpl
implements MockOperation {
    private org.petalslink.abslayer.service.api.BindingOperation bop;
    private MockBinding b;
    private String soapAction;
    private String request;
    private PatternType pattern;
    private static int cpt = 0;

    public MockOperationImpl(MockBinding b, org.petalslink.abslayer.service.api.BindingOperation bop) throws SOAPException {
        this.b = b;
        this.bop = bop;
        this.pattern = this.bop.getBindingOperationOutput() == null ? PatternType.IN_ONLY : PatternType.IN_OUT;
        this.soapAction = "\"" + SoapBindingHelper.getSoapOperation((BindingOperation)((BindingOperation)bop.getModel())).getSoapAction() + "\"";
        this.request = this.bop.findOperation().getInput().getElement().inferQName().equals(Constants.WS_SUBSCRIBE_ELEMENT) ? this.generateSubscribeRequest() : this.printRequest();
    }

    private String generateSubscribeRequest() {
        String res = "<?xml version=\"1.0\" encoding=\"UTF-8\"?>\r\n<soap-env:Envelope xmlns:soap-env=\"http://schemas.xmlsoap.org/soap/envelope/\" xmlns:xsd=\"http://www.w3.org/1999/XMLSchema\" xmlns:xsi=\"http://www.w3.org/1999/XMLSchema-instance\">\r\n  <soap-env:Body>\r\n    <wsn:Subscribe xmlns:add=\"http://www.w3.org/2005/08/addressing\" xmlns:wsn=\"http://docs.oasis-open.org/wsn/b-2\" targetnamespace=\"http://docs.oasis-open.org/wsn/b-2\">\r\n      <wsn:ConsumerReference>\r\n        <add:Address>" + this.generateNotificationServerAddress() + "</add:Address>\r\n" + "      </wsn:ConsumerReference>\r\n";
        res = this.getBinding().getEndpoint().getName().toLowerCase().contains("wsdm") ? String.valueOf(res) + "      <wsn:Filter>\r\n" + "        <wsn:TopicExpression Dialect=\"http://www.w3.org/TR/1999/REC-xpath-19991116\"\r\n" + "\t\t\t\t\txmlns:mows-ev=\"http://docs.oasis-open.org/wsdm/2004/12/mows/wsdm-mows-events.xml\">\r\n" + "\t\t\t\t\tmows-ev:MetricsCapability\r\n" + "\t\t </wsn:TopicExpression>\r\n" + "      </wsn:Filter>\r\n" : String.valueOf(res) + "      <wsn:Filter>\r\n" + "        <!-- No filter: I subscribe for all events provided by this Event producer -->\r\n" + "      </wsn:Filter>\r\n";
        res = String.valueOf(res) + "    </wsn:Subscribe>\r\n" + "  </soap-env:Body>\r\n" + "</soap-env:Envelope>\r\n";
        return res;
    }

    private String generateNotificationServerAddress() {
        String port = String.valueOf(9800 + cpt);
        ++cpt;
        String res = "http://localhost:" + port + "/" + this.b.getEndpoint().getName();
        return res;
    }

    @Override
    public MockBinding getBinding() {
        return this.b;
    }

    @Override
    public String getName() {
        return this.bop.getName();
    }

    public String printRequest() throws SOAPException {
        Document doc = this.b.getEndpoint().getService().getSOAPMessageGenerator().generateSoapRequest(this.bop);
        return XMLPrettyPrinter.prettyPrint((Document)doc);
    }

    @Override
    public String getRequest() {
        return this.request;
    }

    @Override
    public String getSoapAction() {
        return this.soapAction;
    }

    @Override
    public void setRequest(String req) {
        this.request = req;
    }

    public String toString() {
        return this.getName();
    }

    @Override
    public PatternType getPattern() {
        return this.pattern;
    }

    @Override
    public void setPattern(PatternType pattern) {
        this.pattern = pattern;
    }
}

