/*
 * Decompiled with CFR 0.152.
 */
package org.petalslink.easiestdemo.client.topology.menu.action;

import java.awt.Dimension;
import java.awt.EventQueue;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.GroupLayout;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JSlider;
import javax.swing.LayoutStyle;
import javax.swing.UIManager;
import javax.swing.UnsupportedLookAndFeelException;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.petalslink.easiestdemo.client.WSOUIClient;
import org.petalslink.easiestdemo.client.topology.RectangleG;

public class CustomizedViewFrame
extends JFrame {
    private static final long serialVersionUID = 1L;
    private WSOUIClient client;
    private JButton jButtonOK;
    private JCheckBox jCheckBoxShowClient;
    private JLabel jLabelRectangleHeight;
    private JLabel jLabelRectangleShape;
    private JLabel jLabelRectangleWidth;
    private JLabel jLabelResizeShape;
    private JSlider jSliderRectangleHeight;
    private JSlider jSliderRectangleWidth;

    public CustomizedViewFrame(WSOUIClient wsouiClient) {
        this.initComponents();
        this.client = wsouiClient;
        this.setTitle("Customized View");
        this.setIconImage(Toolkit.getDefaultToolkit().getImage(WSOUIClient.ICON_IMAGE));
        this.setSize(new Dimension(400, 300));
        this.jSliderRectangleWidth.setMinimum(0);
        this.jSliderRectangleWidth.setMaximum(300);
        this.jSliderRectangleWidth.setValue(RectangleG.DEFAULT_WIDTH);
        this.jSliderRectangleWidth.setMajorTickSpacing(100);
        this.jSliderRectangleWidth.setMinorTickSpacing(10);
        this.jSliderRectangleWidth.setPaintTicks(true);
        this.jSliderRectangleWidth.setPaintLabels(true);
        this.jSliderRectangleHeight.setMinimum(0);
        this.jSliderRectangleHeight.setMaximum(300);
        this.jSliderRectangleHeight.setValue(RectangleG.DEFAULT_WIDTH);
        this.jSliderRectangleHeight.setMajorTickSpacing(100);
        this.jSliderRectangleHeight.setMinorTickSpacing(10);
        this.jSliderRectangleHeight.setPaintTicks(true);
        this.jSliderRectangleHeight.setPaintLabels(true);
    }

    public boolean showClientEndpoint() {
        return this.jCheckBoxShowClient.isSelected();
    }

    public int getRectangleWidth() {
        return this.jSliderRectangleWidth.getValue();
    }

    public int getRectangleHeight() {
        return this.jSliderRectangleHeight.getValue();
    }

    private void initComponents() {
        this.jCheckBoxShowClient = new JCheckBox();
        this.jLabelResizeShape = new JLabel();
        this.jLabelRectangleShape = new JLabel();
        this.jSliderRectangleWidth = new JSlider();
        this.jLabelRectangleWidth = new JLabel();
        this.jLabelRectangleHeight = new JLabel();
        this.jSliderRectangleHeight = new JSlider();
        this.jButtonOK = new JButton();
        this.setDefaultCloseOperation(3);
        this.jCheckBoxShowClient.setSelected(true);
        this.jCheckBoxShowClient.setText("Show client endpoint");
        this.jCheckBoxShowClient.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                CustomizedViewFrame.this.jCheckBoxShowClientActionPerformed(evt);
            }
        });
        this.jLabelResizeShape.setText("Resize shape:");
        this.jLabelRectangleShape.setText("- Rectangle:");
        this.jSliderRectangleWidth.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent evt) {
                CustomizedViewFrame.this.jSliderRectangleWidthStateChanged(evt);
            }
        });
        this.jLabelRectangleWidth.setText("width:");
        this.jLabelRectangleHeight.setText("height:");
        this.jSliderRectangleHeight.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent evt) {
                CustomizedViewFrame.this.jSliderRectangleHeightStateChanged(evt);
            }
        });
        this.jButtonOK.setText("OK");
        this.jButtonOK.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                CustomizedViewFrame.this.jButtonOKActionPerformed(evt);
            }
        });
        GroupLayout layout = new GroupLayout(this.getContentPane());
        this.getContentPane().setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jCheckBoxShowClient).addComponent(this.jLabelResizeShape).addGroup(layout.createSequentialGroup().addGap(10, 10, 10).addComponent(this.jLabelRectangleShape)))).addGroup(layout.createSequentialGroup().addGap(44, 44, 44).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addComponent(this.jLabelRectangleWidth).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jSliderRectangleWidth, -2, -1, -2)).addGroup(layout.createSequentialGroup().addComponent(this.jLabelRectangleHeight).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jSliderRectangleHeight, -2, -1, -2))))).addContainerGap(14, Short.MAX_VALUE)).addGroup(GroupLayout.Alignment.TRAILING, layout.createSequentialGroup().addContainerGap(239, Short.MAX_VALUE).addComponent(this.jButtonOK).addContainerGap()));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addComponent(this.jCheckBoxShowClient).addGap(18, 18, 18).addComponent(this.jLabelResizeShape).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jLabelRectangleShape).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING, false).addComponent(this.jLabelRectangleWidth, -1, -1, Short.MAX_VALUE).addComponent(this.jSliderRectangleWidth, -1, -1, Short.MAX_VALUE)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING, false).addComponent(this.jLabelRectangleHeight, -1, -1, Short.MAX_VALUE).addComponent(this.jSliderRectangleHeight, -1, -1, Short.MAX_VALUE)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, -1, Short.MAX_VALUE).addComponent(this.jButtonOK).addContainerGap()));
        this.pack();
    }

    private void jCheckBoxShowClientActionPerformed(ActionEvent evt) {
        if (this.client.getTopology() != null) {
            this.client.getTopology().refresh();
        }
    }

    private void jSliderRectangleWidthStateChanged(ChangeEvent evt) {
        if (this.client.getTopology() != null) {
            this.client.getTopology().refresh();
        }
    }

    private void jSliderRectangleHeightStateChanged(ChangeEvent evt) {
        if (this.client.getTopology() != null) {
            this.client.getTopology().refresh();
        }
    }

    private void jButtonOKActionPerformed(ActionEvent evt) {
        this.setVisible(false);
    }

    public static void main(String[] args) {
        try {
            UIManager.LookAndFeelInfo[] lookAndFeelInfoArray = UIManager.getInstalledLookAndFeels();
            int n = lookAndFeelInfoArray.length;
            int n2 = 0;
            while (n2 < n) {
                UIManager.LookAndFeelInfo info = lookAndFeelInfoArray[n2];
                if ("Nimbus".equals(info.getName())) {
                    UIManager.setLookAndFeel(info.getClassName());
                    break;
                }
                ++n2;
            }
        }
        catch (ClassNotFoundException ex) {
            Logger.getLogger(CustomizedViewFrame.class.getName()).log(Level.SEVERE, null, ex);
        }
        catch (InstantiationException ex) {
            Logger.getLogger(CustomizedViewFrame.class.getName()).log(Level.SEVERE, null, ex);
        }
        catch (IllegalAccessException ex) {
            Logger.getLogger(CustomizedViewFrame.class.getName()).log(Level.SEVERE, null, ex);
        }
        catch (UnsupportedLookAndFeelException ex) {
            Logger.getLogger(CustomizedViewFrame.class.getName()).log(Level.SEVERE, null, ex);
        }
        EventQueue.invokeLater(new Runnable(){

            @Override
            public void run() {
                new CustomizedViewFrame(null).setVisible(true);
            }
        });
    }
}

