/*
 * Decompiled with CFR 0.152.
 */
package org.petalslink.easiestdemo.client.topology;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.util.ArrayList;
import java.util.List;
import javax.xml.namespace.QName;
import org.petalslink.abslayer.service.api.Service;
import org.petalslink.easiestdemo.client.gui.Property;
import org.petalslink.easiestdemo.client.model.api.esb.ClientEndpointProxy;
import org.petalslink.easiestdemo.client.model.api.esb.Node;
import org.petalslink.easiestdemo.client.model.api.esb.ProviderEndpoint;
import org.petalslink.easiestdemo.client.model.api.esb.ProviderEndpointProxy;
import org.petalslink.easiestdemo.client.topology.InternalClientProxyEndpointG;
import org.petalslink.easiestdemo.client.topology.InternalProviderEndpointG;
import org.petalslink.easiestdemo.client.topology.InternalProviderProxyEndpointG;
import org.petalslink.easiestdemo.client.topology.RectangleG;
import org.petalslink.easiestdemo.client.topology.TopologyView;

public class EsbG
extends RectangleG {
    private List<InternalClientProxyEndpointG> proxyClients = new ArrayList<InternalClientProxyEndpointG>();
    private List<InternalProviderEndpointG> providers = new ArrayList<InternalProviderEndpointG>();
    private List<InternalProviderProxyEndpointG> proxyProviders = new ArrayList<InternalProviderProxyEndpointG>();
    private Node model = null;

    public EsbG(TopologyView topology, Node node, int init_x, int init_y) {
        super(topology, node.getQName().getLocalPart(), init_x, init_y);
        this.model = node;
        if (this.model.isMonitoringNode()) {
            this.setBackgroundColor(new Color(84, 255, 159));
        }
        this.properties.add(new Property("name", this.model.getQName().getLocalPart()));
        this.properties.add(new Property("namespace", this.model.getQName().getNamespaceURI()));
        this.properties.add(new Property("administration service url", ((Service)this.model.getAdministrationServiceDescription().getServices().iterator().next()).getEndpoints()[0].getAddress()));
        this.properties.add(new Property("neighbour nodes", this.model.getNeighbourNodeNames()));
        this.properties.add(new Property("number of client proxy endpoints", this.model.getClientEndpointProxies().size()));
        this.properties.add(new Property("number of provider endpoints", this.model.getProviderEndpoints().size()));
        this.properties.add(new Property("number of provider proxy endpoints", this.model.getProviderEndpointProxies().size()));
    }

    public void update(Graphics g) {
        Graphics2D g2 = (Graphics2D)g;
        g2.setStroke(new BasicStroke(8.0f));
        this.proxyClients.clear();
        for (ClientEndpointProxy cep : this.model.getClientEndpointProxies()) {
            this.proxyClients.add(new InternalClientProxyEndpointG(this.topology, cep));
        }
        this.providers.clear();
        for (ProviderEndpoint pe : this.model.getProviderEndpoints()) {
            this.providers.add(new InternalProviderEndpointG(this.topology, pe));
        }
        this.proxyProviders.clear();
        for (ProviderEndpointProxy pep : this.model.getProviderEndpointProxies()) {
            this.proxyProviders.add(new InternalProviderProxyEndpointG(this.topology, pep));
        }
        this.draw(g2);
        int init_x = this.rect.x - InternalClientProxyEndpointG.DEFAULT_SIZE / 2;
        int spacey = this.rect.height / (this.proxyClients.size() + 1);
        int init_y = this.rect.y + spacey;
        for (InternalClientProxyEndpointG internalClientProxyEndpointG : this.proxyClients) {
            internalClientProxyEndpointG.setLocation(init_x, init_y);
            internalClientProxyEndpointG.update(g2);
            init_y += spacey;
        }
        init_x = (int)((double)this.rect.x + this.rect.getWidth() / 2.0 - (double)(InternalProviderEndpointG.DEFAULT_SIZE / 2));
        spacey = this.rect.height / (this.providers.size() + 1);
        init_y = this.rect.y + spacey;
        for (InternalProviderEndpointG internalProviderEndpointG : this.providers) {
            internalProviderEndpointG.setLocation(init_x, init_y);
            internalProviderEndpointG.update(g2);
            init_y += spacey;
        }
        init_x = (int)((double)this.rect.x + this.rect.getWidth() - (double)(InternalProviderProxyEndpointG.DEFAULT_SIZE / 2));
        spacey = this.rect.height / (this.proxyProviders.size() + 1);
        init_y = this.rect.y + spacey;
        for (InternalProviderProxyEndpointG internalProviderProxyEndpointG : this.proxyProviders) {
            internalProviderProxyEndpointG.setLocation(init_x, init_y);
            internalProviderProxyEndpointG.update(g2);
            init_y += spacey;
        }
    }

    public List<InternalProviderProxyEndpointG> getProxyProviders() {
        return this.proxyProviders;
    }

    public List<InternalClientProxyEndpointG> getProxyClients() {
        return this.proxyClients;
    }

    public List<InternalProviderEndpointG> getProviders() {
        return this.providers;
    }

    public QName getQName() {
        return this.model.getQName();
    }

    public List<QName> getNeighbourNodeNames() {
        return this.model.getNeighbourNodeNames();
    }

    public Node getModel() {
        return this.model;
    }
}

