/*
 * Decompiled with CFR 0.152.
 */
package org.petalslink.easiestdemo.client.topology;

import com.petalslink.easycommons.explorer.TextG;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionAdapter;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.ArrayList;
import java.util.List;
import javax.swing.GroupLayout;
import javax.swing.JPanel;
import javax.xml.namespace.QName;
import org.petalslink.easiestdemo.client.WSOUIClient;
import org.petalslink.easiestdemo.client.WSOUIClientException;
import org.petalslink.easiestdemo.client.gui.PropertiesTableModel;
import org.petalslink.easiestdemo.client.model.api.Registry;
import org.petalslink.easiestdemo.client.model.api.esb.ClientEndpointProxy;
import org.petalslink.easiestdemo.client.model.api.esb.Node;
import org.petalslink.easiestdemo.client.model.api.gov.ProvidedService;
import org.petalslink.easiestdemo.client.model.api.ws.MockEndpoint;
import org.petalslink.easiestdemo.client.model.api.ws.MockService;
import org.petalslink.easiestdemo.client.model.impl.gov.ProvidedServiceImpl;
import org.petalslink.easiestdemo.client.topology.EndpointG;
import org.petalslink.easiestdemo.client.topology.EsbG;
import org.petalslink.easiestdemo.client.topology.ExternalClientEndpointG;
import org.petalslink.easiestdemo.client.topology.ExternalEndpointG;
import org.petalslink.easiestdemo.client.topology.ExternalProviderEndpointG;
import org.petalslink.easiestdemo.client.topology.GovG;
import org.petalslink.easiestdemo.client.topology.InternalClientProxyEndpointG;
import org.petalslink.easiestdemo.client.topology.InternalProviderEndpointG;
import org.petalslink.easiestdemo.client.topology.InternalProviderProxyEndpointG;
import org.petalslink.easiestdemo.client.topology.LineEsbOrGovToEndpointG;
import org.petalslink.easiestdemo.client.topology.LineEsbToEsbG;
import org.petalslink.easiestdemo.client.topology.LineEsbToGovG;
import org.petalslink.easiestdemo.client.topology.LineMonitoringToEsbG;
import org.petalslink.easiestdemo.client.topology.ProvidedServiceG;
import org.petalslink.easiestdemo.client.topology.menu.MenuMouseTopology;
import org.petalslink.easiestdemo.client.topology.menu.action.CallWebServiceFrame;

public class TopologyView
extends JPanel {
    private static final long serialVersionUID = 1L;
    protected List<ExternalClientEndpointG> externalClientEndpoints = new ArrayList<ExternalClientEndpointG>();
    protected List<ExternalProviderEndpointG> externalProviderEndpoints = new ArrayList<ExternalProviderEndpointG>();
    protected List<LineEsbToEsbG> esblines = new ArrayList<LineEsbToEsbG>();
    protected List<LineMonitoringToEsbG> monitoringlines = new ArrayList<LineMonitoringToEsbG>();
    protected List<LineEsbToGovG> govlines = new ArrayList<LineEsbToGovG>();
    protected List<LineEsbOrGovToEndpointG> lines = new ArrayList<LineEsbOrGovToEndpointG>();
    protected List<EsbG> esbs = new ArrayList<EsbG>();
    protected GovG govg = null;
    protected TextG internalEndpointToPrint = null;
    protected WSOUIClient client = null;
    protected Registry registry = null;
    protected Object draggedItem = null;
    boolean pressOut = false;
    private MenuMouseTopology mmt = null;

    public TopologyView(Dimension dim, WSOUIClient client) {
        this.initComponents();
        this.setBackground(Color.white);
        this.setSize(dim);
        this.client = client;
        if (client != null) {
            this.registry = client.getRegistry();
            this.mmt = new MenuMouseTopology(this.client);
            this.draggedItem = null;
            this.refresh();
        }
    }

    public WSOUIClient getClient() {
        return this.client;
    }

    public void refresh() {
        int spacey_client;
        int spacey;
        int init_x = (int)this.getSize().getWidth() / 2 - EsbG.DEFAULT_WIDTH / 2;
        int init_y = spacey = this.getSize().height / (this.registry.getAllNodes().size() + 1);
        int init_client_x = 0;
        int init_client_y = spacey_client = 0;
        for (Node node : this.registry.getAllNodes()) {
            if (this.findEsbGCorrespondingToThisNode(node) == null) {
                this.esbs.add(new EsbG(this, node, init_x, init_y - EsbG.DEFAULT_HEIGHT / 2));
                init_y += spacey;
            }
            init_client_x = this.getSize().width * 1 / 5 / 2;
            init_client_y = spacey_client = this.getSize().height / (this.registry.getAllClientEndpointProxy().size() + 1);
            for (ClientEndpointProxy client : node.getClientEndpointProxies()) {
                if (this.findExternalClientEndpointGCorrespondingToThisEndpoint(client) != null) continue;
                this.externalClientEndpoints.add(new ExternalClientEndpointG(this, client, init_client_x, init_client_y));
                init_client_y += spacey_client;
            }
        }
        if (this.registry.getGovNode() != null) {
            this.govg = new GovG(this, this.registry.getGovNode(), this.getSize().width - (EsbG.DEFAULT_WIDTH + 10), 10);
            init_client_x = this.getSize().width - (EsbG.DEFAULT_WIDTH + EsbG.DEFAULT_WIDTH / 2);
            init_client_y = spacey_client = this.getSize().height / (this.registry.getGovNode().getProvidedServices().size() + 1);
            for (ProvidedService providedService : this.registry.getGovNode().getProvidedServices()) {
                if (this.findExternalClientEndpointGCorrespondingToThisEndpoint(providedService) != null) continue;
                this.externalClientEndpoints.add(new ExternalClientEndpointG(this, providedService, init_client_x, init_client_y));
                init_client_y += spacey_client;
            }
        }
        init_x = this.getSize().width * 4 / 5 + this.getSize().width * 1 / 5 / 2;
        init_y = spacey = this.getSize().height / (this.registry.getAllWebServicesPartnerEndpoint().size() + 1);
        for (MockService service : this.registry.getWebServices()) {
            for (MockEndpoint endpoint : service.getEndpoints()) {
                if (this.findExternalProviderEndpointGCorrespondingToThisEndpoint(endpoint) != null) continue;
                this.externalProviderEndpoints.add(new ExternalProviderEndpointG(this, endpoint, init_x, init_y));
                init_y += spacey;
            }
        }
        this.repaint();
    }

    private ExternalProviderEndpointG findExternalProviderEndpointGCorrespondingToThisEndpoint(MockEndpoint endpoint) {
        for (ExternalProviderEndpointG provider : this.externalProviderEndpoints) {
            if (!provider.getQName().getLocalPart().equals(endpoint.getName())) continue;
            return provider;
        }
        return null;
    }

    protected ExternalClientEndpointG findExternalClientEndpointGCorrespondingToThisEndpoint(ClientEndpointProxy ep) {
        for (ExternalClientEndpointG client : this.externalClientEndpoints) {
            if (!(!(client.getModel() instanceof ProvidedServiceImpl) ? client.getModel().getName().getLocalPart().equals(ep.getName().getLocalPart()) && client.getModel().getNode().getQName().equals(ep.getNode().getQName()) : client.getModel().getName().getLocalPart().equals(ep.getName().getLocalPart()))) continue;
            return client;
        }
        return null;
    }

    private EsbG findEsbGCorrespondingToThisNode(Node node) {
        for (EsbG esb : this.esbs) {
            if (esb.getModel() != node) continue;
            return esb;
        }
        return null;
    }

    public Object getObjectContainedIn(MouseEvent evt) {
        Object res = null;
        for (EsbG esb : this.esbs) {
            for (InternalClientProxyEndpointG icpe : esb.getProxyClients()) {
                if (res != null || !icpe.contains(evt.getX(), evt.getY())) continue;
                res = icpe;
                break;
            }
            if (res == null) {
                for (InternalProviderProxyEndpointG ippe : esb.getProxyProviders()) {
                    if (res != null || !ippe.contains(evt.getX(), evt.getY())) continue;
                    res = ippe;
                    break;
                }
            }
            if (res == null) {
                for (InternalProviderEndpointG ipe : esb.getProviders()) {
                    if (res != null || !ipe.contains(evt.getX(), evt.getY())) continue;
                    res = ipe;
                    break;
                }
            }
            if (res != null || !esb.contains(evt.getX(), evt.getY())) continue;
            res = esb;
            break;
        }
        if (res == null) {
            for (ExternalProviderEndpointG pe : this.externalProviderEndpoints) {
                if (!pe.contains(evt.getX(), evt.getY())) continue;
                res = pe;
                break;
            }
        }
        if (res == null) {
            for (ExternalClientEndpointG ce : this.externalClientEndpoints) {
                if (!ce.contains(evt.getX(), evt.getY())) continue;
                res = ce;
                break;
            }
        }
        if (res == null && this.govg != null) {
            for (ProvidedServiceG providedService : this.govg.getProvidedServices()) {
                if (res != null || !providedService.contains(evt.getX(), evt.getY())) continue;
                res = providedService;
                break;
            }
        }
        return res;
    }

    public void clear() {
        this.esbs.clear();
        this.externalClientEndpoints.clear();
        this.externalProviderEndpoints.clear();
        this.draggedItem = null;
    }

    public EsbG findEsbG(QName name) {
        EsbG res = null;
        for (EsbG esb : this.esbs) {
            if (!esb.getQName().equals(name)) continue;
            res = esb;
            break;
        }
        return res;
    }

    @Override
    public void paint(Graphics g) {
        Graphics2D g2 = (Graphics2D)g;
        g2.setPaint(Color.white);
        g2.drawRect(0, 0, this.getWidth(), this.getHeight());
        g2.fillRect(0, 0, this.getWidth(), this.getHeight());
        this.draw(g);
        g.dispose();
    }

    protected void draw(Graphics g) {
        this.esblines.clear();
        this.monitoringlines.clear();
        this.govlines.clear();
        for (EsbG esbG : this.esbs) {
            for (QName neighbourName : esbG.getNeighbourNodeNames()) {
                EsbG esb2 = this.findEsbG(neighbourName);
                this.esblines.add(new LineEsbToEsbG(esbG, esb2));
            }
            if (!esbG.getModel().isMonitoringNode()) continue;
            ExternalClientEndpointG dispatcherEp = null;
            for (InternalClientProxyEndpointG ic : esbG.getProxyClients()) {
                if (!ic.getQName().getLocalPart().equals("DispatcherProviderEndpoint")) continue;
                dispatcherEp = this.findExternalClientEndpointGCorrespondingToThisEndpoint((ClientEndpointProxy)ic.getModel());
                break;
            }
            if (dispatcherEp == null) continue;
            try {
                for (Node n : esbG.getModel().getMonitoredNodes()) {
                    EsbG esb2 = this.findEsbG(n.getQName());
                    if (esb2 == null) continue;
                    if (this.client.getCustomView().showClientEndpoint()) {
                        this.monitoringlines.add(new LineMonitoringToEsbG(dispatcherEp, esb2));
                        continue;
                    }
                    this.monitoringlines.add(new LineMonitoringToEsbG(esbG, esb2));
                }
            }
            catch (WSOUIClientException e) {
                e.printStackTrace();
            }
        }
        if (this.govg != null) {
            try {
                for (Node node : this.registry.getGovNode().getConnectedNodes()) {
                    EsbG esb = this.findEsbGCorrespondingToThisNode(node);
                    this.govlines.add(new LineEsbToGovG(esb, this.govg));
                }
            }
            catch (WSOUIClientException e) {
                e.printStackTrace();
            }
        }
        for (LineEsbToEsbG lineEsbToEsbG : this.esblines) {
            lineEsbToEsbG.update(g);
        }
        for (LineMonitoringToEsbG lineMonitoringToEsbG : this.monitoringlines) {
            lineMonitoringToEsbG.update(g);
        }
        for (LineEsbToGovG lineEsbToGovG : this.govlines) {
            lineEsbToGovG.update(g);
        }
        for (EsbG esbG : this.esbs) {
            esbG.update(g);
        }
        this.lines.clear();
        if (this.govg != null && this.client.getCustomView().showClientEndpoint()) {
            for (ProvidedServiceG providedServiceG : this.govg.getProvidedServices()) {
                for (ExternalClientEndpointG ece : this.externalClientEndpoints) {
                    if (!providedServiceG.getQName().equals(ece.getQName())) continue;
                    this.lines.add(new LineEsbOrGovToEndpointG(providedServiceG, ece));
                }
            }
        }
        for (EsbG esbG : this.esbs) {
            for (InternalProviderProxyEndpointG ippe : esbG.getProxyProviders()) {
                for (ExternalProviderEndpointG epe : this.externalProviderEndpoints) {
                    if (!ippe.getQName().equals(epe.getQName())) continue;
                    this.lines.add(new LineEsbOrGovToEndpointG(ippe, epe));
                }
            }
            if (!this.client.getCustomView().showClientEndpoint()) continue;
            for (InternalClientProxyEndpointG icpe : esbG.getProxyClients()) {
                for (ExternalClientEndpointG ece : this.externalClientEndpoints) {
                    if (!icpe.getQName().equals(ece.getQName())) continue;
                    this.lines.add(new LineEsbOrGovToEndpointG(icpe, ece));
                }
            }
        }
        for (LineEsbOrGovToEndpointG lineEsbOrGovToEndpointG : this.lines) {
            lineEsbOrGovToEndpointG.update(g);
        }
        if (this.govg != null) {
            this.govg.update(g);
        }
        if (this.client.getCustomView().showClientEndpoint()) {
            for (ExternalClientEndpointG externalClientEndpointG : this.externalClientEndpoints) {
                ((EndpointG)externalClientEndpointG).update(g);
            }
        }
        for (ExternalProviderEndpointG externalProviderEndpointG : this.externalProviderEndpoints) {
            ((EndpointG)externalProviderEndpointG).update(g);
        }
        if (this.internalEndpointToPrint != null) {
            g.setColor(this.internalEndpointToPrint.getColor());
            g.drawString(this.internalEndpointToPrint.getText(), (int)this.internalEndpointToPrint.getX(), (int)this.internalEndpointToPrint.getY());
        }
    }

    public static void main(String[] argv) {
        TopologyView topology = new TopologyView(new Dimension(1100, 600), null);
        Frame f = new Frame("Topology View");
        f.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent e) {
                System.exit(0);
            }
        });
        f.add(topology);
        f.pack();
        f.setVisible(true);
        f.repaint();
    }

    private void initComponents() {
        this.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent evt) {
                TopologyView.this.formMouseClicked(evt);
            }

            @Override
            public void mouseEntered(MouseEvent evt) {
                TopologyView.this.formMouseEntered(evt);
            }

            @Override
            public void mousePressed(MouseEvent evt) {
                TopologyView.this.formMousePressed(evt);
            }

            @Override
            public void mouseReleased(MouseEvent evt) {
                TopologyView.this.formMouseReleased(evt);
            }
        });
        this.addMouseMotionListener(new MouseMotionAdapter(){

            @Override
            public void mouseDragged(MouseEvent evt) {
                TopologyView.this.formMouseDragged(evt);
            }

            @Override
            public void mouseMoved(MouseEvent evt) {
                TopologyView.this.formMouseMoved(evt);
            }
        });
        GroupLayout layout = new GroupLayout(this);
        this.setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGap(0, 887, Short.MAX_VALUE));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGap(0, 557, Short.MAX_VALUE));
    }

    private void formMouseClicked(MouseEvent evt) {
        this.repaint();
        this.mmt.setVisible(false);
        Object selectedItem = this.getObjectContainedIn(evt);
        if (evt.getButton() == 3) {
            this.mmt.setSelectedItem(selectedItem);
            this.mmt.setLocation(evt.getX() + this.client.getX(), evt.getY() + this.client.getY() + 70);
            this.mmt.setVisible(true);
        } else if (evt.getButton() == 1 && evt.getClickCount() == 2 && selectedItem instanceof ExternalEndpointG) {
            CallWebServiceFrame callWebService = new CallWebServiceFrame(this.client, (ExternalEndpointG)selectedItem);
            callWebService.setVisible(true);
        } else if (evt.getButton() == 1 && evt.getClickCount() == 2 && selectedItem instanceof InternalClientProxyEndpointG) {
            ExternalClientEndpointG externalEndpoint = this.findExternalClientEndpointGCorrespondingToThisEndpoint((ClientEndpointProxy)((InternalClientProxyEndpointG)selectedItem).getModel());
            CallWebServiceFrame callWebService = new CallWebServiceFrame(this.client, externalEndpoint);
            callWebService.setVisible(true);
        } else if (evt.getButton() == 1 && evt.getClickCount() == 2 && selectedItem instanceof ProvidedServiceG) {
            ExternalClientEndpointG externalEndpoint = this.findExternalClientEndpointGCorrespondingToThisEndpoint(((ProvidedServiceG)selectedItem).getModel());
            CallWebServiceFrame callWebService = new CallWebServiceFrame(this.client, externalEndpoint);
            callWebService.setVisible(true);
        }
    }

    protected void formMouseDragged(MouseEvent evt) {
        if (this.draggedItem != null) {
            if (this.draggedItem instanceof EsbG) {
                ((EsbG)this.draggedItem).setLocation(evt.getX(), evt.getY());
            } else if (this.draggedItem instanceof EndpointG) {
                ((EndpointG)this.draggedItem).setLocation(evt.getX(), evt.getY());
            } else if (this.draggedItem instanceof GovG) {
                ((GovG)this.draggedItem).setLocation(evt.getX(), evt.getY());
            }
            this.repaint();
        }
    }

    protected void formMousePressed(MouseEvent evt) {
        this.draggedItem = null;
        for (EsbG esb : this.esbs) {
            if (!esb.contains(evt.getX(), evt.getY())) continue;
            this.draggedItem = esb;
            esb.setMove(true);
            break;
        }
        if (this.draggedItem == null) {
            for (ExternalProviderEndpointG pe : this.externalProviderEndpoints) {
                if (!pe.contains(evt.getX(), evt.getY())) continue;
                this.draggedItem = pe;
                pe.setMove(true);
                break;
            }
        }
        if (this.draggedItem == null) {
            for (ExternalClientEndpointG ce : this.externalClientEndpoints) {
                if (!ce.contains(evt.getX(), evt.getY())) continue;
                this.draggedItem = ce;
                ce.setMove(true);
                break;
            }
        }
        if (this.draggedItem == null && this.govg != null && this.govg.contains(evt.getX(), evt.getY())) {
            this.draggedItem = this.govg;
            this.govg.setMove(true);
        }
    }

    protected void formMouseReleased(MouseEvent evt) {
        if (this.draggedItem instanceof EsbG) {
            ((EsbG)this.draggedItem).setMove(false);
        }
        if (this.draggedItem instanceof EndpointG) {
            ((EndpointG)this.draggedItem).setMove(false);
        }
        if (this.draggedItem instanceof GovG) {
            ((GovG)this.draggedItem).setMove(false);
        }
        this.draggedItem = null;
    }

    protected void formMouseMoved(MouseEvent evt) {
        Object selectedItem = this.getObjectContainedIn(evt);
        this.internalEndpointToPrint = null;
        if (selectedItem instanceof EsbG) {
            this.client.getjTableProperties().setModel(new PropertiesTableModel(((EsbG)selectedItem).getProperties()));
        } else if (selectedItem instanceof ProvidedServiceG) {
            ProvidedServiceG ipe = (ProvidedServiceG)selectedItem;
            this.internalEndpointToPrint = new TextG(ipe.getQName().getLocalPart(), Color.black, (double)((int)ipe.getCenterX() - ipe.getSize() / 2), (double)((int)ipe.getCenterY() + ipe.getSize()));
        } else if (selectedItem instanceof EndpointG) {
            this.client.getjTableProperties().setModel(new PropertiesTableModel(((EndpointG)selectedItem).getProperties()));
            if (selectedItem instanceof InternalProviderEndpointG) {
                InternalProviderEndpointG ipe = (InternalProviderEndpointG)selectedItem;
                this.internalEndpointToPrint = new TextG(ipe.getQName().getLocalPart(), Color.black, (double)((int)ipe.getCenterX() - ipe.getSize() / 2), (double)((int)ipe.getCenterY() + ipe.getSize()));
            } else if (selectedItem instanceof InternalClientProxyEndpointG) {
                InternalClientProxyEndpointG ipe = (InternalClientProxyEndpointG)selectedItem;
                this.internalEndpointToPrint = new TextG(ipe.getQName().getLocalPart(), Color.black, (double)((int)ipe.getCenterX() - ipe.getSize() / 2), (double)((int)ipe.getCenterY() + ipe.getSize()));
            } else {
                this.internalEndpointToPrint = null;
            }
        } else if (selectedItem instanceof GovG) {
            this.client.getjTableProperties().setModel(new PropertiesTableModel(((GovG)selectedItem).getProperties()));
        }
        this.repaint();
    }

    protected void formMouseEntered(MouseEvent evt) {
    }
}

