/*
 * To change this template, choose Tools | Templates
 * and open the template in the editor.
 */

/*
 * AddWsdlFrame.java
 *
 * Created on 24 févr. 2011, 09:28:29
 */

package org.petalslink.easiestdemo.client;

import java.awt.Toolkit;
import java.io.File;
import java.net.MalformedURLException;
import java.net.URL;

import javax.swing.JFileChooser;
import javax.swing.JOptionPane;

import org.petalslink.abslayer.service.api.Description;

/**
 *
 * @author nsalatge
 */
public class AddWsdlFrame extends javax.swing.JFrame {

    private WSOUIClient client;

    /** Creates new form AddWsdlFrame */
    public AddWsdlFrame(WSOUIClient client) {
        initComponents();
        this.setTitle("Add new Web Service");
        if(client != null) {
            this.jPanelMain.setBackground(client.getColor());
        }
        this.client = client;

        this.setLocation();
    }

    private void setLocation() {
        double heightScreen = Toolkit.getDefaultToolkit().getScreenSize().getHeight();
        double witdhScreen = Toolkit.getDefaultToolkit().getScreenSize().getWidth();
        this.setLocation((int)witdhScreen/2 - this.getWidth()/2, (int)heightScreen/2 - this.getHeight()/2);
    }



    /** This method is called from within the constructor to
     * initialize the form.
     * WARNING: Do NOT modify this code. The content of this method is
     * always regenerated by the Form Editor.
     */
    @SuppressWarnings("unchecked")
    // <editor-fold defaultstate="collapsed" desc="Generated Code">//GEN-BEGIN:initComponents
    private void initComponents() {

        jPanelMain = new javax.swing.JPanel();
        jLabelAddWsdl = new javax.swing.JLabel();
        jTextFieldAddWsdl = new javax.swing.JTextField();
        jButtonBrowse = new javax.swing.JButton();
        jButtonOK = new javax.swing.JButton();

        jLabelAddWsdl.setText("Add wsdl url:");

        jTextFieldAddWsdl.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                jButtonOKActionPerformed(evt);
            }
        });

        jButtonBrowse.setText("Browse");
        jButtonBrowse.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                jButtonBrowseActionPerformed(evt);
            }
        });

        jButtonOK.setText("OK");
        jButtonOK.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                jButtonOKActionPerformed(evt);
            }
        });

        javax.swing.GroupLayout jPanelMainLayout = new javax.swing.GroupLayout(jPanelMain);
        jPanelMain.setLayout(jPanelMainLayout);
        jPanelMainLayout.setHorizontalGroup(
                jPanelMainLayout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
                .addGroup(javax.swing.GroupLayout.Alignment.TRAILING, jPanelMainLayout.createSequentialGroup()
                        .addContainerGap()
                        .addGroup(jPanelMainLayout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
                                .addGroup(jPanelMainLayout.createSequentialGroup()
                                        .addComponent(jLabelAddWsdl)
                                        .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                                        .addComponent(jTextFieldAddWsdl, javax.swing.GroupLayout.PREFERRED_SIZE, 453, javax.swing.GroupLayout.PREFERRED_SIZE)
                                        .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                                        .addComponent(jButtonBrowse, javax.swing.GroupLayout.DEFAULT_SIZE, 105, Short.MAX_VALUE))
                                        .addComponent(jButtonOK, javax.swing.GroupLayout.Alignment.TRAILING))
                                        .addContainerGap())
                );
        jPanelMainLayout.setVerticalGroup(
                jPanelMainLayout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
                .addGroup(jPanelMainLayout.createSequentialGroup()
                        .addContainerGap()
                        .addGroup(jPanelMainLayout.createParallelGroup(javax.swing.GroupLayout.Alignment.BASELINE)
                                .addComponent(jLabelAddWsdl)
                                .addComponent(jTextFieldAddWsdl, javax.swing.GroupLayout.PREFERRED_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE)
                                .addComponent(jButtonBrowse))
                                .addGap(18, 18, 18)
                                .addComponent(jButtonOK)
                                .addContainerGap(25, Short.MAX_VALUE))
                );

        javax.swing.GroupLayout layout = new javax.swing.GroupLayout(getContentPane());
        getContentPane().setLayout(layout);
        layout.setHorizontalGroup(
                layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
                .addComponent(jPanelMain, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, Short.MAX_VALUE)
                );
        layout.setVerticalGroup(
                layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
                .addComponent(jPanelMain, javax.swing.GroupLayout.PREFERRED_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE)
                );

        pack();
    }// </editor-fold>//GEN-END:initComponents

    private void jButtonBrowseActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_jButtonBrowseActionPerformed
        JFileChooser c = new JFileChooser();
        c.addChoosableFileFilter(new WSDLFilter());
        c.setAcceptAllFileFilterUsed(false);


        // Demonstrate "Open" dialog:
        int rVal = c.showOpenDialog(this);
        if (rVal == JFileChooser.APPROVE_OPTION) {
            jTextFieldAddWsdl.setText(c.getSelectedFile().getAbsolutePath());
        }
        if (rVal == JFileChooser.CANCEL_OPTION) {
            jTextFieldAddWsdl.setText("");
        }
    }//GEN-LAST:event_jButtonBrowseActionPerformed

    private void jButtonOKActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_jButtonOKActionPerformed
        addNewWsdl(this.jTextFieldAddWsdl.getText());
    }//GEN-LAST:event_jButtonOKActionPerformed







    public void addNewWsdl(String wsdl) {
        try {
            if(wsdl != null && wsdl.trim().length() > 0) {
                URL wsdlURL = null;
                if(new File(wsdl).exists()) {
                    wsdlURL = new File(wsdl).toURI().toURL();
                } else {
                    wsdlURL = new URL(wsdl);
                }
                if(this.client != null) {
                    this.client.addNewWsdlofWebServices(wsdlURL);
                    this.client.refreshAll();
                    this.setVisible(false);
                }
            }
        } catch (MalformedURLException e) {
            e.printStackTrace();
            JOptionPane.showMessageDialog(this, e.getMessage(), "Error", JOptionPane.ERROR_MESSAGE);
        } catch (WSOUIClientException e) {
            e.printStackTrace();
            JOptionPane.showMessageDialog(this, e.getMessage(), "Error", JOptionPane.ERROR_MESSAGE);
        }
    }

    /**
     * @param args the command line arguments
     */
    public static void main(String args[]) {
        java.awt.EventQueue.invokeLater(new Runnable() {
            public void run() {
                new AddWsdlFrame(null).setVisible(true);
            }
        });
    }

    // Variables declaration - do not modify//GEN-BEGIN:variables
    private javax.swing.JButton jButtonBrowse;
    private javax.swing.JButton jButtonOK;
    private javax.swing.JLabel jLabelAddWsdl;
    private javax.swing.JPanel jPanelMain;
    private javax.swing.JTextField jTextFieldAddWsdl;
    // End of variables declaration//GEN-END:variables

}
