/**
 * PETALS - PETALS Services Platform.
 * Copyright (c) 2006 EBM Websourcing, http://www.ebmwebsourcing.com/
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 * -------------------------------------------------------------------------
 * $Id$
 * -------------------------------------------------------------------------
 */

package org.petalslink.easiestdemo.client.model.impl.ws;

import javax.xml.namespace.QName;

import org.jdom.JDOMException;
import org.petalslink.abslayer.service.api.BindingOperation;
import org.petalslink.easiestdemo.client.Constants;
import org.petalslink.easiestdemo.client.model.api.ws.MockBinding;
import org.petalslink.easiestdemo.client.model.api.ws.MockOperation;
import org.w3c.dom.Document;

import com.ebmwebsourcing.easiestdemo.contant.EasiestDEMOFramework;
import com.ebmwebsourcing.easycommons.research.util.SOAException;
import com.ebmwebsourcing.easycommons.research.util.dom.DOMUtil;
import com.ebmwebsourcing.easycommons.research.util.easybox.SOAUtil;
import com.ebmwebsourcing.easycommons.soap.handler.SOAPException;
import com.ebmwebsourcing.easycommons.soap.handler.SOAPHandler;
import com.ebmwebsourcing.easycommons.soap.handler.SOAPSender;
import com.ebmwebsourcing.easycommons.xml.XMLPrettyPrinter;
import com.ebmwebsourcing.easyesb.exchange10.api.type.PatternType;
import com.ebmwebsourcing.soapbinding11.api.SoapBindingHelper;
import com.ebmwebsourcing.wsstar.basenotification.datatypes.api.abstraction.Subscribe;
import com.ebmwebsourcing.wsstar.basenotification.datatypes.api.utils.WsnbException;
import com.ebmwebsourcing.wsstar.wsnb.services.impl.util.WSNHelper;
import com.ebmwebsourcing.wsstar.wsnb.services.impl.util.Wsnb4ServUtils;

import easybox.org.oasis_open.docs.wsn.b_2.EJaxbSubscribe;

/**
 *
 *
 * @author Nicolas SALATGE - eBM WebSourcing
 */
public class MockOperationImpl implements MockOperation {

	private BindingOperation bop;

	private MockBinding b;

	private String soapAction;

	private String request;

	private PatternType pattern;

	private static int cpt = 0;

	public MockOperationImpl(MockBinding b, BindingOperation bop) throws SOAPException  {
		this.b = b;
		this.bop = bop;

		if(this.bop.getBindingOperationOutput() == null){
			this.pattern = PatternType.IN_ONLY;
		}else{
			this.pattern = PatternType.IN_OUT;
		}

		this.soapAction = "\"" + SoapBindingHelper.getSoapOperation((com.ebmwebsourcing.easywsdl11.api.element.BindingOperation) bop.getModel()).getSoapAction() + "\"";

		if(this.bop != null && this.bop.findOperation() != null && this.bop.findOperation().getInput() != null && 
				this.bop.findOperation().getInput().getElement() != null && 
				this.bop.findOperation().getInput().getElement().inferQName() != null &&
				this.bop.findOperation().getInput().getElement().inferQName().equals(Constants.WS_SUBSCRIBE_ELEMENT)) {
			this.request = generateSubscribeRequest();
		} else {
			this.request = this.printRequest();
		}
	}

	private String generateSubscribeRequest() {
		
		QName topicUsed = new QName("http://docs.oasis-open.org/wsdm/2004/12/mows/wsdm-mows-events.xml", "MetricsCapability", "res");
		com.ebmwebsourcing.wsstar.basenotification.datatypes.api.abstraction.Subscribe payload = null;
		String res = null;
		
		try {
			if(this.getBinding().getEndpoint().getName().toLowerCase().contains("wsdm")) {
				payload = WSNHelper.createSubscription(generateNotificationServerAddress(), topicUsed);
			}else{
				QName topicToDefine = new QName("http://defineTopicNamespace", "defineTopic");
				payload = WSNHelper.createSubscription(generateNotificationServerAddress(), topicToDefine);
			}
		
			
			res = XMLPrettyPrinter.prettyPrint(SOAPSender.createSOAPMessageRequest(Wsnb4ServUtils.getWsnbWriter().writeSubscribeAsDOM(payload)));
		
		} catch (WsnbException e) {
			// TODO Auto-generated catch block
			e.printStackTrace();
		} catch (SOAException e) {
			// TODO Auto-generated catch block
			e.printStackTrace();
		} catch (JDOMException e) {
			// TODO Auto-generated catch block
			e.printStackTrace();
		}
		
		
		
		return res;
	}

	private String generateNotificationServerAddress() {
		String port = String.valueOf(9800 + cpt);
		cpt++;
		String res = "http://localhost:" + port + "/" + this.b.getEndpoint().getName();
		return res;
	}

	public MockBinding getBinding() {
		return this.b;
	}

	public String getName() {
		return this.bop.getName();
	}


	public String printRequest() throws SOAPException  {
		Document doc = this.b.getEndpoint().getService().getSOAPMessageGenerator().generateSoapRequest(bop);

		return XMLPrettyPrinter.prettyPrint(doc);
	}

	@Override
	public String getRequest() {
		return this.request;
	}


	@Override
	public String getSoapAction() {
		return this.soapAction;
	}

	@Override
	public void setRequest(String req) {
		this.request = req;
	}

	public String toString() {
		return this.getName();
	}

	@Override
	public PatternType getPattern() {
		return this.pattern;
	}

	@Override
	public void setPattern(PatternType pattern) {
		this.pattern = pattern;

	}


}
