package org.petalslink.easiestdemo.wsoui.core.wsdl;

import java.io.File;
import java.io.FileWriter;
import java.io.IOException;

import org.petalslink.easiestdemo.wsoui.core.WSOUIException;
import org.petalslink.easiestdemo.wsoui.core.reflexive.ImplMetaInf;
import org.petalslink.easiestdemo.wsoui.core.reflexive.Method;
import org.petalslink.easiestdemo.wsoui.core.reflexive.Parameter;

import com.ebmwebsourcing.easycommons.research.util.io.FileUtil;


public class ExchangeProcessorGenerator {

	private ImplMetaInf imf;

	private boolean override = false;
	
	private String tns;

	public ExchangeProcessorGenerator(String tns, ImplMetaInf imf, boolean override) throws WSOUIException {
		this.imf = imf;
		this.override = override;
		this.tns = tns;
	}



	private String generateImplementationMethod(Method m) {
		String res = "" +
		"\t\t// Add nominal business exchange\n" +
		"\t\tExchange<" + Parameter.findType(m.getInputParams().get(0).getType()) + ", " + Parameter.findType(m.getOutputParam().getType()) + ", ?> nominalExchange = new Exchange(" + Parameter.createType(m.getInputParams().get(0).getType()) + ", " +  Parameter.createType(m.getOutputParam().getType()) + ");\n" +
		"\t\tthis.addExpectedExchange(\"" + m.getName() + "\", nominalExchange);\n" + 
		"\t\t// Add business information on expected request: nominalExchange.getExpectedRequest().set(...)\n" +
		"\t\t// TODO\n" +
		"\t\t// Add business information on expected response: nominalExchange.getExpectedResponse().set(...)\n" +
		"\t\t// TODO\n" +
		"\n\n\n\n";
		for(String exception: m.getExceptions()) {
			String varException = this.createVariableException(exception);
			res = res + "\t\t// Add fault exchange for " + exception + "\n" +
			"\t\tExchange<" + Parameter.findType(m.getInputParams().get(0).getType()) + ", ?, " + exception + "> " + varException + "Exchange = new Exchange(" + Parameter.createType(m.getInputParams().get(0).getType()) + ", new " +  exception + "());\n" +
			"\t\tthis.addExpectedExchange(\"" + m.getName() + "\", " + varException + "Exchange);\n" + 
			"\t\t// Add business information on expected fault: " + varException + "Exchange.getExpectedFault().set(...)\n" +
			"\t\t// TODO\n" +
			"\n\n";
		}
		res = res + "\n\n" +
		"\t\t// You can add other exchanges if needed\n" ;
		return res;
	}




	private String createVariableException(String exception) {
		String var = exception;
		if(exception.lastIndexOf(".") != -1) {
			var = exception.substring(exception.lastIndexOf(".")+1, exception.length());
		}
		return var;
	}



	public File generate(String basedir) throws IOException {
		String className = imf.getServiceName().substring(0, 1).toUpperCase() + imf.getServiceName().substring(1, imf.getServiceName().length());
		className = className + "_ExchangeProcessor";

		String packageName = FileUtil.createPackageNameFromTargetNamespace(this.tns);
		
		File dir = new File(basedir + "/" + packageName.replace(".", "/"));
		if(!dir.exists()) {
			dir.mkdirs();
		}

		File f = FileUtil.createFile(className, packageName, basedir, ".java", this.override);
		FileWriter writer = null;
		try {
			writer = new FileWriter(f);

			// create package
			writer.write("package " + packageName + ";\n");
			writer.write("\n");

			// create imports
			for(String impt: imf.getImports()) {
				writer.write("import " + impt + ";\n");
			}
			// add specific import
			writer.write("import org.petalslink.easiestdemo.wsoui.provided.AbstractImplementationManager;\n");
			writer.write("import org.petalslink.easiestdemo.wsoui.provided.AbstractTestImplementation;\n");
			writer.write("import org.petalslink.easiestdemo.wsoui.provided.AbstractExchangeProcessor;\n");
			writer.write("import org.petalslink.easiestdemo.wsoui.provided.Exchange;\n");
			writer.write("\n");


			// create class
			writer.write("public class " + className + " extends AbstractExchangeProcessor {\n");
			writer.write("\n");

			// create constructor
			writer.write("\tpublic " + className + "() {\n");
			for(Method m: imf.getSignatureMethods()) {
				writer.write("\tcreateAllExchangesFor_" + m.getName() + "();\n" );
			}
			writer.write("\t}\n");
			writer.write("\n");

			// create all methods
			for(Method m: imf.getSignatureMethods()) {
				writer.write("\tpublic void " + "createAllExchangesFor_" + m.getName() + "()" );

				writer.write(" {\n");
				writer.write(this.generateImplementationMethod(m));
				writer.write("\t}\n\n\n");
			}

			writer.write("\n");
			writer.write("}\n");



		} finally{
			if(writer != null){
				writer.close();
			}
		}

		return f;
	}

}
