package org.petalslink.easiestdemo.wsoui.plugin.bpel;

import java.io.File;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.Arrays;
import java.util.List;


import com.ebmwebsourcing.easycommons.uri.URIHelper;

public class BpelOption {

	/**
	 * The BPEL file to process.
	 */
	String bpel;

	/**
	 * @parameter
	 */
	boolean generateBusinessClass = true;

	/**
	 * @parameter
	 */
	boolean overrideOlderBusinessClass = false;

	/**
	 * Specific factory can be set to create the ESB node.
	 */
	String esbFactoryCanonicalName = null;

	/**
	 * @parameter
	 */
	String[] ignoreWsdl;


	public URI getBpelURI(URI baseURI) throws MalformedURLException, URISyntaxException {
		String bpelLocation = getBpel().replace("\\", "/");
		File bpelFile = new File(bpelLocation);
		return bpelFile.exists() ? bpelFile.toURI() 
				: URIHelper.resolve(baseURI, bpelLocation);
	}

	public String getBpel() {
		return bpel;
	}

	public void setBpel(String w) {
		bpel = w;
	}

	public boolean isGenerateBusinessClass() {
		return generateBusinessClass;
	}

	public void setGenerateBusinessClass(boolean generateBusinessClass) {
		this.generateBusinessClass = generateBusinessClass;
	}

	public boolean isOverrideOlderBusinessClass() {
		return overrideOlderBusinessClass;
	}

	public void setOverrideOlderBusinessClass(boolean overrideOlderBusinessClass) {
		this.overrideOlderBusinessClass = overrideOlderBusinessClass;
	}

	public String getEsbFactoryCanonicalName() {
		return esbFactoryCanonicalName;
	}

	public void setEsbFactoryCanonicalName(String esbFactoryCanonicalName) {
		this.esbFactoryCanonicalName = esbFactoryCanonicalName;
	}

	public List<String> getIgnoreWsdls() {
		if(this.ignoreWsdl != null) {
			return Arrays.asList(this.ignoreWsdl);
		}
		return null;
	}

}
