/*
 * Decompiled with CFR 0.152.
 */
package org.petalslink.easiestdemo.wsoui.core.bpel;

import com.ebmwebsourcing.easybpel.model.bpel.api.BPELProcess;
import com.ebmwebsourcing.easycommons.research.util.io.FileUtil;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.util.List;
import java.util.UUID;
import org.petalslink.easiestdemo.wsoui.core.WSOUIException;
import org.petalslink.easiestdemo.wsoui.core.reflexive.ImplMetaInf;

public class SCACompositeDiagramGenerator {
    private List<ImplMetaInf> allMetaInfs;
    private BPELProcess process;
    private boolean override;

    public SCACompositeDiagramGenerator(BPELProcess process, List<ImplMetaInf> allMetaInfs, boolean override) throws WSOUIException {
        this.allMetaInfs = allMetaInfs;
        this.process = process;
        this.override = override;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public File generate(String bpelUrl, String basedir) throws IOException {
        String packageName = FileUtil.createPackageNameFromTargetNamespace((String)this.process.getTargetNamespace());
        String className = this.process.getName();
        className = className.substring(0, 1).toUpperCase() + className.substring(1, className.length());
        File dir = new File(basedir + "/" + packageName.replace(".", "/"));
        if (!dir.exists()) {
            dir.mkdirs();
        }
        File f = FileUtil.createFile((String)className, (String)packageName, (String)basedir, (String)".composite_diagram", (boolean)true);
        FileWriter writer = null;
        try {
            writer = new FileWriter(f);
            writer.write("<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n");
            writer.write("<notation:Diagram xmi:version=\"2.0\" xmlns:xmi=\"http://www.omg.org/XMI\" xmlns:notation=\"http://www.eclipse.org/gmf/runtime/1.0.2/notation\" xmlns:sca=\"http://www.osoa.org/xmlns/sca/1.0\" xmi:id=\"_nqKe0CTQEeCySYkgrBf6bg\" type=\"Sca\" measurementUnit=\"Pixel\">\n");
            writer.write("\t<styles xmi:type=\"notation:DiagramStyle\" xmi:id=\"" + UUID.randomUUID() + "\"/>\n");
            writer.write("\t<element xmi:type=\"sca:DocumentRoot\" href=\"" + className + ".composite#/\"/>\n");
            writer.write("</notation:Diagram>\n");
        }
        finally {
            if (writer != null) {
                writer.close();
            }
        }
        return f;
    }
}

