package org.petalslink.easiestdemo.sdk;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

import javax.xml.namespace.QName;

public class SDK {

	private QName bpelProcess = null;

	public static void main(String[] args) throws Exception {
		SDK sdk = new SDK();

		List<String> argsList = new ArrayList<String>(Arrays.asList(args));
		List<Command> commands = sdk.analyzeArgs(argsList);

		if(commands.contains(new CommandHelp(null))) {
			CommandHelp help = (CommandHelp) commands.get(commands.indexOf(new CommandHelp(null)));
			new TaskHelp(help).execute();
		} else if(commands.contains(new CommandCreate())) {
			CommandOut out = null;
			if(commands.contains(new CommandOut(null))) {
				out = (CommandOut) commands.get(commands.indexOf(new CommandOut(null)));
			}
			if(sdk.bpelProcess == null) {
				sdk.bpelProcess = new QName("http://www.petalslink.org/easiestdemo/", "HelloWorld");
			}
			TaskCreateBpelProject task = new TaskCreateBpelProject(sdk.bpelProcess, out);
			task.execute();
			System.out.println(task.getResult());
		} else {
			CommandHelp help = new CommandHelp("Wrong arguments: " + argsList);
			new TaskHelp(help).execute();
		}
	}

	private List<Command> analyzeArgs(List<String> argsList) {
		List<Command> res = new ArrayList<Command>();

		System.out.println("Call easiestdemo with arguments: " + argsList);
		if(argsList.size() == 0) {
			res.add(new CommandHelp(null));
		} 
		if(argsList.contains("-help")) {
			argsList.remove("-help");
			res.add(new CommandHelp(null));
		} 
		if(argsList.contains("-out")) {
			if(argsList.size() > argsList.indexOf("-out") + 1) {
				String value = argsList.remove(argsList.indexOf("-out") + 1);
				System.out.println("value = " + value);
				if(value.startsWith("-")) {
					argsList.clear();
					res.add(new CommandHelp("Wrong arguments: " + argsList));
				}
				res.add(new CommandOut(value));
				argsList.remove("-out");
			} else {
				argsList.clear();
				res.add(new CommandHelp(null));
			}
		} 
		if(argsList.contains("-create")) {
			argsList.remove("-create");
			res.add(new CommandCreate());
		} 

		if(argsList.size() == 1) {
			this.bpelProcess = QName.valueOf(argsList.get(0));
		}

		return res;
	}
}
