/*******************************************************************************
 * Easybpmn - Java library for BPMN 2.0 - Copyright (C) 2011 EBM Websourcing, http://www.ebmwebsourcing.com/
 * 
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 * 
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 * 
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA
 ******************************************************************************/
package com.ebmwebsourcing.easybpmn.bpmn20.api.type;

import javax.xml.namespace.QName;

import com.ebmwebsourcing.easybox.api.with.WithName;
import com.ebmwebsourcing.easybpmn.bpmn20.api.element.ConversationAssociation;
import com.ebmwebsourcing.easybpmn.bpmn20.api.element.ConversationLink;
import com.ebmwebsourcing.easybpmn.bpmn20.api.element.ConversationNode;
import com.ebmwebsourcing.easybpmn.bpmn20.api.element.CorrelationKey;
import com.ebmwebsourcing.easybpmn.bpmn20.api.element.MessageFlow;
import com.ebmwebsourcing.easybpmn.bpmn20.api.element.MessageFlowAssociation;
import com.ebmwebsourcing.easybpmn.bpmn20.api.element.Participant;
import com.ebmwebsourcing.easybpmn.bpmn20.api.element.ParticipantAssociation;
import com.ebmwebsourcing.easybpmn.bpmn20.api.with.WithArtifact;

public interface TCollaboration extends TRootElement, WithName, WithArtifact {
	void addParticipant(Participant p);
	
	void removeParticipant(Participant p);
	
	Participant[] getParticipant();
	
	Participant getParticipant(String id);

	boolean hasParticipant();

	void unsetParticipant();
	
	void addMessageFlow(MessageFlow mf);
	
	void removeMessageFlow(MessageFlow mf);

	MessageFlow[] getMessageFlow();

	boolean hasMessageFlow();

	void unsetMessageFlow();

	ConversationNode[] getConversationNode();

	boolean hasConversationNode();

	void unsetConversationNode();

	ConversationAssociation[] getConversationAssociation();

	boolean hasConversationAssociation();

	void unsetConversationAssociation();

	ParticipantAssociation[] getParticipantAssociation();

	boolean hasParticipantAssociation();

	void unsetParticipantAssociation();

	MessageFlowAssociation[] getMessageFlowAssociation();

	boolean hasMessageFlowAssociation();

	void unsetMessageFlowAssociation();

	CorrelationKey[] getCorrelationKey();

	boolean hasCorrelationKey();

	void unsetCorrelationKey();
	
	QName[] getChoreographyRef();

	boolean hasChoreographyRef();

	void unsetChoreographyRef();
	
	void addChoreographyRef(QName ref);
	
	void removeChoreographyRef(QName ref);

	ConversationLink[] getConversationLink();

	boolean hasConversationLink();

	void unsetConversationLink();

	boolean isIsClosed();

	void setIsClosed(boolean value);

	boolean hasIsClosed();

	void unsetIsClosed();

}
