/*******************************************************************************
 * Easybpmn - Java library for BPMN 2.0 - Copyright (C) 2011 EBM Websourcing, http://www.ebmwebsourcing.com/
 * 
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 * 
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 * 
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA
 ******************************************************************************/
package com.ebmwebsourcing.easybpmn.bpmn20.impl;

import java.util.List;

import javax.xml.namespace.QName;

import com.ebmwebsourcing.easybox.api.XmlContext;
import com.ebmwebsourcing.easybox.api.XmlObject;
import com.ebmwebsourcing.easybpmn.bpmn20.api.element.DataInput;
import com.ebmwebsourcing.easybpmn.bpmn20.api.element.DataInputAssociation;
import com.ebmwebsourcing.easybpmn.bpmn20.api.element.EventDefinition;
import com.ebmwebsourcing.easybpmn.bpmn20.api.element.InputSet;
import com.ebmwebsourcing.easybpmn.bpmn20.api.type.TThrowEvent;

import easybox.org.omg.spec.bpmn._20100524.model.EJaxbTDataInput;
import easybox.org.omg.spec.bpmn._20100524.model.EJaxbTDataInputAssociation;
import easybox.org.omg.spec.bpmn._20100524.model.EJaxbTEventDefinition;
import easybox.org.omg.spec.bpmn._20100524.model.EJaxbTThrowEvent;

abstract class AbstractTThrowEventImpl<Model extends EJaxbTThrowEvent>
extends AbstractTEventImpl<Model> implements TThrowEvent{

	protected AbstractTThrowEventImpl(XmlContext xmlContext, Model jaxbModel) {
		super(xmlContext, jaxbModel);
	}

	@Override
	public EventDefinition[] getEventDefinition() {
		XmlObject[] tab = createChildrenArray(getModelObject().getEventDefinition(), EJaxbTEventDefinition.class, ANY_QNAME);
		EventDefinition[] result = new EventDefinition[tab.length];
		for(int i=0; i<tab.length; i++){
			result[i] = (EventDefinition) tab[i];
		}
		return result;
	}
	
	@Override
	public void addEventDefinition(EventDefinition eventDef){
		addToChildren(getModelObject().getEventDefinition(), eventDef);
	}
	
	@Override
	public void removeEventDefinition(EventDefinition eventDef){
		removeFromChildren(getModelObject().getEventDefinition(), eventDef);
	}
	
	@Override
	public boolean hasEventDefinition() {
		return this.getModelObject().isSetEventDefinition();
	}

	@Override
	public void unsetEventDefinition() {
		this.getModelObject().unsetEventDefinition();

	}

	@Override
	public QName[] getEventDefinitionRef() {
		List<QName> l = this.getModelObject().getEventDefinitionRef();
		return l.toArray(new QName[l.size()]);
	}
	
	@Override
	public void addEventDefinitionRef(QName ref) {
		getModelObject().getEventDefinitionRef().add(ref);
	}
	
	@Override
	public void removeEventDefinitionRef(QName ref) {
		getModelObject().getEventDefinitionRef().remove(ref);
	}

	@Override
	public boolean hasEventDefinitionRef() {
		return this.getModelObject().isSetEventDefinitionRef();
	}

	@Override
	public void unsetEventDefinitionRef() {
		this.getModelObject().unsetEventDefinitionRef();
	}

	@Override
    public void addDataInput(DataInput d) {
        addToChildren(getModelObject().getDataInput(), d);
    }
    
    @Override
    public void removeDataInput(DataInput d) {
        removeFromChildren(getModelObject().getDataInput(), d);
    }
	
	@Override
	public DataInput[] getDataInput() {
		return createChildrenArray(getModelObject().getDataInput(),
				EJaxbTDataInput.class, ANY_QNAME, DataInputImpl.class);
	}

	@Override
	public boolean hasDataInput() {
		return this.getModelObject().isSetDataInput();
	}

	@Override
	public void unsetDataInput() {
		this.getModelObject().unsetDataInput();
	}
	
	@Override
	public DataInputAssociation[] getDataInputAssociation() {
		return createChildrenArray(getModelObject().getDataInputAssociation(),
				EJaxbTDataInputAssociation.class, ANY_QNAME,
				DataInputAssociationImpl.class);
	}

	@Override
	public boolean hasDataInputAssociation() {
		return this.getModelObject().isSetDataInputAssociation();
	}

	@Override
	public void unsetDataInputAssociation() {
		this.getModelObject().unsetDataInputAssociation();
	}
	
	@Override
	public void addDataInputAssociation(DataInputAssociation dia){
		this.getModelObject().getDataInputAssociation().add(((DataInputAssociationImpl)dia).getModelObject());
	}
	
	@Override
	public void removeDataInputAssociation(DataInputAssociation dia){
		this.getModelObject().getDataInputAssociation().remove(((DataInputAssociationImpl)dia).getModelObject());
	}

	@Override
	public InputSet getInputSet() {
		return this.getXmlContext().getXmlObjectFactory()
				.wrap(this.getModelObject().getInputSet(), InputSetImpl.class);
	}

	@Override
	public void setInputSet(InputSet value) {
		this.getModelObject().setInputSet(((InputSetImpl)value).getModelObject());
	}

	@Override
	public boolean hasInputSet() {
		return this.getModelObject().isSetInputSet();
	}

}
