/*******************************************************************************
 * Easybpmn - Java library for BPMN 2.0 - Copyright (C) 2011 EBM Websourcing, http://www.ebmwebsourcing.com/
 * 
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 * 
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 * 
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA
 ******************************************************************************/
package com.ebmwebsourcing.easybpmn.bpmn20.impl;

import java.util.List;

import javax.xml.namespace.QName;

import com.ebmwebsourcing.easybox.api.XmlContext;
import com.ebmwebsourcing.easybpmn.bpmn20.api.type.TChoreographyTask;

import easybox.org.omg.spec.bpmn._20100524.model.EJaxbTChoreographyTask;

class TChoreographyTaskImpl extends AbstractTChoreographyActivityImpl<EJaxbTChoreographyTask> implements
TChoreographyTask {

	protected TChoreographyTaskImpl(XmlContext xmlContext,
			EJaxbTChoreographyTask jaxbModel) {
		super(xmlContext, jaxbModel);
	}
	
//	@SuppressWarnings("serial")
//	private class TooMuchParticipantException extends RuntimeException {
//		private TooMuchParticipantException(int participants) {
//			super("A choreography task can only have two participant references (currently has "+participants+").");
//		}
//	} 
	
	@Override
//	/**
//	 * A choreography task can only have two participant references
//	 * @throw 
//	 */
	public void addParticipantRef(QName ref){
//		if(hasParticipantRef() && getParticipantRef().length>=2) {
//			throw new TooMuchParticipantException(getParticipantRef().length);
//		}
		super.addParticipantRef(ref);
	}

	@Override
	public QName[] getMessageFlowRef() {
		List<QName> l = this.getModelObject().getMessageFlowRef();
		return l.toArray(new QName[l.size()]);
	}

	@Override
	public boolean hasMessageFlowRef() {
		return this.getModelObject().isSetMessageFlowRef();
	}

	@Override
	public void unsetMessageFlowRef() {
		this.getModelObject().unsetMessageFlowRef();
	}

	@Override
	protected Class<? extends EJaxbTChoreographyTask> getCompliantModelClass() {
		return EJaxbTChoreographyTask.class;
	}

	@Override
	public void addMessageFlowRef(QName ref) {
		getModelObject().getMessageFlowRef().add(ref);
	}

	@Override
	public void removeMessageFlowRef(QName ref) {
		getModelObject().getMessageFlowRef().remove(ref);
	}

	
}
