/*******************************************************************************
 * Easybpmn - Java library for BPMN 2.0 - Copyright (C) 2011 EBM Websourcing, http://www.ebmwebsourcing.com/
 * 
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 * 
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 * 
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA
 ******************************************************************************/
package com.ebmwebsourcing.easybpmn.bpmn20.impl;

import com.ebmwebsourcing.easybox.api.XmlContext;
import com.ebmwebsourcing.easybpmn.bpmn20.api.element.DataInput;
import com.ebmwebsourcing.easybpmn.bpmn20.api.element.DataOutput;
import com.ebmwebsourcing.easybpmn.bpmn20.api.element.InputSet;
import com.ebmwebsourcing.easybpmn.bpmn20.api.element.OutputSet;
import com.ebmwebsourcing.easybpmn.bpmn20.api.type.TInputOutputSpecification;

import easybox.org.omg.spec.bpmn._20100524.model.EJaxbTDataInput;
import easybox.org.omg.spec.bpmn._20100524.model.EJaxbTDataOutput;
import easybox.org.omg.spec.bpmn._20100524.model.EJaxbTInputOutputSpecification;
import easybox.org.omg.spec.bpmn._20100524.model.EJaxbTInputSet;
import easybox.org.omg.spec.bpmn._20100524.model.EJaxbTOutputSet;

class TInputOutputSpecificationImpl extends
		AbstractTBaseElementImpl<EJaxbTInputOutputSpecification> implements
		TInputOutputSpecification {

	protected TInputOutputSpecificationImpl(XmlContext xmlContext,
			EJaxbTInputOutputSpecification jaxbModel) {
		super(xmlContext, jaxbModel);
	}

	@Override
	public DataInput[] getDataInput() {
		return createChildrenArray(getModelObject().getDataInput(),
				EJaxbTDataInput.class, ANY_QNAME, DataInput.class);
	}
	
	@Override
	public void addDataInput(DataInput d) {
		addToChildren(getModelObject().getDataInput(), d);
	}
	
	@Override
	public void removeDataInput(DataInput d) {
		removeFromChildren(getModelObject().getDataInput(), d);
	}

	@Override
	public boolean hasDataInput() {
		return this.getModelObject().isSetDataInput();
	}

	@Override
	public void unsetDataInput() {
		this.getModelObject().unsetDataInput();
	}

	@Override
	public DataOutput[] getDataOutput() {
		return createChildrenArray(getModelObject().getDataOutput(),
				EJaxbTDataOutput.class, ANY_QNAME, DataOutputImpl.class);
	}
	
	@Override
	public void addDataOutput(DataOutput d) {
		addToChildren(getModelObject().getDataOutput(), d);
	}

	@Override
	public void removeDataOutput(DataOutput d) {
		removeFromChildren(getModelObject().getDataOutput(), d);
	}

	@Override
	public boolean hasDataOutput() {
		return this.getModelObject().isSetDataOutput();
	}

	@Override
	public void unsetDataOutput() {
		this.getModelObject().unsetDataOutput();
	}

	@Override
	public InputSet[] getInputSet() {
		return createChildrenArray(getModelObject().getInputSet(),
				EJaxbTInputSet.class, ANY_QNAME, InputSetImpl.class);
	}
	
	@Override
	public void addInputSet(InputSet is) {
	    addToChildren(getModelObject().getInputSet(), is);
	}

	@Override
	public void removeInputSet(InputSet is) {
	    removeFromChildren(getModelObject().getInputSet(), is);
	}

	@Override
	public boolean hasInputSet() {
		return this.getModelObject().isSetInputSet();
	}

	@Override
	public void unsetInputSet() {
		this.getModelObject().unsetInputSet();

	}

	@Override
	public OutputSet[] getOutputSet() {
		return createChildrenArray(getModelObject().getOutputSet(),
				EJaxbTOutputSet.class, ANY_QNAME, OutputSetImpl.class);
	}
	
	@Override
    public void addOutputSet(OutputSet is) {
	    addToChildren(getModelObject().getOutputSet(), is);
    }
    
    @Override
    public void removeOutputSet(OutputSet is) {
        removeFromChildren(getModelObject().getOutputSet(), is);
    }

	@Override
	public boolean hasOutputSet() {
		return this.getModelObject().isSetOutputSet();
	}

	@Override
	public void unsetOutputSet() {
		this.getModelObject().unsetOutputSet();
	}

	@Override
	protected Class<? extends EJaxbTInputOutputSpecification> getCompliantModelClass() {
		return EJaxbTInputOutputSpecification.class;
	}

}
