/*******************************************************************************
 * Easybpmn - Java library for BPMN 2.0 - Copyright (C) 2011 EBM Websourcing, http://www.ebmwebsourcing.com/
 * 
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 * 
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 * 
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA
 ******************************************************************************/
package com.ebmwebsourcing.easybpmn.bpmn20.impl;

import javax.xml.namespace.QName;

import com.ebmwebsourcing.easybox.api.XmlContext;
import com.ebmwebsourcing.easybpmn.bpmn20.api.type.TParticipantAssociation;

import easybox.org.omg.spec.bpmn._20100524.model.EJaxbTParticipantAssociation;

public class TParticipantAssociationImpl extends
		AbstractTBaseElementImpl<EJaxbTParticipantAssociation> implements
		TParticipantAssociation {

	protected TParticipantAssociationImpl(XmlContext xmlContext,
			EJaxbTParticipantAssociation jaxbModel) {
		super(xmlContext, jaxbModel);
	}


	@Override
	public QName getInnerParticipantRef() {
		return this.getModelObject().getInnerParticipantRef();
	}

	@Override
	public void setInnerParticipantRef(QName value) {
		this.getModelObject().setInnerParticipantRef(value);

	}

	@Override
	public boolean hasInnerParticipantRef() {
		return this.getModelObject().isSetInnerParticipantRef();
	}

	@Override
	public QName getOuterParticipantRef() {
		return this.getModelObject().getOuterParticipantRef();
	}

	@Override
	public void setOuterParticipantRef(QName value) {
		this.getModelObject().setOuterParticipantRef(value);

	}

	@Override
	public boolean hasOuterParticipantRef() {
		return this.getModelObject().isSetOuterParticipantRef();
	}

	@Override
	protected Class<? extends EJaxbTParticipantAssociation> getCompliantModelClass() {
		return EJaxbTParticipantAssociation.class;
	}
}
