/*******************************************************************************
 * Easybpmn - Java library for BPMN 2.0 - Copyright (C) 2011 EBM Websourcing, http://www.ebmwebsourcing.com/
 * 
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 * 
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 * 
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA
 ******************************************************************************/
package com.ebmwebsourcing.easybpmn.bpmn20.impl;

import java.util.List;

import javax.xml.namespace.QName;

import com.ebmwebsourcing.easybox.api.XmlContext;
import com.ebmwebsourcing.easybpmn.bpmn20.api.element.ParticipantMultiplicity;
import com.ebmwebsourcing.easybpmn.bpmn20.api.type.TParticipant;

import easybox.org.omg.spec.bpmn._20100524.model.EJaxbTParticipant;

public class TParticipantImpl extends
		AbstractTBaseElementImpl<EJaxbTParticipant> implements TParticipant {

	protected TParticipantImpl(XmlContext xmlContext,
			EJaxbTParticipant jaxbModel) {
		super(xmlContext, jaxbModel);
	}


	@Override
	public QName[] getInterfaceRef() {
		List<QName> l = this.getModelObject().getInterfaceRef();
		return l.toArray(new QName[l.size()]);
	}
	
	@Override
	public void addInterfaceRef(QName ref) {
		this.getModelObject().getInterfaceRef().add(ref);
	}

	@Override
	public void removeInterfaceRef(QName ref) {
		this.getModelObject().getInterfaceRef().remove(ref);
	}

	@Override
	public boolean hasInterfaceRef() {
		return this.getModelObject().isSetInterfaceRef();
	}

	@Override
	public void unsetInterfaceRef() {
		this.getModelObject().unsetInterfaceRef();
	}

	@Override
	public QName[] getEndPointRef() {
		List<QName> l = this.getModelObject().getEndPointRef();
		return l.toArray(new QName[l.size()]);
	}
	
	@Override
	public void addEndpointRef(QName ref) {
	    this.getModelObject().getEndPointRef().add(ref);
	}

	@Override
	public void removeEndPointRef(QName ref) {
	    this.getModelObject().getEndPointRef().remove(ref);
	}

	@Override
	public boolean hasEndPointRef() {
		return this.getModelObject().isSetEndPointRef();
	}

	@Override
	public void unsetEndPointRef() {
		this.getModelObject().unsetEndPointRef();
	}

	@Override
	public ParticipantMultiplicity getParticipantMultiplicity() {
		return this
				.getXmlContext()
				.getXmlObjectFactory()
				.wrap(this.getModelObject().getParticipantMultiplicity(),
						ParticipantMultiplicityImpl.class);
	}

	@Override
	public void setParticipantMultiplicity(ParticipantMultiplicity value) {
		this.getModelObject().setParticipantMultiplicity(
				((ParticipantMultiplicityImpl)value).getModelObject());
	}

	@Override
	public boolean hasParticipantMultiplicity() {
		return this.getModelObject().isSetParticipantMultiplicity();
	}

	@Override
	public String getName() {
		return this.getModelObject().getName();
	}

	@Override
	public void setName(String value) {
		this.getModelObject().setName(value);
	}

	@Override
	public boolean hasName() {
		return this.getModelObject().isSetName();
	}

	@Override
	public QName getProcessRef() {
		return this.getModelObject().getProcessRef();
	}

	@Override
	public void setProcessRef(QName value) {
		this.getModelObject().setProcessRef(value);

	}

	@Override
	public boolean hasProcessRef() {
		return this.getModelObject().isSetProcessRef();
	}

	@Override
	protected Class<? extends EJaxbTParticipant> getCompliantModelClass() {
		return EJaxbTParticipant.class;
	}

}