/*
 * Decompiled with CFR 0.152.
 */
package com.ebmwebsourcing.easybpmn.bpmn20.api;

import com.ebmwebsourcing.easybox.api.AbstractXmlObjectTestSuite;
import com.ebmwebsourcing.easybox.api.ObjectUnderTestFactory;
import com.ebmwebsourcing.easybox.api.TestData;
import com.ebmwebsourcing.easybpmn.bpmn20.api.ImportType;
import com.ebmwebsourcing.easybpmn.bpmn20.api.element.Definitions;
import com.ebmwebsourcing.easybpmn.bpmn20.api.element.Import;
import com.ebmwebsourcing.easyschema10.api.element.Schema;
import junit.framework.Assert;
import org.junit.Test;

public class ImportTestSuite
extends AbstractXmlObjectTestSuite {
    public static final String EXPECTED_IMPORT_TYPE = "expectedType";

    public ImportTestSuite(String label, ObjectUnderTestFactory objectUnderTestFactory, TestData testData) {
        super(label, objectUnderTestFactory, testData);
    }

    @Test
    public void testSimpleGettersSetters() {
        Import i = (Import)this.newObjectUnderTest();
        String it = "newImportType";
        i.setImportType(it);
        Assert.assertEquals((String)it, (String)i.getImportType());
        i.setImportType(null);
        Assert.assertFalse((boolean)i.hasImportType());
        Assert.assertEquals(null, (String)i.getImportType());
        String l = "newLocation";
        i.setLocation(l);
        Assert.assertEquals((String)l, (String)i.getLocation());
        String ns = "newNS";
        i.setNamespace(ns);
        Assert.assertEquals((String)ns, (String)i.getNamespace());
    }

    @Test
    public void testGetImportContent() {
        Import i = (Import)this.newObjectUnderTest();
        try {
            if (i.isXSDImport()) {
                Schema s = i.getSchema();
                Assert.assertNotNull((Object)s);
                Assert.assertEquals((String)i.getNamespace(), (String)s.getTargetNamespace());
            } else if (i.isBPMN20Import()) {
                Definitions defs = i.getBPMNDefinitions();
                Assert.assertNotNull((Object)defs);
                Assert.assertEquals((String)i.getNamespace(), (String)defs.getTargetNamespace());
            } else if (!i.isWSDL20Import() && i.isWSDL11Import()) {
                com.ebmwebsourcing.easywsdl11.api.element.Definitions defs = i.getWSDL11Definitions();
                Assert.assertNotNull((Object)defs);
                Assert.assertEquals((String)i.getNamespace(), (String)defs.getTargetNamespace());
            }
        }
        catch (Throwable e) {
            e.printStackTrace();
            Assert.fail((String)e.getMessage());
        }
    }

    @Test
    public void testImportType() {
        Import i = (Import)this.newObjectUnderTest();
        if (this.getTestData(EXPECTED_IMPORT_TYPE) != null) {
            Assert.assertEquals((Object)this.getTestData(EXPECTED_IMPORT_TYPE), (Object)ImportType.fromValue((String)i.getImportType()));
        }
        if (i.getImportType() == null) {
            return;
        }
        ImportType it = ImportType.fromValue((String)i.getImportType());
        if (it == null) {
            Assert.assertFalse((boolean)i.isBPMN20Import());
            Assert.assertFalse((boolean)i.isWSDL11Import());
            Assert.assertFalse((boolean)i.isWSDL20Import());
            Assert.assertFalse((boolean)i.isXSDImport());
        } else {
            switch (it) {
                case BPMN20: {
                    Assert.assertTrue((boolean)i.isBPMN20Import());
                    Assert.assertFalse((boolean)i.isWSDL11Import());
                    Assert.assertFalse((boolean)i.isWSDL20Import());
                    Assert.assertFalse((boolean)i.isXSDImport());
                    break;
                }
                case WSDL20: {
                    Assert.assertFalse((boolean)i.isBPMN20Import());
                    Assert.assertFalse((boolean)i.isWSDL11Import());
                    Assert.assertTrue((boolean)i.isWSDL20Import());
                    Assert.assertFalse((boolean)i.isXSDImport());
                    break;
                }
                case WSDL11: {
                    Assert.assertFalse((boolean)i.isBPMN20Import());
                    Assert.assertTrue((boolean)i.isWSDL11Import());
                    Assert.assertFalse((boolean)i.isWSDL20Import());
                    Assert.assertFalse((boolean)i.isXSDImport());
                    break;
                }
                case XSD: {
                    Assert.assertFalse((boolean)i.isBPMN20Import());
                    Assert.assertFalse((boolean)i.isWSDL11Import());
                    Assert.assertFalse((boolean)i.isWSDL20Import());
                    Assert.assertTrue((boolean)i.isXSDImport());
                }
            }
        }
    }
}

